/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.multimob.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.io.FileUtils;

public class FileUtil {
    public static void createTextFilesForModInfo(File directory) throws IOException {
        FileUtil.listResourcesForRegistry(directory, "allEntities", ForgeRegistries.ENTITIES.getKeys());
        FileUtil.listResourcesForRegistry(directory, "allItems", ForgeRegistries.ITEMS.getKeys());
        FileUtil.listResourcesForRegistry(directory, "allBlocks", ForgeRegistries.BLOCKS.getKeys());
        FileUtil.listResourcesForRegistry(directory, "allPotions", ForgeRegistries.POTIONS.getKeys());
        FileUtil.listResourcesForRegistry(directory, "allPotionTypes", ForgeRegistries.POTION_TYPES.getKeys());
        FileUtil.listResourcesForRegistry(directory, "allEnchantments", ForgeRegistries.ENCHANTMENTS.getKeys());
        FileUtil.listBiomeResources(directory, "allBiomes", "allBiomeTypes");
        FileUtil.listBlockStateResources(directory, "allBlockStates");
        FileUtil.listStructureResources(directory, "allVanillaStructures");
    }

    public static void listResourcesForRegistry(File directory, String fileName, Set<ResourceLocation> registry) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ResourceLocation loc : registry) {
            arrayList.add(loc.toString());
        }
        FileUtil.createTextFile(directory, fileName, arrayList);
    }

    public static void listBlockStateResources(File directory, String fileName) throws IOException {
        ArrayList blockList = new ArrayList();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Block loc : ForgeRegistries.BLOCKS.getValuesCollection()) {
            for (IBlockState state : loc.func_176194_O().func_177619_a()) {
                arrayList.add(state.toString());
            }
        }
        FileUtil.createTextFile(directory, fileName, arrayList);
    }

    public static void listBiomeResources(File directory, String fileName, String fileName2) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayListTypes = new ArrayList<String>();
        for (ResourceLocation loc : ForgeRegistries.BIOMES.getKeys()) {
            arrayList.add(loc.toString());
            Set types = BiomeDictionary.getTypes((Biome)((Biome)ForgeRegistries.BIOMES.getValue(loc)));
            if (types == null || types.isEmpty()) continue;
            for (BiomeDictionary.Type type : types) {
                if (arrayListTypes.contains(type.getName())) continue;
                arrayListTypes.add(type.getName());
            }
        }
        FileUtil.createTextFile(directory, fileName, arrayList);
        FileUtil.createTextFile(directory, fileName2, arrayListTypes);
    }

    public static void listStructureResources(File directory, String fileName) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Stronghold");
        arrayList.add("Mansion");
        arrayList.add("Monument");
        arrayList.add("Village");
        arrayList.add("Mineshaft");
        arrayList.add("Temple");
        arrayList.add("Fortress");
        arrayList.add("EndCity");
        FileUtil.createTextFile(directory, fileName, arrayList);
    }

    public static void createTextFile(File directory, String fileName, List<String> list) throws IOException {
        File textFile = new File(directory, fileName + ".txt");
        if (textFile.exists()) {
            textFile.delete();
        }
        FileUtils.writeLines((File)textFile, list);
    }
}

