/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.multimob.spawn;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.daveyx0.multimob.config.MMConfig;
import net.daveyx0.multimob.config.MMConfigSpawns;
import net.daveyx0.multimob.core.MultiMob;
import net.daveyx0.multimob.spawn.MMConfigSpawnEntry;
import net.daveyx0.multimob.spawn.MMSpawnEntry;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.init.Biomes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class MMSpawnRegistry {
    public static final List<MMSpawnEntry> SPAWNS = new ArrayList<MMSpawnEntry>();

    public static void registerFillerSpawns() {
        MMSpawnRegistry.registerSpawnEntry(new MMConfigSpawnEntry("_Filler_MMMonster", "multimob:dummy", 100, false).setupBaseMobSpawnEntry(false).setCreatureType("MULTIMOBMONSTER"));
        MMSpawnRegistry.registerSpawnEntry(new MMConfigSpawnEntry("_Filler_MMPassive", "multimob:dummy", 50, false).setupBaseMobSpawnEntry(false).setCreatureType("MULTIMOBPASSIVE"));
        MMSpawnRegistry.registerSpawnEntry(new MMConfigSpawnEntry("_Filler_MMWater", "multimob:dummy", 50, false).setupBaseMobSpawnEntry(false).setCreatureType("MULTIMOBWATER"));
        MMSpawnRegistry.registerSpawnEntry(new MMConfigSpawnEntry("_Filler_MMLava", "multimob:dummy", 50, false).setupBaseMobSpawnEntry(false).setCreatureType("MULTIMOBLAVA"));
    }

    public static List<MMSpawnEntry> getSpawnEntries() {
        return SPAWNS;
    }

    public static void loadSpawns() {
        SPAWNS.clear();
        for (MMConfigSpawnEntry configEntry : MMConfig.CONFIGSPAWNS) {
            MMSpawnEntry entry = MMSpawnRegistry.getSpawnEntryFromConfig(configEntry);
            if (entry == null || entry.getEntityClass() == null) continue;
            SPAWNS.add(MMSpawnRegistry.getSpawnEntryFromConfig(configEntry));
        }
        MMSpawnRegistry.registerRegularSpawns();
    }

    public static void registerSpawnEntry(MMConfigSpawnEntry entry) {
        MMConfigSpawns.addConfigSpawnEntry(entry);
    }

    public static MMSpawnEntry getSpawnEntryFromEntityClass(Class<? extends Entity> entityClass) {
        for (MMSpawnEntry entry : SPAWNS) {
            if (!entry.getEntityClass().equals(entityClass)) continue;
            return entry;
        }
        return null;
    }

    public static MMSpawnEntry getSpawnEntryFromConfig(MMConfigSpawnEntry configEntry) {
        EntityEntry entry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(configEntry.entityName));
        if (entry != null) {
            return new MMSpawnEntry(configEntry.getEntryName(), entry.getEntityClass(), configEntry);
        }
        MultiMob.LOGGER.info("Was not able to make " + configEntry.getEntryName() + " entry for " + configEntry.entityName);
        return null;
    }

    public static void registerRegularSpawns() {
        for (MMSpawnEntry entry : SPAWNS) {
            MMSpawnRegistry.addRegularSpawn(entry);
            MMSpawnRegistry.setSpawnPlacementType(entry);
        }
    }

    public static void addRegularSpawn(MMSpawnEntry entry) {
        block7: {
            block8: {
                if (entry.getSpawnLimit() == 0 || entry.getSpawnWeight() == 0) break block7;
                boolean addToAllBiomes = false;
                if (entry.getBiomes() != null && !entry.getBiomes().isEmpty() || entry.getBiomeTypes() != null && !entry.getBiomeTypes().isEmpty()) break block8;
                for (Biome biome : ForgeRegistries.BIOMES) {
                    if (!entry.getIsAllowedOnPeaceful() && biome == Biomes.field_76789_p) continue;
                    biome.func_76747_a(entry.getCreatureType()).add(new Biome.SpawnListEntry(entry.getEntityClass(), entry.getSpawnWeight(), entry.getGroupSizeRange()[0], entry.getGroupSizeRange()[1]));
                }
                break block7;
            }
            HashSet<Biome> biomes = new HashSet<Biome>();
            if (entry.getBiomes() != null && !entry.getBiomes().isEmpty()) {
                for (Biome biome : entry.getBiomes()) {
                    if (!entry.getIsAllowedOnPeaceful() && biome == Biomes.field_76789_p) continue;
                    biomes.add(biome);
                }
            }
            if (entry.getBiomeTypes() != null && !entry.getBiomeTypes().isEmpty()) {
                for (Biome biome : ForgeRegistries.BIOMES) {
                    boolean typeCheck = true;
                    for (BiomeDictionary.Type biomeType : entry.getBiomeTypes()) {
                        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)biomeType)) continue;
                        typeCheck = false;
                    }
                    if (!typeCheck) continue;
                    biomes.add(biome);
                }
            }
            if (biomes == null || biomes.isEmpty()) break block7;
            for (Biome biome : biomes) {
                if (!entry.getIsAllowedOnPeaceful() && biome == Biomes.field_76789_p) continue;
                biome.func_76747_a(entry.getCreatureType()).add(new Biome.SpawnListEntry(entry.getEntityClass(), entry.getSpawnWeight(), entry.getGroupSizeRange()[0], entry.getGroupSizeRange()[1]));
            }
        }
    }

    public static void setSpawnPlacementType(MMSpawnEntry entry) {
        EntitySpawnPlacementRegistry.setPlacementType((Class)entry.getEntityClass(), (EntityLiving.SpawnPlacementType)entry.getSpawnPlacementType());
    }
}

