/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.multimob.client;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.daveyx0.multimob.core.MMItemRegistry;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class MMItemModelManager {
    public static final MMItemModelManager INSTANCE = new MMItemModelManager();
    public static final Set<Item> ITEMS = new HashSet<Item>();
    private final Set<Item> itemsRegistered = new HashSet<Item>();
    private final StateMapperBase propertyStringMapper = new StateMapperBase(){

        protected ModelResourceLocation func_178132_a(IBlockState state) {
            return new ModelResourceLocation("minecraft:air");
        }
    };

    private MMItemModelManager() {
    }

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        for (Item item : MMItemRegistry.ITEMS) {
            ITEMS.add(item);
        }
        this.registerItemModels();
    }

    private void registerItemModels() {
        ITEMS.stream().filter(item -> !this.itemsRegistered.contains(item)).forEach(this::registerItemModel);
    }

    public void registerItemColors(Item[] items) {
        this.registerItemColor(new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                return tintIndex > 0 ? -1 : MMItemModelManager.getColor(stack);
            }
        }, items);
    }

    private void registerItemColor(IItemColor itemcolor, Item ... itemsIn) {
        FMLClientHandler.instance().getClient().getItemColors().func_186730_a(itemcolor, itemsIn);
    }

    private void registerItemModel(Item item) {
        ResourceLocation registryName = Objects.requireNonNull(item.getRegistryName());
        this.registerItemModel(item, registryName.toString());
    }

    private void registerItemModel(Item item, String modelLocation) {
        ModelResourceLocation fullModelLocation = new ModelResourceLocation(modelLocation, "inventory");
        this.registerItemModel(item, fullModelLocation);
    }

    private void registerItemModel(Item item, ModelResourceLocation fullModelLocation) {
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{fullModelLocation});
        this.registerItemModel(item, stack -> fullModelLocation);
    }

    private void registerItemModel(Item item, ItemMeshDefinition meshDefinition) {
        this.itemsRegistered.add(item);
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)meshDefinition);
    }

    public static int getColor(ItemStack stack) {
        NBTTagCompound nbttagcompound1;
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        if (nbttagcompound != null && (nbttagcompound1 = nbttagcompound.func_74775_l("display")) != null && nbttagcompound1.func_150297_b("color", 3)) {
            return nbttagcompound1.func_74762_e("color");
        }
        return 0xFFFFFF;
    }
}

