/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.library.core;

import betterwithmods.library.core.BWLib;
import betterwithmods.library.core.MethodSignature;
import betterwithmods.library.core.Transformer;
import betterwithmods.library.core.entity.EquipmentDropTransformer;
import betterwithmods.library.core.entity.EquipmentTransformer;
import betterwithmods.library.core.structure.StructureComponentTransformer;
import com.google.common.collect.Sets;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ListIterator;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceMethodVisitor;

public class ClassTransformer
implements IClassTransformer {
    private static final Set<Transformer> transformers = Sets.newHashSet();

    public static boolean findMethodAndTransform(ClassNode node, MethodSignature sig, MethodAction pred) {
        String funcName = sig.funcName;
        for (MethodNode method : node.methods) {
            if (!method.name.equals(funcName) && !method.name.equals(sig.obfName) && !method.name.equals(sig.srgName) || !method.desc.equals(sig.funcDesc)) continue;
            BWLib.log("Located Method, patching...");
            boolean finish = pred.test(method);
            BWLib.log("Patch result: " + finish);
            return finish;
        }
        BWLib.log("Failed to locate the method!");
        return false;
    }

    public static MethodAction combine(NodeFilter filter, NodeAction action) {
        return mnode -> ClassTransformer.applyOnNode(mnode, filter, action);
    }

    public static boolean applyOnNode(MethodNode method, NodeFilter filter, NodeAction action) {
        ListIterator iterator = method.instructions.iterator();
        boolean didAny = false;
        while (iterator.hasNext()) {
            AbstractInsnNode anode = (AbstractInsnNode)iterator.next();
            if (!filter.test(anode)) continue;
            BWLib.log("Located patch target node " + ClassTransformer.getNodeString(anode));
            didAny = true;
            if (!action.test(method, anode)) continue;
            break;
        }
        return didAny;
    }

    private static String getNodeString(AbstractInsnNode node) {
        Textifier printer = new Textifier();
        TraceMethodVisitor visitor = new TraceMethodVisitor((Printer)printer);
        node.accept((MethodVisitor)visitor);
        StringWriter sw = new StringWriter();
        printer.print(new PrintWriter(sw));
        printer.getText().clear();
        return sw.toString().replaceAll("\n", "").trim();
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        for (Transformer transformer : transformers) {
            for (String clazz : transformer.getClasses()) {
                if (!clazz.equals(transformedName)) continue;
                return transformer.transform(basicClass);
            }
        }
        return basicClass;
    }

    static {
        transformers.add(new EquipmentTransformer());
        transformers.add(new EquipmentDropTransformer());
        transformers.add(new StructureComponentTransformer());
    }

    public static interface NodeAction
    extends BiPredicate<MethodNode, AbstractInsnNode> {
    }

    public static interface NodeFilter
    extends Predicate<AbstractInsnNode> {
    }

    public static interface MethodAction
    extends Predicate<MethodNode> {
    }
}

