/*
 * Decompiled with CFR 0.152.
 */
package de.lellson.materialchanger;

import de.lellson.materialchanger.ChangerConfig;
import de.lellson.materialchanger.ErrorMessenger;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

@Mod(modid="materialchanger", name="Material Changer", version="1.0", acceptedMinecraftVersions="[1.12.2]")
public class MaterialChanger {
    public static final String MODID = "materialchanger";
    public static final String NAME = "Material Changer";
    public static final int ARMOR_PROTECTION_INDEX = 5;
    public static final int ARMOR_TOUGHNESS_INDEX = 6;
    public static final int TOOL_EFFICIENCY_INDEX = 1;
    public static final int TOOL_DAMAGE_INDEX = 2;
    public static final int TOOL_ATTACK_SPEED_INDEX = 3;
    private static final int HOE_ATTACK_SPEED_INDEX = 0;
    public static final int SWORD_DAMAGE_INDEX = 0;
    public static final int MATERIAL_HARVEST_LEVEL_INDEX = 5;
    public static final int MATERIAL_ENCHANTABILITY_INDEX = 9;
    private static final int ARMOR_MATERIAL_ENCHANTABILITY_INDEX = 8;
    public Configuration config;
    private String[] configEntries;
    private List<Entry> entries;
    private ErrorMessenger error = new ErrorMessenger();

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.config = new Configuration(event.getSuggestedConfigurationFile());
        this.config.load();
        this.configEntries = new ChangerConfig(this).load();
        this.config.save();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        this.entries = this.toList(this.configEntries);
        for (Entry entry : this.entries) {
            switch (entry.property) {
                case ARMOR_PROTECTION: {
                    this.changeArmor(entry, false);
                    break;
                }
                case ARMOR_TOUGHNESS: {
                    this.changeArmor(entry, true);
                    break;
                }
                case ATTACK_DAMAGE: {
                    this.changeAttackDamage(entry);
                    break;
                }
                case ATTACK_SPEED: {
                    this.changeAttackSpeed(entry);
                    break;
                }
                case DURABILITY: {
                    this.changeDurability(entry);
                    break;
                }
                case EFFICIENCY: {
                    this.changeEfficiency(entry);
                    break;
                }
                case ENCHANTABILITY: {
                    this.changeMaterial(entry, 9, 8);
                    break;
                }
                case HARVEST_LEVEL: {
                    this.changeMaterial(entry, 5, -1);
                    break;
                }
                case STACKSIZE: {
                    this.changeStackSize(entry);
                }
            }
        }
    }

    private void changeStackSize(Entry entry) {
        entry.item.func_77625_d((int)entry.value);
    }

    private void changeMaterial(Entry entry, int fieldIndexTool, int fieldIndexArmor) {
        Item.ToolMaterial material = entry.getObjectFromClass(ItemTool.class, Item.ToolMaterial.class);
        if (material == null) {
            material = entry.getObjectFromClass(ItemSword.class, Item.ToolMaterial.class);
        }
        ItemArmor.ArmorMaterial armorMaterial = entry.getObjectFromClass(ItemArmor.class, ItemArmor.ArmorMaterial.class);
        boolean flag = false;
        if (material != null && fieldIndexTool >= 0) {
            ReflectionHelper.setPrivateValue(Item.ToolMaterial.class, (Object)material, (Object)((int)entry.value), (int)fieldIndexTool);
            flag = true;
        }
        if (armorMaterial != null && fieldIndexArmor >= 0) {
            ReflectionHelper.setPrivateValue(ItemArmor.ArmorMaterial.class, (Object)armorMaterial, (Object)((int)entry.value), (int)fieldIndexArmor);
            flag = true;
        }
        if (!flag) {
            this.error.add(entry.line, "Couldn't find a matching tool material or armor material for the item: " + entry.item.getRegistryName() + " (Only tools, swords and armor can have a material)");
        }
    }

    private void changeAttackSpeed(Entry entry) {
        if (entry.item instanceof ItemSword) {
            this.error.add(entry.line, "Sorry, but you can't change the attack speed of swords at the moment :(");
        } else if (entry.item instanceof ItemTool) {
            ReflectionHelper.setPrivateValue(ItemTool.class, (Object)((ItemTool)entry.item), (Object)Float.valueOf((float)entry.value - 4.0f), (int)3);
        } else if (entry.item instanceof ItemHoe) {
            ReflectionHelper.setPrivateValue(ItemHoe.class, (Object)((ItemHoe)entry.item), (Object)Float.valueOf((float)entry.value), (int)0);
        } else {
            this.error.add(entry.line, "The item is not a valid tool: " + entry.item.getRegistryName() + " (Only tools can have an attack speed value)");
        }
    }

    private void changeEfficiency(Entry entry) {
        if (entry.item instanceof ItemTool) {
            ReflectionHelper.setPrivateValue(ItemTool.class, (Object)((ItemTool)entry.item), (Object)Float.valueOf((float)entry.value), (int)1);
        }
    }

    private void changeAttackDamage(Entry entry) {
        if (entry.item instanceof ItemSword) {
            ReflectionHelper.setPrivateValue(ItemSword.class, (Object)((ItemSword)entry.item), (Object)Float.valueOf((float)entry.value - 1.0f), (int)0);
        } else if (entry.item instanceof ItemTool) {
            ReflectionHelper.setPrivateValue(ItemTool.class, (Object)((ItemTool)entry.item), (Object)Float.valueOf((float)entry.value - 1.0f), (int)2);
        } else {
            this.error.add(entry.line, "The item is not a valid tool or weapon: " + entry.item.getRegistryName() + " (Only tools and swords can have an attack damage value)");
        }
    }

    private void changeDurability(Entry entry) {
        entry.item.func_77656_e((int)entry.value);
    }

    private void changeArmor(Entry entry, boolean toughness) {
        if (entry.item instanceof ItemArmor) {
            ReflectionHelper.setPrivateValue(ItemArmor.class, (Object)((ItemArmor)entry.item), (Object)((int)entry.value), (int)(toughness ? 6 : 5));
        } else {
            this.error.add(entry.line, "The item is not a valid armor piece: " + entry.item.getRegistryName() + " (Only armor pieces can have a protection/toughness value)");
        }
    }

    private List<Entry> toList(String[] array) {
        ArrayList<Entry> list = new ArrayList<Entry>();
        for (String line : array) {
            if ((line = this.validate(line)).isEmpty()) continue;
            String[] values = line.split(";");
            if (values.length >= 3) {
                Entry entry = this.transformValues(line, values);
                if (entry == null) continue;
                list.add(entry);
                continue;
            }
            this.error.add(line, "Invalid amount of arguments: " + values.length + " (3 arguments needed! Usage: property;item;value)");
        }
        return list;
    }

    private Entry transformValues(String line, String[] values) {
        double value;
        Property prop = null;
        for (Property p : Property.values()) {
            if (!p.equals(values[0])) continue;
            prop = p;
            break;
        }
        if (prop == null) {
            this.error.add(line, "Invalid property: " + values[0] + " (Properties: ARMOR_PROTECTION, ARMOR_TOUGHNESS, ATTACK_DAMAGE, ATTACK_SPEED, DURABILITY, EFFICIENCY, ENCHANTABILITY, HARVEST_LEVEL, STACKSIZE)");
            return null;
        }
        try {
            value = Double.parseDouble(values[2]);
            value = Math.min(value, 32767.0);
        }
        catch (NumberFormatException e) {
            this.error.add(line, "Invalid value: " + values[3]);
            return null;
        }
        ItemStack item = GameRegistry.makeItemStack((String)values[1], (int)0, (int)1, (String)"");
        if (item == null) {
            this.error.add(line, "Invalid item: " + values[1] + " (Format: modid:name)");
            return null;
        }
        return new Entry(prop, item.func_77973_b(), value, line);
    }

    private String validate(String line) {
        return line.replaceAll(" ", "");
    }

    public static enum Property {
        ARMOR_PROTECTION,
        ARMOR_TOUGHNESS,
        ATTACK_DAMAGE,
        ATTACK_SPEED,
        DURABILITY,
        EFFICIENCY,
        ENCHANTABILITY,
        HARVEST_LEVEL,
        STACKSIZE;


        public boolean equals(String s) {
            return s.toLowerCase().equals(this.toString());
        }

        public String toString() {
            return super.toString().toLowerCase();
        }
    }

    public class Entry {
        public final Property property;
        public final Item item;
        public final double value;
        public final String line;

        public Entry(Property property, Item item, double value, String line) {
            this.property = property;
            this.item = item;
            this.value = value;
            this.line = line;
        }

        public <T> T getObjectFromClass(Class fromClazz, Class<T> clazz) {
            if (!fromClazz.isInstance(this.item)) {
                return null;
            }
            try {
                for (Field field : fromClazz.getDeclaredFields()) {
                    field.setAccessible(true);
                    Object object = field.get(this.item);
                    if (!clazz.isInstance(object)) continue;
                    return (T)object;
                }
            }
            catch (Exception e) {
                MaterialChanger.this.error.add(this.line, null);
                e.printStackTrace();
            }
            return null;
        }
    }
}

