/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import java.awt.Color;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLLog;

public class Fluid {
    public static final int BUCKET_VOLUME = 1000;
    protected final String fluidName;
    protected String unlocalizedName;
    protected final nf still;
    protected final nf flowing;
    @Nullable
    protected final nf overlay;
    private qe fillSound;
    private qe emptySound;
    protected int luminosity = 0;
    protected int density = 1000;
    protected int temperature = 300;
    protected int viscosity = 1000;
    protected boolean isGaseous;
    protected aje rarity = aje.a;
    protected aow block = null;
    protected int color = -1;

    public Fluid(String fluidName, nf still, nf flowing, Color color) {
        this(fluidName, still, flowing, null, color);
    }

    public Fluid(String fluidName, nf still, nf flowing, @Nullable nf overlay, Color color) {
        this(fluidName, still, flowing, overlay);
        this.setColor(color);
    }

    public Fluid(String fluidName, nf still, nf flowing, int color) {
        this(fluidName, still, flowing, null, color);
    }

    public Fluid(String fluidName, nf still, nf flowing, @Nullable nf overlay, int color) {
        this(fluidName, still, flowing, overlay);
        this.setColor(color);
    }

    public Fluid(String fluidName, nf still, nf flowing) {
        this(fluidName, still, flowing, (nf)null);
    }

    public Fluid(String fluidName, nf still, nf flowing, @Nullable nf overlay) {
        this.fluidName = fluidName.toLowerCase(Locale.ENGLISH);
        this.unlocalizedName = fluidName;
        this.still = still;
        this.flowing = flowing;
        this.overlay = overlay;
    }

    public Fluid setUnlocalizedName(String unlocalizedName) {
        this.unlocalizedName = unlocalizedName;
        return this;
    }

    public Fluid setBlock(aow block) {
        if (this.block == null || this.block == block) {
            this.block = block;
        } else {
            FMLLog.log.warn("A mod has attempted to assign Block {} to the Fluid '{}' but this Fluid has already been linked to the Block {}. You may have duplicate Fluid Blocks as a result. It *may* be possible to configure your mods to avoid this.", (Object)block, (Object)this.fluidName, (Object)this.block);
        }
        return this;
    }

    public Fluid setLuminosity(int luminosity) {
        this.luminosity = luminosity;
        return this;
    }

    public Fluid setDensity(int density) {
        this.density = density;
        return this;
    }

    public Fluid setTemperature(int temperature) {
        this.temperature = temperature;
        return this;
    }

    public Fluid setViscosity(int viscosity) {
        this.viscosity = viscosity;
        return this;
    }

    public Fluid setGaseous(boolean isGaseous) {
        this.isGaseous = isGaseous;
        return this;
    }

    public Fluid setRarity(aje rarity) {
        this.rarity = rarity;
        return this;
    }

    public Fluid setFillSound(qe fillSound) {
        this.fillSound = fillSound;
        return this;
    }

    public Fluid setEmptySound(qe emptySound) {
        this.emptySound = emptySound;
        return this;
    }

    public Fluid setColor(Color color) {
        this.color = color.getRGB();
        return this;
    }

    public Fluid setColor(int color) {
        this.color = color;
        return this;
    }

    public final String getName() {
        return this.fluidName;
    }

    public final aow getBlock() {
        return this.block;
    }

    public final boolean canBePlacedInWorld() {
        return this.block != null;
    }

    public final boolean isLighterThanAir() {
        int density = this.density;
        if (this.block instanceof BlockFluidBase) {
            density = ((BlockFluidBase)this.block).getDensity();
        }
        return density <= 0;
    }

    public boolean doesVaporize(FluidStack fluidStack) {
        if (this.block == null) {
            return false;
        }
        return this.block.t().a() == bcz.h;
    }

    public void vaporize(@Nullable aed player, amu worldIn, et pos, FluidStack fluidStack) {
        worldIn.a(player, pos, qf.bN, qg.e, 0.5f, 2.6f + (worldIn.r.nextFloat() - worldIn.r.nextFloat()) * 0.8f);
        for (int l2 = 0; l2 < 8; ++l2) {
            worldIn.a(fj.m, (double)pos.p() + Math.random(), (double)pos.q() + Math.random(), (double)pos.r() + Math.random(), 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public String getLocalizedName(FluidStack stack) {
        String s = this.getUnlocalizedName();
        return s == null ? "" : ft.a((String)s);
    }

    public String getUnlocalizedName(FluidStack stack) {
        return this.getUnlocalizedName();
    }

    public String getUnlocalizedName() {
        return "fluid." + this.unlocalizedName;
    }

    public final int getLuminosity() {
        return this.luminosity;
    }

    public final int getDensity() {
        return this.density;
    }

    public final int getTemperature() {
        return this.temperature;
    }

    public final int getViscosity() {
        return this.viscosity;
    }

    public final boolean isGaseous() {
        return this.isGaseous;
    }

    public aje getRarity() {
        return this.rarity;
    }

    public int getColor() {
        return this.color;
    }

    public nf getStill() {
        return this.still;
    }

    public nf getFlowing() {
        return this.flowing;
    }

    @Nullable
    public nf getOverlay() {
        return this.overlay;
    }

    public qe getFillSound() {
        if (this.fillSound == null) {
            this.fillSound = this.getBlock() != null && this.getBlock().t().a() == bcz.i ? qf.T : qf.S;
        }
        return this.fillSound;
    }

    public qe getEmptySound() {
        if (this.emptySound == null) {
            this.emptySound = this.getBlock() != null && this.getBlock().t().a() == bcz.i ? qf.R : qf.Q;
        }
        return this.emptySound;
    }

    public int getLuminosity(FluidStack stack) {
        return this.getLuminosity();
    }

    public int getDensity(FluidStack stack) {
        return this.getDensity();
    }

    public int getTemperature(FluidStack stack) {
        return this.getTemperature();
    }

    public int getViscosity(FluidStack stack) {
        return this.getViscosity();
    }

    public boolean isGaseous(FluidStack stack) {
        return this.isGaseous();
    }

    public aje getRarity(FluidStack stack) {
        return this.getRarity();
    }

    public int getColor(FluidStack stack) {
        return this.getColor();
    }

    public nf getStill(FluidStack stack) {
        return this.getStill();
    }

    public nf getFlowing(FluidStack stack) {
        return this.getFlowing();
    }

    public qe getFillSound(FluidStack stack) {
        return this.getFillSound();
    }

    public qe getEmptySound(FluidStack stack) {
        return this.getEmptySound();
    }

    public int getLuminosity(amu world, et pos) {
        return this.getLuminosity();
    }

    public int getDensity(amu world, et pos) {
        return this.getDensity();
    }

    public int getTemperature(amu world, et pos) {
        return this.getTemperature();
    }

    public int getViscosity(amu world, et pos) {
        return this.getViscosity();
    }

    public boolean isGaseous(amu world, et pos) {
        return this.isGaseous();
    }

    public aje getRarity(amu world, et pos) {
        return this.getRarity();
    }

    public int getColor(amu world, et pos) {
        return this.getColor();
    }

    public nf getStill(amu world, et pos) {
        return this.getStill();
    }

    public nf getFlowing(amu world, et pos) {
        return this.getFlowing();
    }

    public qe getFillSound(amu world, et pos) {
        return this.getFillSound();
    }

    public qe getEmptySound(amu world, et pos) {
        return this.getEmptySound();
    }
}

