/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.terraingen;

import java.util.Random;
import net.minecraftforge.event.world.WorldEvent;

public class InitNoiseGensEvent<T extends Context>
extends WorldEvent {
    private final Random rand;
    private final T original;
    private T newValues;

    public InitNoiseGensEvent(amu world, Random rand, T original) {
        super(world);
        this.rand = rand;
        this.original = original;
        this.newValues = ((Context)original).clone();
    }

    public Random getRandom() {
        return this.rand;
    }

    public T getOriginal() {
        return this.original;
    }

    public T getNewValues() {
        return this.newValues;
    }

    public static class ContextHell
    extends Context {
        private bcp perlin2;
        private bcp perlin3;

        public ContextHell(bcp lperlin1, bcp lperlin2, bcp perlin, bcp perlin2, bcp perlin3, bcp scale, bcp depth) {
            super(lperlin1, lperlin2, perlin, scale, depth);
            this.perlin2 = perlin2;
            this.perlin3 = perlin3;
        }

        @Override
        public ContextHell clone() {
            return new ContextHell(this.getLPerlin1(), this.getLPerlin2(), this.getPerlin(), this.perlin2, this.perlin3, this.getScale(), this.getDepth());
        }

        public bcp getPerlin2() {
            return this.perlin2;
        }

        public bcp getPerlin3() {
            return this.perlin3;
        }

        public void getPerlin2(bcp value) {
            this.perlin2 = value;
        }

        public void getPerlin3(bcp value) {
            this.perlin3 = value;
        }
    }

    public static class ContextEnd
    extends Context {
        private bct island;

        public ContextEnd(bcp lperlin1, bcp lperlin2, bcp perlin, bcp scale, bcp depth, bct island) {
            super(lperlin1, lperlin2, perlin, scale, depth);
            this.island = island;
        }

        @Override
        public ContextEnd clone() {
            return new ContextEnd(this.getLPerlin1(), this.getLPerlin2(), this.getPerlin(), this.getScale(), this.getDepth(), this.island);
        }

        public bct getIsland() {
            return this.island;
        }

        public void getIsland(bct value) {
            this.island = value;
        }
    }

    public static class ContextOverworld
    extends Context {
        private bcq height;
        private bcp forest;

        public ContextOverworld(bcp lperlin1, bcp lperlin2, bcp perlin, bcq height, bcp scale, bcp depth, bcp forest) {
            super(lperlin1, lperlin2, perlin, scale, depth);
            this.height = height;
            this.forest = forest;
        }

        @Override
        public ContextOverworld clone() {
            return new ContextOverworld(this.getLPerlin1(), this.getLPerlin2(), this.getPerlin(), this.height, this.getScale(), this.getDepth(), this.forest);
        }

        public bcq getHeight() {
            return this.height;
        }

        public bcp getForest() {
            return this.forest;
        }

        public void getHeight(bcq value) {
            this.height = value;
        }

        public void getForest(bcp value) {
            this.forest = value;
        }
    }

    public static class Context {
        private bcp lperlin1;
        private bcp lperlin2;
        private bcp perlin;
        private bcp scale;
        private bcp depth;

        public Context(bcp lperlin1, bcp lperlin2, bcp perlin, bcp scale, bcp depth) {
            this.lperlin1 = lperlin1;
            this.lperlin2 = lperlin2;
            this.perlin = perlin;
            this.scale = scale;
            this.depth = depth;
        }

        public bcp getLPerlin1() {
            return this.lperlin1;
        }

        public bcp getLPerlin2() {
            return this.lperlin2;
        }

        public bcp getPerlin() {
            return this.perlin;
        }

        public bcp getScale() {
            return this.scale;
        }

        public bcp getDepth() {
            return this.depth;
        }

        public void setLPerlin1(bcp value) {
            this.lperlin1 = value;
        }

        public void getLPerlin2(bcp value) {
            this.lperlin2 = value;
        }

        public void getPerlin(bcp value) {
            this.perlin = value;
        }

        public void getScale(bcp value) {
            this.scale = value;
        }

        public void getDepth(bcp value) {
            this.depth = value;
        }

        public Context clone() {
            return new Context(this.lperlin1, this.lperlin2, this.perlin, this.scale, this.depth);
        }
    }
}

