/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.resource;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraftforge.client.resource.IResourceType;
import net.minecraftforge.client.resource.ReloadRequirements;
import net.minecraftforge.common.ForgeModContainer;

public enum SelectiveReloadStateHandler {
    INSTANCE;

    @Nullable
    private Predicate<IResourceType> currentPredicate = null;

    public void beginReload(Predicate<IResourceType> resourcePredicate) {
        if (this.currentPredicate != null) {
            throw new IllegalStateException("Recursive resource reloading detected");
        }
        this.currentPredicate = resourcePredicate;
    }

    public Predicate<IResourceType> get() {
        if (this.currentPredicate == null || !ForgeModContainer.selectiveResourceReloadEnabled) {
            return ReloadRequirements.all();
        }
        return this.currentPredicate;
    }

    public void endReload() {
        this.currentPredicate = null;
    }
}

