/*
 * Decompiled with CFR 0.152.
 */
package zabi.minecraft.minerva.common.entity.synchronization;

import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import zabi.minecraft.minerva.common.entity.UUIDs;

public abstract class SyncTask<T extends EntityLivingBase>
implements Runnable,
INBTSerializable<NBTTagCompound> {
    private T instance = null;
    private UUID referrer = UUIDs.NULL_UUID;

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("class", this.getClass().getCanonicalName());
        this.writeToNBT(tag);
        return tag;
    }

    @Override
    public void run() {
        this.execute(this.instance);
        this.cleanUp();
    }

    protected abstract void execute(T var1);

    protected SyncTask<T> entityFound(EntityLivingBase entity) {
        this.onEntityConnected(entity);
        return this;
    }

    private final void onEntityConnected(EntityLivingBase entity) {
        this.instance = entity;
    }

    public final void cleanUp() {
        this.instance = null;
    }

    public void setReferrer(UUID referrer) {
        this.referrer = referrer == null ? UUIDs.NULL_UUID : referrer;
    }

    public UUID getReferrer() {
        return this.referrer;
    }

    protected abstract void writeToNBT(NBTTagCompound var1);
}

