/*
 * Decompiled with CFR 0.152.
 */
package alexndr.api.helpers.game;

import alexndr.api.helpers.game.GenDetails;
import alexndr.api.helpers.game.OreGenHelper;
import alexndr.api.logger.LogHelper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class OreGenerator
implements IWorldGenerator {
    private static HashMap<Integer, List<GenDetails>> genMap = new HashMap();

    public static void registerOreForGen(int dimension, Block blockToGenerate, Block blockToReplace, int spawnRate, int veinSize, int minHeight, int maxHeight) {
        OreGenerator.registerOreForGen(dimension, blockToGenerate, blockToReplace, true, spawnRate, veinSize, minHeight, maxHeight);
    }

    public static void registerOreForGen(int dimension, Block blockToGenerate, Block blockToReplace, boolean replaceOreGenBlocks, int spawnRate, int veinSize, int minHeight, int maxHeight) {
        GenDetails details = new GenDetails(dimension, blockToGenerate, blockToReplace, replaceOreGenBlocks, spawnRate, veinSize, minHeight, maxHeight);
        if (genMap.containsKey(dimension)) {
            genMap.get(dimension).add(details);
        } else {
            ArrayList list = Lists.newArrayList();
            list.add(details);
            genMap.put(dimension, list);
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int xCoord = chunkX * 16;
        int zCoord = chunkZ * 16;
        if (genMap.containsKey(world.field_73011_w.getDimension())) {
            for (GenDetails details : genMap.get(world.field_73011_w.getDimension())) {
                if (details.maxHeight <= details.minHeight) {
                    LogHelper.warning("WorldGen: Max height is lower than min height! BlockToGenerate: " + details.blockToGenerate.func_149739_a() + ", BlockToReplace: " + details.blockToReplace.func_149739_a());
                    continue;
                }
                for (int i = 0; i < details.spawnRate; ++i) {
                    int randPosX = xCoord + random.nextInt(16);
                    int randPosY = random.nextInt(details.maxHeight - details.minHeight);
                    int randPosZ = zCoord + random.nextInt(16);
                    new OreGenHelper(details.blockToGenerate, details.blockToReplace, details.veinSize).setReplaceableOreGenBlock(details.blockToReplace).setReplaceOreGenBlocks(details.replaceOreGenBlocks).func_180709_b(world, random, new BlockPos(randPosX, randPosY + details.minHeight, randPosZ));
                }
            }
        }
    }
}

