/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.worldgen;

import com.mcmoddev.orespawn.data.Config;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class FlatBedrock
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.func_175624_G() != WorldType.field_77138_c) {
            if (world.field_73011_w.getDimension() == -1) {
                this.genTopPlate(world, new ChunkPos(chunkX, chunkZ), Blocks.field_150424_aL);
                this.genBottomPlate(world, new ChunkPos(chunkX, chunkZ), Blocks.field_150424_aL);
            } else if (world.field_73011_w.getDimension() >= 0 && world.field_73011_w.getDimension() != 1) {
                this.genBottomPlate(world, new ChunkPos(chunkX, chunkZ), Blocks.field_150348_b);
            }
        }
    }

    public void retrogen(World world, int chunkX, int chunkZ) {
        if (world.func_175624_G() != WorldType.field_77138_c) {
            if (world.field_73011_w.getDimension() == -1) {
                this.genTopPlate(world, new ChunkPos(chunkX, chunkZ), Blocks.field_150424_aL);
                this.genBottomPlate(world, new ChunkPos(chunkX, chunkZ), Blocks.field_150424_aL);
            } else if (world.field_73011_w.getDimension() >= 0 && world.field_73011_w.getDimension() != 1) {
                this.genBottomPlate(world, new ChunkPos(chunkX, chunkZ), Blocks.field_150348_b);
            }
        }
    }

    private void genBottomPlate(World world, ChunkPos chunkPos, Block repBlock) {
        int plateThickness = Config.getInt("Bedrock Thickness");
        for (int xP = 0; xP < 16; ++xP) {
            for (int zP = 0; zP < 16; ++zP) {
                for (int yP = 5; yP > 0; --yP) {
                    BlockPos target = new BlockPos(chunkPos.field_77276_a * 16 + xP, yP, chunkPos.field_77275_b * 16 + zP);
                    if (yP < plateThickness && !world.func_180495_p(target).func_177230_c().equals(Blocks.field_150357_h)) {
                        world.func_180501_a(target, Blocks.field_150357_h.func_176223_P(), 26);
                        continue;
                    }
                    if (yP < plateThickness || !world.func_180495_p(target).func_177230_c().equals(Blocks.field_150357_h)) continue;
                    world.func_180501_a(target, repBlock.func_176223_P(), 26);
                }
            }
        }
    }

    private void genTopPlate(World world, ChunkPos chunkPos, Block repBlock) {
        int plateThickness = Config.getInt("Bedrock Thickness");
        int thickness = 127 - plateThickness;
        for (int xP = 0; xP < 16; ++xP) {
            for (int zP = 0; zP < 16; ++zP) {
                for (int yP = 126; yP > 121; --yP) {
                    BlockPos target = new BlockPos(chunkPos.field_77276_a * 16 + xP, yP, chunkPos.field_77275_b * 16 + zP);
                    if (yP > thickness && !world.func_180495_p(target).func_177230_c().equals(Blocks.field_150357_h)) {
                        world.func_180501_a(target, Blocks.field_150357_h.func_176223_P(), 26);
                        continue;
                    }
                    if (yP > thickness || !world.func_180495_p(target).func_177230_c().equals(Blocks.field_150357_h)) continue;
                    world.func_180501_a(target, repBlock.func_176223_P(), 26);
                }
            }
        }
    }
}

