/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.impl.os3;

import com.mcmoddev.orespawn.OreSpawn;
import com.mcmoddev.orespawn.api.IBlockList;
import com.mcmoddev.orespawn.api.os3.IBlockDefinition;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;

public class BlockList
implements IBlockList {
    private final List<IBlockDefinition> myBlocks = new LinkedList<IBlockDefinition>();
    private final List<IBlockState> workingList = new LinkedList<IBlockState>();

    @Override
    public void addBlock(IBlockDefinition block) {
        this.myBlocks.add(block);
    }

    @Override
    public IBlockState getRandomBlock(Random rand) {
        if (this.workingList.isEmpty()) {
            this.startNewSpawn();
            if (this.workingList.isEmpty()) {
                return Blocks.field_150350_a.func_176223_P();
            }
        }
        int spot = rand.nextInt(this.workingList.size());
        IBlockState rv = this.workingList.get(spot);
        this.workingList.remove(spot);
        return rv;
    }

    @Override
    public void startNewSpawn() {
        this.workingList.clear();
        this.myBlocks.stream().filter(b -> b.isValid()).forEach(b -> {
            for (int i = 0; i < b.getChance(); ++i) {
                this.workingList.add(b.getBlock());
            }
        });
    }

    @Override
    public void dump() {
        this.myBlocks.stream().map(bd -> bd.getBlock()).forEach(bs -> OreSpawn.LOGGER.debug("Block %s (with state: %s)", (Object)bs.func_177230_c(), bs));
    }

    @Override
    public int count() {
        return this.myBlocks.size();
    }
}

