/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.orespawn.impl.location;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mcmoddev.orespawn.api.BiomeLocation;
import com.mcmoddev.orespawn.impl.location.BiomeLocationEmpty;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Objects;
import net.minecraft.world.biome.Biome;

public final class BiomeLocationComposition
implements BiomeLocation {
    private final BiomeLocation inclusions;
    private final BiomeLocation exclusions;
    private final int hash;

    public BiomeLocationComposition(BiomeLocation inclusions, BiomeLocation exclusions) {
        this.inclusions = inclusions;
        this.exclusions = exclusions;
        this.hash = Objects.hash(inclusions, exclusions);
    }

    @Override
    public boolean matches(Biome biome) {
        boolean inWhite = this.inclusions.matches(biome);
        boolean inBlack = this.exclusions.matches(biome);
        return !inBlack && inWhite;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof BiomeLocationComposition) {
            BiomeLocationComposition other = (BiomeLocationComposition)obj;
            return this.inclusions.equals(other.inclusions) && this.exclusions.equals(other.exclusions);
        }
        return false;
    }

    @Override
    public ImmutableList<Biome> getBiomes() {
        LinkedList<Biome> temp = new LinkedList<Biome>();
        temp.addAll((Collection<Biome>)this.inclusions.getBiomes());
        temp.addAll((Collection<Biome>)this.exclusions.getBiomes());
        return ImmutableList.copyOf(temp);
    }

    public BiomeLocation getInclusions() {
        return this.inclusions;
    }

    public BiomeLocation getExclusions() {
        return this.exclusions;
    }

    @Override
    public JsonElement serialize() {
        JsonObject rv = new JsonObject();
        rv.add("excludes", this.exclusions.serialize());
        if (!(this.inclusions instanceof BiomeLocationEmpty)) {
            rv.add("includes", this.inclusions.serialize());
        }
        return rv;
    }
}

