/*
 * Decompiled with CFR 0.152.
 */
package ejektaflex.bountiful.data;

import ejektaflex.bountiful.Bountiful;
import ejektaflex.bountiful.api.data.IBountyData;
import ejektaflex.bountiful.api.ext.ExtItemStackKt;
import ejektaflex.bountiful.api.ext.ExtNBTKt;
import ejektaflex.bountiful.api.item.IItemBounty;
import ejektaflex.bountiful.api.logic.BountyNBT;
import ejektaflex.bountiful.api.logic.picked.IPickedEntry;
import ejektaflex.bountiful.api.logic.picked.PickedEntryStack;
import ejektaflex.bountiful.data.BountyData;
import ejektaflex.bountiful.item.ItemBounty;
import ejektaflex.bountiful.registry.ValueRegistry;
import ejektaflex.compat.FacadeGameStages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\b\u0018\u0000 =2\u00020\u0001:\u0001=B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010)\u001a\u00020\n2\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020\u00162\u0006\u00101\u001a\u00020\nH\u0002J\u0010\u00102\u001a\u00020\u00162\u0006\u00101\u001a\u00020\nH\u0002J\u0010\u00103\u001a\u0002042\u0006\u0010*\u001a\u00020+H\u0016J\u000e\u00105\u001a\b\u0012\u0004\u0012\u00020\u001606H\u0016J\b\u00107\u001a\u00020/H\u0016J\u0010\u00108\u001a\u00020\n2\u0006\u0010*\u001a\u00020+H\u0016J\u001c\u00109\u001a\b\u0012\u0004\u0012\u00020\u0016062\u0006\u0010*\u001a\u00020+2\u0006\u0010:\u001a\u000204J\u0016\u0010;\u001a\b\u0012\u0004\u0012\u00020\u0016062\u0006\u0010*\u001a\u00020+H\u0002J\u0016\u0010<\u001a\b\u0012\u0004\u0012\u00020\u0016062\u0006\u0010*\u001a\u00020+H\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u0004\u0018\u00010\nX\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u0010\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0006\"\u0004\b\u001b\u0010\bR\u0014\u0010\u001c\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0018R\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\"R\u001a\u0010&\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u0006\"\u0004\b(\u0010\b\u00a8\u0006>"}, d2={"Lejektaflex/bountiful/data/BountyData;", "Lejektaflex/bountiful/api/data/IBountyData;", "()V", "boardStamp", "", "getBoardStamp", "()I", "setBoardStamp", "(I)V", "bountyStamp", "", "getBountyStamp", "()Ljava/lang/Long;", "setBountyStamp", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "bountyTime", "getBountyTime", "()J", "setBountyTime", "(J)V", "getPretty", "", "getGetPretty", "()Ljava/lang/String;", "rarity", "getRarity", "setRarity", "rewardPretty", "getRewardPretty", "rewards", "Lejektaflex/bountiful/registry/ValueRegistry;", "Lejektaflex/bountiful/api/logic/picked/PickedEntryStack;", "getRewards", "()Lejektaflex/bountiful/registry/ValueRegistry;", "toGet", "Lejektaflex/bountiful/api/logic/picked/IPickedEntry;", "getToGet", "worth", "getWorth", "setWorth", "boardTimeLeft", "world", "Lnet/minecraft/world/World;", "deserializeNBT", "", "tag", "Lnet/minecraft/nbt/NBTTagCompound;", "formatTickTime", "n", "formatTimeExpirable", "hasExpired", "", "requiredStages", "", "serializeNBT", "timeLeft", "tooltipInfo", "advanced", "tooltipInfoAdvanced", "tooltipInfoBasic", "Companion", "Bountiful"})
public final class BountyData
implements IBountyData {
    private int boardStamp = Bountiful.INSTANCE.getConfig().getBoardLifespan();
    private long bountyTime;
    private int rarity;
    @NotNull
    private final ValueRegistry<IPickedEntry> toGet = new ValueRegistry();
    @NotNull
    private final ValueRegistry<PickedEntryStack> rewards = new ValueRegistry();
    @Nullable
    private Long bountyStamp;
    private int worth;
    public static final long bountyTickFreq = 20L;
    public static final long boardTickFreq = 20L;
    public static final Companion Companion = new Companion(null);

    @Override
    public int getBoardStamp() {
        return this.boardStamp;
    }

    @Override
    public void setBoardStamp(int n) {
        this.boardStamp = n;
    }

    @Override
    public long getBountyTime() {
        return this.bountyTime;
    }

    @Override
    public void setBountyTime(long l) {
        this.bountyTime = l;
    }

    @Override
    public int getRarity() {
        return this.rarity;
    }

    @Override
    public void setRarity(int n) {
        this.rarity = n;
    }

    @NotNull
    public ValueRegistry<IPickedEntry> getToGet() {
        return this.toGet;
    }

    @NotNull
    public ValueRegistry<PickedEntryStack> getRewards() {
        return this.rewards;
    }

    @Override
    @Nullable
    public Long getBountyStamp() {
        return this.bountyStamp;
    }

    @Override
    public void setBountyStamp(@Nullable Long l) {
        this.bountyStamp = l;
    }

    public final int getWorth() {
        return this.worth;
    }

    public final void setWorth(int n) {
        this.worth = n;
    }

    @Override
    public long timeLeft(@NotNull World world) {
        long l;
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        if (this.getBountyStamp() == null) {
            l = this.getBountyTime();
        } else {
            Long l2 = this.getBountyStamp();
            if (l2 == null) {
                Intrinsics.throwNpe();
            }
            long l3 = l2 + this.getBountyTime() - world.func_82737_E();
            long l4 = 0L;
            l = Math.max(l3, l4);
        }
        return l;
    }

    @Override
    public boolean hasExpired(@NotNull World world) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        return this.timeLeft(world) <= 0L;
    }

    @Override
    public long boardTimeLeft(@NotNull World world) {
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        long l = (long)(this.getBoardStamp() + Bountiful.INSTANCE.getConfig().getBoardLifespan()) - world.func_82737_E();
        long l2 = 0L;
        return Math.max(l, l2);
    }

    @NotNull
    public final List<String> tooltipInfo(@NotNull World world, boolean advanced) {
        List<String> list;
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        if (Bountiful.INSTANCE.getConfig().isRunningGameStages()) {
            EntityPlayerSP localPlayer;
            EntityPlayerSP entityPlayerSP = localPlayer = Minecraft.func_71410_x().field_71439_g;
            Intrinsics.checkExpressionValueIsNotNull((Object)entityPlayerSP, (String)"localPlayer");
            Collection collection = FacadeGameStages.INSTANCE.stagesStillNeededFor((EntityPlayer)entityPlayerSP, this);
            if (!collection.isEmpty()) {
                return CollectionsKt.listOf((Object)I18n.func_135052_a((String)"bountiful.tooltip.requirements", (Object[])new Object[0]));
            }
        }
        if (!(bl = advanced)) {
            list = this.tooltipInfoBasic(world);
        } else if (bl) {
            list = this.tooltipInfoAdvanced(world);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }

    private final List<String> tooltipInfoBasic(World world) {
        return CollectionsKt.listOf((Object[])new String[]{I18n.func_135052_a((String)"bountiful.tooltip.time", (Object[])new Object[0]) + ": " + this.formatTimeExpirable(this.timeLeft(world) / 20L), this.getGetPretty(), this.getRewardPretty(), I18n.func_135052_a((String)"bountiful.tooltip.advanced", (Object[])new Object[0])});
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final List<String> tooltipInfoAdvanced(World world) {
        block8: {
            block7: {
                cycleLength = 27;
                var5_4 = $receiver$iv = (Iterable)this.getToGet().getItems();
                destination$iv$iv /* !! */  = new ArrayList<E>();
                for (T element$iv$iv : $receiver$iv$iv) {
                    it = (IPickedEntry)element$iv$iv;
                    if (!(it instanceof PickedEntryStack)) continue;
                    destination$iv$iv /* !! */ .add(element$iv$iv);
                }
                $receiver$iv = (List)destination$iv$iv /* !! */ ;
                $receiver$iv$iv = $receiver$iv;
                destination$iv$iv /* !! */  = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    it = (IPickedEntry)item$iv$iv;
                    var14_10 = destination$iv$iv /* !! */ ;
                    var15_11 /* !! */  = TuplesKt.to((Object)it, (Object)I18n.func_135052_a((String)"bountiful.tooltip.requiredDetails", (Object[])new Object[0]));
                    var14_10.add(var15_11 /* !! */ );
                }
                getItems = (List)destination$iv$iv /* !! */ ;
                $receiver$iv = this.getRewards().getItems();
                destination$iv$iv /* !! */  = $receiver$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (E item$iv$iv : $receiver$iv$iv) {
                    $i$a$2$map = (PickedEntryStack)item$iv$iv;
                    var14_10 = destination$iv$iv;
                    var15_11 /* !! */  = TuplesKt.to((Object)it, (Object)I18n.func_135052_a((String)"bountiful.tooltip.rewardsDetails", (Object[])new Object[0]));
                    var14_10.add(var15_11 /* !! */ );
                }
                getRewards = (List)destination$iv$iv;
                allGets = CollectionsKt.plus((Collection)getItems, (Iterable)getRewards);
                if (!allGets.isEmpty()) break block7;
                v0 = CollectionsKt.emptyList();
                break block8;
            }
            itemIndex = world.func_82737_E() % (long)(allGets.size() * cycleLength) / (long)cycleLength;
            itemToShow = (Pair)allGets.get((int)itemIndex);
            v1 = itemToShow.getFirst();
            if (v1 == null) {
                throw new TypeCastException("null cannot be cast to non-null type ejektaflex.bountiful.api.logic.picked.PickedEntryStack");
            }
            v2 = ((PickedEntryStack)v1).getItemStack();
            if (v2 == null) {
                Intrinsics.throwNpe();
            }
            istack = v2;
            v3 = CollectionsKt.listOf((Object)itemToShow.getSecond());
            v4 = istack.func_82840_a(null, (ITooltipFlag)tooltipInfoAdvanced.1.INSTANCE);
            Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"istack.getTooltip(null) { false }");
            v5 = CollectionsKt.plus((Collection)v3, (Iterable)v4);
            v6 = ExtItemStackKt.getModOriginName(istack);
            if (v6 == null) ** GOTO lbl-1000
            var10_13 = v6;
            var14_10 = v5;
            it = var10_13;
            var15_11 /* !! */  = CollectionsKt.listOf((Object)("\u00a79\u00a7o" + it + "\u00a7r"));
            v5 = var14_10;
            v6 = var15_11 /* !! */ ;
            if (v6 != null) {
                v7 = (Iterable)v6;
            } else lbl-1000:
            // 2 sources

            {
                var14_10 = v5;
                var15_11 /* !! */  = CollectionsKt.emptyList();
                v5 = var14_10;
                v7 = (Iterable)var15_11 /* !! */ ;
            }
            v0 = CollectionsKt.plus((Collection)v5, (Iterable)v7);
        }
        return v0;
    }

    private final String formatTickTime(long n) {
        return n / (long)60 <= 0L ? "" + n + 's' : n / (long)60 + "m " + n % (long)60 + 's';
    }

    private final String formatTimeExpirable(long n) {
        return n <= 0L ? "\u00a74" + I18n.func_135052_a((String)"bountiful.tooltip.expired", (Object[])new Object[0]) : this.formatTickTime(n);
    }

    private final String getGetPretty() {
        return ((ValueRegistry)this.getToGet()).getItems().isEmpty() ? "\u00a76Completed. \u00a7aTurn it in!" : "\u00a7f" + I18n.func_135052_a((String)"bountiful.tooltip.required", (Object[])new Object[0]) + ": " + CollectionsKt.joinToString$default((Iterable)((ValueRegistry)this.getToGet()).getItems(), (CharSequence)", ", null, null, (int)0, null, (Function1)getPretty.1.INSTANCE, (int)30, null) + "\u00a7r";
    }

    private final String getRewardPretty() {
        return "\u00a7f" + I18n.func_135052_a((String)"bountiful.tooltip.rewards", (Object[])new Object[0]) + ": " + CollectionsKt.joinToString$default((Iterable)((ValueRegistry)this.getRewards()).getItems(), (CharSequence)", ", null, null, (int)0, null, (Function1)rewardPretty.1.INSTANCE, (int)30, null) + "\u00a7r";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> requiredStages() {
        void var3_3;
        Collection<List<String>> collection;
        PickedEntryStack it;
        Collection collection2;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)((ValueRegistry)this.getToGet()).getItems();
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            IPickedEntry iPickedEntry = (IPickedEntry)item$iv$iv;
            collection2 = destination$iv$iv;
            collection = it.requiredStages();
            collection2.add(collection);
        }
        $receiver$iv = ((ValueRegistry)this.getRewards()).getItems();
        collection2 = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (PickedEntryStack)item$iv$iv;
            collection = destination$iv$iv;
            List<String> list = it.requiredStages();
            collection.add(list);
        }
        collection = (List)var3_3;
        return CollectionsKt.plus((Collection)collection2, (Iterable)CollectionsKt.flatten((Iterable)collection));
    }

    public void deserializeNBT(@NotNull NBTTagCompound tag) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        this.setBoardStamp(tag.func_74762_e(BountyNBT.BoardStamp.getKey()));
        this.setBountyTime(tag.func_74763_f(BountyNBT.BountyTime.getKey()));
        this.setRarity(tag.func_74762_e(BountyNBT.Rarity.getKey()));
        this.worth = tag.func_74762_e(BountyNBT.Worth.getKey());
        if (tag.func_74764_b(BountyNBT.BountyStamp.getKey())) {
            this.setBountyStamp(tag.func_74763_f(BountyNBT.BountyStamp.getKey()));
        }
        ((ValueRegistry)this.getToGet()).restore(CollectionsKt.toList((Iterable)ExtNBTKt.getPickedEntryList(tag, BountyNBT.ToGet.getKey())));
        ((ValueRegistry)this.getRewards()).restore(CollectionsKt.toList((Iterable)ExtNBTKt.getUnsortedList(tag, BountyNBT.Rewards.getKey(), deserializeNBT.1.INSTANCE)));
    }

    @NotNull
    public NBTTagCompound serializeNBT() {
        NBTTagCompound nBTTagCompound;
        NBTTagCompound $receiver = nBTTagCompound = new NBTTagCompound();
        $receiver.func_74768_a(BountyNBT.BoardStamp.getKey(), this.getBoardStamp());
        $receiver.func_74772_a(BountyNBT.BountyTime.getKey(), this.getBountyTime());
        $receiver.func_74768_a(BountyNBT.Rarity.getKey(), this.getRarity());
        $receiver.func_74768_a(BountyNBT.Worth.getKey(), this.worth);
        Long l = this.getBountyStamp();
        if (l != null) {
            Long l2 = l;
            long it = ((Number)l2).longValue();
            $receiver.func_74772_a(BountyNBT.BountyStamp.getKey(), it);
        }
        ExtNBTKt.setUnsortedList($receiver, BountyNBT.ToGet.getKey(), CollectionsKt.toSet((Iterable)((ValueRegistry)this.getToGet()).getItems()));
        ExtNBTKt.setUnsortedList($receiver, BountyNBT.Rewards.getKey(), CollectionsKt.toSet((Iterable)((ValueRegistry)this.getRewards()).getItems()));
        return nBTTagCompound;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lejektaflex/bountiful/data/BountyData$Companion;", "", "()V", "boardTickFreq", "", "bountyTickFreq", "from", "Lejektaflex/bountiful/data/BountyData;", "stack", "Lnet/minecraft/item/ItemStack;", "isValidBounty", "", "Bountiful"})
    public static final class Companion {
        public final boolean isValidBounty(@NotNull ItemStack stack) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
            try {
                this.from(stack);
                bl = true;
            }
            catch (Exception e) {
                bl = false;
            }
            return bl;
        }

        @NotNull
        public final BountyData from(@NotNull ItemStack stack) {
            Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
            if (stack.func_77973_b() instanceof ItemBounty) {
                Item item = stack.func_77973_b();
                if (item == null) {
                    throw new TypeCastException("null cannot be cast to non-null type ejektaflex.bountiful.api.item.IItemBounty");
                }
                IBountyData iBountyData = ((IItemBounty)item).getBountyData(stack);
                if (iBountyData == null) {
                    throw new TypeCastException("null cannot be cast to non-null type ejektaflex.bountiful.data.BountyData");
                }
                return (BountyData)iBountyData;
            }
            throw (Throwable)new Exception(stack.func_82833_r() + " is not an IItemBounty and cannot be converted to bounty data!");
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

