/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictreesphc.worldgen;

import com.ferreusveritas.dynamictrees.api.worldgen.BiomePropertySelectors;
import com.ferreusveritas.dynamictrees.api.worldgen.IBiomeDataBasePopulator;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.worldgen.BiomeDataBase;
import com.ferreusveritas.dynamictreesphc.ModTrees;
import com.pam.harvestcraft.HarvestCraft;
import com.pam.harvestcraft.config.TreeGenerationConfiguration;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class BiomeDataBasePopulator
implements IBiomeDataBasePopulator {
    Map<Biome, BiomePropertySelectors.RandomSpeciesSelector> biomeMap = new HashMap<Biome, BiomePropertySelectors.RandomSpeciesSelector>();

    public void populate(BiomeDataBase dbase) {
        for (TreeGenerationConfiguration treeConfig : HarvestCraft.fruitTreeConfigManager.treeConfigurations) {
            String fruitName;
            Species species;
            if (!treeConfig.getEnableGeneration() || (species = ModTrees.phcSpecies.get(fruitName = treeConfig.getFruit())) == null) continue;
            for (Biome biome : treeConfig.getBiomesAllowed()) {
                if (!dbase.shouldCancelVanillaTreeGen(biome)) continue;
                BiomePropertySelectors.RandomSpeciesSelector selector = this.biomeMap.computeIfAbsent(biome, b -> new BiomePropertySelectors.RandomSpeciesSelector());
                selector.add(species, 100 - treeConfig.getRarity());
            }
        }
        float harvestCraftOccurance = 0.02f;
        for (Map.Entry<Biome, BiomePropertySelectors.RandomSpeciesSelector> entry : this.biomeMap.entrySet()) {
            if (BiomeDictionary.hasType((Biome)entry.getKey(), (BiomeDictionary.Type)BiomeDictionary.Type.SPOOKY)) continue;
            dbase.setSpeciesSelector(entry.getKey(), (pos, dirt, random) -> random.nextFloat() < harvestCraftOccurance ? ((BiomePropertySelectors.RandomSpeciesSelector)entry.getValue()).getSpecies(pos, dirt, random) : new BiomePropertySelectors.SpeciesSelection(), BiomeDataBase.Operation.SPLICE_BEFORE);
        }
    }
}

