/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictreesphc.trees;

import com.ferreusveritas.dynamictrees.api.treedata.IDropCreator;
import com.ferreusveritas.dynamictrees.api.treedata.ILeavesProperties;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import com.ferreusveritas.dynamictreesphc.ModBlocks;
import com.ferreusveritas.dynamictreesphc.dropcreators.DropCreatorFruitLogProduct;
import com.ferreusveritas.dynamictreesphc.trees.TreeFamilyPHC;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class TreeCinnamon
extends TreeFamilyPHC {
    public static final String speciesName = "cinnamon";

    public TreeCinnamon() {
        super(new ResourceLocation("dynamictreesphc", speciesName));
        this.setPrimitiveLog(ModBlocks.primCinnamonLog.func_176223_P());
        ModBlocks.cinnamonLeavesProperties.setTree((TreeFamily)this);
    }

    public void createSpecies() {
        this.setCommonSpecies(new TreeCinnamonSpecies(this));
        this.getCommonSpecies().generateSeed();
    }

    public class TreeCinnamonSpecies
    extends Species {
        public TreeCinnamonSpecies(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, (ILeavesProperties)ModBlocks.cinnamonLeavesProperties);
            this.setBasicGrowingParameters(0.25f, 11.0f, this.getUpProbability(), this.getLowestBranchHeight(), 1.0f);
            this.setupStandardSeedDropping();
            this.addDropCreator((IDropCreator)new DropCreatorFruitLogProduct((TreeFamilyPHC)treeFamily));
        }

        public boolean isBiomePerfect(Biome biome) {
            return BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE);
        }
    }
}

