/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictreesphc.trees;

import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.api.treedata.ILeavesProperties;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenFruit;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.SpeciesRare;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import com.pam.harvestcraft.blocks.BlockRegistry;
import com.pam.harvestcraft.blocks.growables.BlockPamFruit;
import com.pam.harvestcraft.blocks.growables.BlockPamSapling;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.BiomeDictionary;

public class SpeciesFruit
extends SpeciesRare {
    public final String fruitName;
    public final BlockPamSapling.SaplingType saplingType;
    public IBlockState fruitBlockState;
    private int fruitingRadius = 5;

    public SpeciesFruit(ResourceLocation name, TreeFamily treeFamily, ILeavesProperties leavesProperties, String fruitName, BlockPamSapling.SaplingType saplingType) {
        super(name, treeFamily, leavesProperties);
        this.fruitName = fruitName;
        this.saplingType = saplingType;
        this.fruitTreeDefaults();
        switch (saplingType) {
            default: {
                this.envFactor(BiomeDictionary.Type.COLD, 0.75f);
                this.envFactor(BiomeDictionary.Type.HOT, 0.75f);
                break;
            }
            case COLD: {
                this.envFactor(BiomeDictionary.Type.HOT, 0.5f);
                break;
            }
            case WARM: {
                this.envFactor(BiomeDictionary.Type.COLD, 0.5f);
            }
        }
        this.generateSeed();
        Block fruitBlock = BlockRegistry.blocks.stream().filter(b -> b.getRegistryName().func_110623_a().equals("pam" + fruitName)).findFirst().get();
        IBlockState ripeFruit = fruitBlock.func_176223_P().func_177226_a((IProperty)BlockPamFruit.AGE, (Comparable)Integer.valueOf(2));
        IBlockState unripeFruit = fruitBlock.func_176223_P().func_177226_a((IProperty)BlockPamFruit.AGE, (Comparable)Integer.valueOf(0));
        this.fruitBlockState = fruitBlock.func_176223_P();
        this.addGenFeature((IGenFeature)new FeatureGenFruit(unripeFruit, ripeFruit).setRayDistance(4.0f).setFruitingRadius(this.fruitingRadius));
    }

    public ResourceLocation getSaplingName() {
        String dtModId = "dynamictrees";
        switch (this.saplingType) {
            default: {
                return new ResourceLocation(dtModId, "oak");
            }
            case COLD: {
                return new ResourceLocation(dtModId, "spruce");
            }
            case WARM: 
        }
        return new ResourceLocation(dtModId, "jungle");
    }

    protected void fruitTreeDefaults() {
        this.setBasicGrowingParameters(0.3f, 8.0f, 1, 4, 1.0f, this.fruitingRadius);
    }

    protected SpeciesFruit setBasicGrowingParameters(float tapering, float energy, int upProbability, int lowestBranchHeight, float growthRate, int fruitingRadius) {
        this.setBasicGrowingParameters(tapering, energy, upProbability, lowestBranchHeight, growthRate);
        this.fruitingRadius = fruitingRadius;
        return this;
    }

    public BlockPamFruit getFruitBlock() {
        return (BlockPamFruit)this.fruitBlockState.func_177230_c();
    }

    public void addJoCodes() {
        this.joCodeStore.addCodesFromFile((Species)this, "assets/" + this.getRegistryName().func_110624_b() + "/trees/fruit.txt");
    }
}

