/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictreesphc;

import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.WorldGenRegistry;
import com.ferreusveritas.dynamictrees.api.treedata.ILeavesProperties;
import com.ferreusveritas.dynamictrees.api.worldgen.IBiomeDataBasePopulator;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import com.ferreusveritas.dynamictreesphc.trees.SpeciesFruit;
import com.ferreusveritas.dynamictreesphc.trees.TreeCinnamon;
import com.ferreusveritas.dynamictreesphc.trees.TreeFamilyPHC;
import com.ferreusveritas.dynamictreesphc.trees.TreeMaple;
import com.ferreusveritas.dynamictreesphc.trees.TreePaperBark;
import com.ferreusveritas.dynamictreesphc.worldgen.BiomeDataBasePopulator;
import com.pam.harvestcraft.HarvestCraft;
import com.pam.harvestcraft.blocks.FruitRegistry;
import com.pam.harvestcraft.blocks.growables.BlockPamSapling;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="dynamictreesphc")
public class ModTrees {
    public static boolean fruitTreeGen;
    public static ArrayList<TreeFamily> phcTrees;
    public static Map<String, Species> phcSpecies;

    public static void init() {
        fruitTreeGen = HarvestCraft.fruitTreeConfigManager.enableFruitTreeGeneration;
    }

    public static void preInit() {
        Collections.addAll(phcTrees, new TreeFamilyPHC[]{new TreeCinnamon(), new TreeMaple(), new TreePaperBark()});
        phcTrees.forEach(tree -> tree.registerSpecies(Species.REGISTRY));
        phcTrees.forEach(tree -> phcSpecies.put(tree.getName().func_110623_a(), tree.getCommonSpecies()));
        ISpeciesCreator fruitTreeCreator = (name, treeFamily, leavesProperties, fruitName, saplingType) -> new SpeciesFruit(name, treeFamily, leavesProperties, fruitName, saplingType);
        HashMap saplingMap = new HashMap();
        saplingMap.putAll(FruitRegistry.registeringFruits);
        EnumMap<BlockPamSapling.SaplingType, TreeFamily> familyMap = new EnumMap<BlockPamSapling.SaplingType, TreeFamily>(BlockPamSapling.SaplingType.class);
        familyMap.put(BlockPamSapling.SaplingType.TEMPERATE, TreeRegistry.findSpeciesSloppy((String)"oak").getFamily());
        familyMap.put(BlockPamSapling.SaplingType.WARM, TreeRegistry.findSpeciesSloppy((String)"jungle").getFamily());
        familyMap.put(BlockPamSapling.SaplingType.COLD, TreeRegistry.findSpeciesSloppy((String)"spruce").getFamily());
        HashMap<String, ISpeciesCreator> creatorMap = new HashMap<String, ISpeciesCreator>();
        FruitRegistry.registeringFruits.forEach((k, v) -> creatorMap.put((String)k, fruitTreeCreator));
        ModTrees.alterCreatorMap(creatorMap);
        for (Map.Entry entry : creatorMap.entrySet()) {
            String fruitName2 = (String)entry.getKey();
            ISpeciesCreator creator = (ISpeciesCreator)entry.getValue();
            BlockPamSapling.SaplingType saplingType2 = (BlockPamSapling.SaplingType)saplingMap.get(fruitName2);
            TreeFamily family = (TreeFamily)familyMap.get(saplingType2);
            ResourceLocation resLoc = new ResourceLocation("dynamictreesphc", fruitName2);
            ILeavesProperties leavesProperties2 = family.getCommonSpecies().getLeavesProperties();
            Species species = creator.createSpecies(resLoc, family, leavesProperties2, fruitName2, saplingType2);
            phcSpecies.put(fruitName2, species);
            Species.REGISTRY.register((IForgeRegistryEntry)species);
        }
        for (Map.Entry<Object, Object> entry : phcSpecies.entrySet()) {
            TreeRegistry.registerSaplingReplacer((IBlockState)FruitRegistry.getSapling((String)((String)entry.getKey())).func_176223_P(), (Species)((Species)entry.getValue()));
        }
    }

    private static void alterCreatorMap(Map<String, ISpeciesCreator> creatorMap) {
        creatorMap.remove("apple");
        creatorMap.put("walnut", (name, treeFamily, leavesProperties, fruitName, saplingType) -> new SpeciesFruit(name, treeFamily, leavesProperties, fruitName, saplingType){

            @Override
            protected void fruitTreeDefaults() {
                this.setBasicGrowingParameters(0.4f, 12.0f, 1, 4, 0.7f, 8);
            }
        });
        creatorMap.put("chestnut", (name, treeFamily, leavesProperties, fruitName, saplingType) -> new SpeciesFruit(name, treeFamily, leavesProperties, fruitName, saplingType){

            @Override
            protected void fruitTreeDefaults() {
                this.setBasicGrowingParameters(0.45f, 11.0f, 1, 4, 0.6f, 8);
            }
        });
        creatorMap.put("pecan", (name, treeFamily, leavesProperties, fruitName, saplingType) -> new SpeciesFruit(name, treeFamily, leavesProperties, fruitName, saplingType){

            @Override
            protected void fruitTreeDefaults() {
                this.setBasicGrowingParameters(0.45f, 11.0f, 1, 4, 0.6f, 8);
            }
        });
    }

    @SubscribeEvent
    public static void registerDataBasePopulators(WorldGenRegistry.BiomeDataBasePopulatorRegistryEvent event) {
        if (fruitTreeGen) {
            event.register((IBiomeDataBasePopulator)new BiomeDataBasePopulator());
        }
    }

    static {
        phcTrees = new ArrayList();
        phcSpecies = new HashMap<String, Species>();
    }

    protected static interface ISpeciesCreator {
        public Species createSpecies(ResourceLocation var1, TreeFamily var2, ILeavesProperties var3, String var4, BlockPamSapling.SaplingType var5);
    }
}

