/*
 * Decompiled with CFR 0.152.
 */
package net.theawesomegem.blockdropstweaker.networking.packet;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.theawesomegem.blockdropstweaker.Primary;
import net.theawesomegem.blockdropstweaker.common.blockconfig.ConfigurationHandler;
import net.theawesomegem.blockdropstweaker.util.ChatUtil;

public class PacketKeybindS
implements IMessage {
    private Keybind bind;

    public Keybind getKeyBind() {
        return this.bind;
    }

    public PacketKeybindS() {
        this.bind = Keybind.NONE;
    }

    public PacketKeybindS(Keybind keybind) {
        this.bind = keybind;
    }

    public void fromBytes(ByteBuf buf) {
        this.bind = Keybind.values()[buf.readShort()];
    }

    public void toBytes(ByteBuf buf) {
        buf.writeShort(this.bind.ordinal());
    }

    public static class KeybindMessageHandler
    implements IMessageHandler<PacketKeybindS, IMessage> {
        public IMessage onMessage(PacketKeybindS message, MessageContext ctx) {
            EntityPlayer player = Primary.proxy.getPlayer(ctx);
            Keybind bind = message.getKeyBind();
            if (player == null) {
                return null;
            }
            IThreadListener thread = Primary.proxy.getListener(ctx);
            thread.func_152344_a(() -> {
                if (bind.equals((Object)Keybind.NONE)) {
                    return;
                }
                if (!Primary.proxy.hasPermission(player)) {
                    player.func_145747_a((ITextComponent)new TextComponentString("You don't have permission to save block drops data."));
                    return;
                }
                if (bind.equals((Object)Keybind.SAVE_BLOCK_DROPS)) {
                    ConfigurationHandler.saveConfig();
                    player.func_145747_a(ChatUtil.getNormalMessage("Saved current data to JSON."));
                } else if (bind.equals((Object)Keybind.RELOAD_BLOCK_DROPS)) {
                    ConfigurationHandler.loadConfig();
                    player.func_145747_a(ChatUtil.getNormalMessage("Reloaded from the JSON."));
                    player.func_145747_a(ChatUtil.getNormalMessage("Any unsaved changes will be lost."));
                }
            });
            return null;
        }
    }

    public static enum Keybind {
        SAVE_BLOCK_DROPS,
        RELOAD_BLOCK_DROPS,
        NONE;

    }
}

