/*
 * Decompiled with CFR 0.152.
 */
package net.theawesomegem.blockdropstweaker.common.config;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigurationHandler {
    private static Configuration config;

    public static Configuration getConfig() {
        return config;
    }

    public static void init(File configFile) {
        if (config == null) {
            config = new Configuration(configFile);
        }
        ConfigurationHandler.loadConfiguration();
    }

    private static void loadConfiguration() {
        ConfigurationHandler.loadBlockDropsConfiguration();
        if (config.hasChanged()) {
            config.save();
        }
    }

    private static void loadBlockDropsConfiguration() {
        ConfigData.BlockDropMap.clear();
        ConfigCategory generalCategory = config.getCategory("general");
        for (ConfigCategory blockConfig : generalCategory.getChildren()) {
            String[] dropArray;
            String blockKey = blockConfig.getName();
            BlockDropData dropData = new BlockDropData();
            String category = "general." + blockKey;
            dropData.Chance = config.getFloat("Chance", category, 1.0f, 0.0f, 1.0f, "The chance for the drop.");
            dropData.MultipleDropsChance = config.getInt("Multiple Drops Chance", category, 0, 0, 100, "Specifies the chance to drop more one 1 different item in 1 harvest");
            dropData.FortuneLevelOverride = config.getBoolean("Fortune Level Override", category, true, "If Fortune Level should increase the chance.");
            dropData.SilkTouchOverride = config.getBoolean("Silk Touch Override", category, true, "If Silk Touch should drop the silked touch block(aka stone for stone).");
            dropData.Replace = config.getBoolean("Replace", category, true, "If you want to replace the drop completely with the new one or just add on to it.");
            for (String drop : dropArray = config.getStringList("Block Drops", category, new String[0], "The weighted randomized list of drops for this block.")) {
                String[] dropInfo = drop.split("\\|");
                if (dropInfo.length != 2) continue;
                dropData.DropMap.put(dropInfo[0], Integer.parseInt(dropInfo[1]));
            }
            ConfigData.BlockDropMap.put(blockKey, dropData);
        }
    }

    @Mod.EventBusSubscriber(modid="blockdropstweaker")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("blockdropstweaker")) {
                ConfigurationHandler.loadConfiguration();
            }
        }
    }

    public static class BlockDropData {
        public float Chance;
        public int MultipleDropsChance;
        public boolean SilkTouchOverride;
        public boolean FortuneLevelOverride;
        public boolean Replace;
        public Map<String, Integer> DropMap = new HashMap<String, Integer>();
    }

    public static class ConfigData {
        public static Map<String, BlockDropData> BlockDropMap = new HashMap<String, BlockDropData>();
    }
}

