/*
 * Decompiled with CFR 0.152.
 */
package net.theawesomegem.blockdropstweaker.common.command.set;

import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.theawesomegem.blockdropstweaker.common.blockconfig.BlockDropData;
import net.theawesomegem.blockdropstweaker.common.blockconfig.ConfigurationHandler;
import net.theawesomegem.blockdropstweaker.common.blockconfig.DropData;
import net.theawesomegem.blockdropstweaker.common.capability.player.IPlayerData;
import net.theawesomegem.blockdropstweaker.common.capability.player.PlayerDataCapabilityProvider;
import net.theawesomegem.blockdropstweaker.common.command.BlockDropsBaseCommand;
import net.theawesomegem.blockdropstweaker.util.ChatUtil;

public class DropSetFortuneChanceCommand
extends BlockDropsBaseCommand {
    public String func_71517_b() {
        return "fortunechance";
    }

    @Override
    protected String getCommandPath() {
        return "drop.set.fortunechance";
    }

    @Override
    protected void onCommand(MinecraftServer server, EntityPlayer player, String[] args) throws CommandException {
        int chance;
        int fortuneLevel;
        BlockDropData blockDropData;
        if (args.length < 2) {
            throw new WrongUsageException(this.func_71518_a((ICommandSender)player), new Object[0]);
        }
        IPlayerData playerData = (IPlayerData)player.getCapability(PlayerDataCapabilityProvider.PLAYERDATA_CAP, null);
        BlockDropData blockDropData2 = blockDropData = playerData.getSelectedBlock() == null ? null : ConfigurationHandler.blockDropMap.get(playerData.getSelectedBlock());
        if (blockDropData == null) {
            player.func_145747_a(ChatUtil.getNormalMessage("The block associated with the drop does not exist."));
            return;
        }
        DropData dropData = DropData.getDropData(blockDropData, playerData.getSelectedDrop());
        if (dropData == null) {
            player.func_145747_a(ChatUtil.getNormalMessage("Select a drop first using '/bd drop select'"));
            return;
        }
        String fortuneLevelStr = args[0];
        String chanceStr = args[1];
        try {
            fortuneLevel = Integer.parseInt(fortuneLevelStr);
            chance = Integer.parseInt(chanceStr);
        }
        catch (NumberFormatException e) {
            player.func_145747_a(ChatUtil.getNormalMessage("Both the fortune level and the chance must be whole numbers."));
            return;
        }
        dropData.fortunechancemap.put(fortuneLevel, chance);
        player.func_145747_a(ChatUtil.getNormalMessage("Fortune Level '" + fortuneLevelStr + "' 'chance' set to '" + chanceStr + "'"));
    }
}

