/*
 * Decompiled with CFR 0.152.
 */
package net.theawesomegem.blockdropstweaker.common.command.set;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.theawesomegem.blockdropstweaker.common.blockconfig.BlockDropData;
import net.theawesomegem.blockdropstweaker.common.blockconfig.ConfigurationHandler;
import net.theawesomegem.blockdropstweaker.common.capability.player.IPlayerData;
import net.theawesomegem.blockdropstweaker.common.capability.player.PlayerDataCapabilityProvider;
import net.theawesomegem.blockdropstweaker.common.command.BlockDropsTreeBaseCommand;
import net.theawesomegem.blockdropstweaker.common.command.set.BlockSetFortuneChanceCommand;
import net.theawesomegem.blockdropstweaker.util.ChatUtil;

public class BlockSetCommand
extends BlockDropsTreeBaseCommand {
    public BlockSetCommand() {
        this.addSubcommand((ICommand)new BlockSetFortuneChanceCommand());
    }

    public String func_71517_b() {
        return "set";
    }

    @Override
    protected String getCommandPath() {
        return "block.set";
    }

    @Override
    protected boolean onPreCommand(MinecraftServer server, EntityPlayer player, String[] args) throws CommandException {
        BlockDropData blockDropData;
        if (args.length < 2) {
            throw new WrongUsageException(this.func_71518_a((ICommandSender)player), new Object[0]);
        }
        IPlayerData playerData = (IPlayerData)player.getCapability(PlayerDataCapabilityProvider.PLAYERDATA_CAP, null);
        BlockDropData blockDropData2 = blockDropData = playerData.getSelectedBlock() == null ? null : ConfigurationHandler.blockDropMap.get(playerData.getSelectedBlock());
        if (blockDropData == null) {
            player.func_145747_a(ChatUtil.getNormalMessage("Select a block first using '/bd block select'"));
            return false;
        }
        String key = args[0];
        String value = args[1];
        switch (key.toLowerCase()) {
            case "replace": {
                boolean replace;
                blockDropData.replace = replace = Boolean.parseBoolean(value);
                player.func_145747_a(ChatUtil.getNormalMessage("'replace' set to '" + replace + "'"));
                return false;
            }
            case "silktouch": {
                boolean silkTouch;
                blockDropData.allowsilktouch = silkTouch = Boolean.parseBoolean(value);
                player.func_145747_a(ChatUtil.getNormalMessage("'silktouch' set to '" + silkTouch + "'"));
                return false;
            }
            case "alwayssilktouch": {
                boolean alwaysSilkTouch;
                blockDropData.dropsilktouchalways = alwaysSilkTouch = Boolean.parseBoolean(value);
                player.func_145747_a(ChatUtil.getNormalMessage("'alwayssilktouch' set to '" + alwaysSilkTouch + "'"));
                return false;
            }
            case "chance": {
                int chance;
                try {
                    chance = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    player.func_145747_a(ChatUtil.getNormalMessage("'chance' can only be a number."));
                    return false;
                }
                for (Integer fortuneLevel : blockDropData.fortunechance.keySet()) {
                    blockDropData.fortunechance.put(fortuneLevel, chance);
                }
                player.func_145747_a(ChatUtil.getNormalMessage("'chance' set to '" + chance + "' while ignoring any fortune."));
                return false;
            }
            case "ylevel": {
                int maxYLevel;
                int minYLevel;
                String[] ylevelInfo = value.split(":");
                if (ylevelInfo.length < 2) {
                    player.func_145747_a(ChatUtil.getNormalMessage("Please use the format 'min:max'. For example '0:256' for 0 to 256 y-level"));
                    return false;
                }
                try {
                    minYLevel = Integer.parseInt(ylevelInfo[0]);
                    maxYLevel = Integer.parseInt(ylevelInfo[1]);
                }
                catch (NumberFormatException e) {
                    player.func_145747_a(ChatUtil.getNormalMessage("'ylevel' can only be a whole number."));
                    return false;
                }
                blockDropData.minYLevel = minYLevel;
                blockDropData.maxYLevel = maxYLevel;
                player.func_145747_a(ChatUtil.getNormalMessage("'ylevel' set to '" + minYLevel + ":" + maxYLevel + "'"));
                return false;
            }
            case "exp": {
                int maxExp;
                int minExp;
                String[] expInfo = value.split(":");
                if (expInfo.length < 2) {
                    player.func_145747_a(ChatUtil.getNormalMessage("Please use the format 'min:max'. For example '0:100' for 0 to 100 experience points"));
                    return false;
                }
                try {
                    minExp = Integer.parseInt(expInfo[0]);
                    maxExp = Integer.parseInt(expInfo[1]);
                }
                catch (NumberFormatException e) {
                    player.func_145747_a(ChatUtil.getNormalMessage("'exp' can only be a whole number."));
                    return false;
                }
                blockDropData.minExp = minExp;
                blockDropData.maxExp = maxExp;
                player.func_145747_a(ChatUtil.getNormalMessage("'exp' set to '" + minExp + ":" + maxExp + "'"));
                return false;
            }
            case "toolblacklist": {
                blockDropData.toolsBlacklist = Boolean.parseBoolean(value);
                player.func_145747_a(ChatUtil.getNormalMessage("'toolblacklist' set to '" + blockDropData.toolsBlacklist + "'"));
                return false;
            }
            case "biomeblacklist": {
                blockDropData.biomeBlacklist = Boolean.parseBoolean(value);
                player.func_145747_a(ChatUtil.getNormalMessage("'biomeblacklist' set to '" + blockDropData.biomeBlacklist + "'"));
                return false;
            }
            case "gamestageblacklist": {
                blockDropData.gamestageBlacklist = Boolean.parseBoolean(value);
                player.func_145747_a(ChatUtil.getNormalMessage("'gamestageblacklist' set to '" + blockDropData.gamestageBlacklist + "'"));
                return false;
            }
            case "gamestageall": {
                blockDropData.gamestageAll = Boolean.parseBoolean(value);
                player.func_145747_a(ChatUtil.getNormalMessage("'gamestageall' set to '" + blockDropData.gamestageAll + "'"));
                return false;
            }
            case "modifierblacklist": {
                blockDropData.modifierBlacklist = Boolean.parseBoolean(value);
                player.func_145747_a(ChatUtil.getNormalMessage("'modifierblacklist' set to '" + blockDropData.modifierBlacklist + "'"));
                return false;
            }
            case "traitblacklist": {
                blockDropData.traitBlacklist = Boolean.parseBoolean(value);
                player.func_145747_a(ChatUtil.getNormalMessage("'traitblacklist' set to '" + blockDropData.traitBlacklist + "'"));
                return false;
            }
            case "enchantmentblacklist": {
                blockDropData.enchantmentBlacklist = Boolean.parseBoolean(value);
                player.func_145747_a(ChatUtil.getNormalMessage("'enchantmentblacklist' set to '" + blockDropData.enchantmentBlacklist + "'"));
                return false;
            }
            case "nbtblacklist": {
                blockDropData.nbtBlacklist = Boolean.parseBoolean(value);
                player.func_145747_a(ChatUtil.getNormalMessage("'nbtblacklist' set to '" + blockDropData.nbtBlacklist + "'"));
                return false;
            }
        }
        return false;
    }

    @Override
    protected void onCommand(MinecraftServer server, EntityPlayer player, String[] args) throws CommandException {
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
        List tabListItems = super.func_184883_a(server, sender, args, pos);
        if (args.length == 1) {
            tabListItems.add("replace");
            tabListItems.add("silktouch");
            tabListItems.add("alwayssilktouch");
            tabListItems.add("chance");
            tabListItems.add("ylevel");
            tabListItems.add("exp");
            tabListItems.add("toolblacklist");
            tabListItems.add("biomeblacklist");
            tabListItems.add("gamestageblacklist");
            tabListItems.add("gamestageall");
            tabListItems.add("modifierblacklist");
            tabListItems.add("traitblacklist");
            tabListItems.add("enchantmentblacklist");
            tabListItems.add("nbtblacklist");
        }
        return BlockSetCommand.func_175762_a((String[])args, (Collection)tabListItems);
    }
}

