/*
 * Decompiled with CFR 0.152.
 */
package net.theawesomegem.blockdropstweaker.common.command.add;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.theawesomegem.blockdropstweaker.common.blockconfig.BlockDropData;
import net.theawesomegem.blockdropstweaker.common.blockconfig.ConfigurationHandler;
import net.theawesomegem.blockdropstweaker.common.blockconfig.DropData;
import net.theawesomegem.blockdropstweaker.common.capability.player.IPlayerData;
import net.theawesomegem.blockdropstweaker.common.capability.player.PlayerDataCapabilityProvider;
import net.theawesomegem.blockdropstweaker.common.command.BlockDropsBaseCommand;
import net.theawesomegem.blockdropstweaker.util.ChatUtil;

public class DropToolAddCommand
extends BlockDropsBaseCommand {
    public String func_71517_b() {
        return "add";
    }

    @Override
    protected String getCommandPath() {
        return "drop.tool.add";
    }

    @Override
    protected void onCommand(MinecraftServer server, EntityPlayer player, String[] args) throws CommandException {
        Item toolItem;
        BlockDropData blockDropData;
        if (args.length < 2) {
            throw new WrongUsageException(this.func_71518_a((ICommandSender)player), new Object[0]);
        }
        IPlayerData playerData = (IPlayerData)player.getCapability(PlayerDataCapabilityProvider.PLAYERDATA_CAP, null);
        BlockDropData blockDropData2 = blockDropData = playerData.getSelectedBlock() == null ? null : ConfigurationHandler.blockDropMap.get(playerData.getSelectedBlock());
        if (blockDropData == null) {
            player.func_145747_a(ChatUtil.getNormalMessage("The block associated with the drop does not exist."));
            return;
        }
        DropData dropData = DropData.getDropData(blockDropData, playerData.getSelectedDrop());
        if (dropData == null) {
            player.func_145747_a(ChatUtil.getNormalMessage("Select a drop first using '/bd drop select'"));
            return;
        }
        String itemID = args[0];
        String metadataStr = args[1];
        if (!metadataStr.equals("*")) {
            try {
                int metadata = Integer.parseInt(metadataStr);
            }
            catch (NumberFormatException e) {
                player.func_145747_a(ChatUtil.getNormalMessage("Metadata can either be '*' for the wildcard or a number '0-99999'."));
                return;
            }
        }
        if ((toolItem = Item.func_111206_d((String)itemID)) == null) {
            player.func_145747_a(ChatUtil.getNormalMessage("That item does not exist."));
            return;
        }
        String toolInfo = itemID + "," + metadataStr;
        if (dropData.tools.contains(toolInfo)) {
            player.func_145747_a(ChatUtil.getNormalMessage("That tool already exists."));
            return;
        }
        dropData.tools.add(toolInfo);
        player.func_145747_a(ChatUtil.getNormalMessage("Added Tool '" + toolInfo + "'"));
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        ArrayList<String> tabList = new ArrayList<String>();
        if (args.length == 1) {
            tabList.addAll(DropToolAddCommand.func_175762_a((String[])args, (Collection)Item.field_150901_e.func_148742_b()));
        }
        return tabList;
    }
}

