/*
 * Decompiled with CFR 0.152.
 */
package net.theawesomegem.blockdropstweaker.common.command;

import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.theawesomegem.blockdropstweaker.common.blockconfig.BlockDropData;
import net.theawesomegem.blockdropstweaker.common.blockconfig.ConfigurationHandler;
import net.theawesomegem.blockdropstweaker.common.blockconfig.DropData;
import net.theawesomegem.blockdropstweaker.common.capability.player.IPlayerData;
import net.theawesomegem.blockdropstweaker.common.capability.player.PlayerDataCapabilityProvider;
import net.theawesomegem.blockdropstweaker.common.command.BlockDropsTreeBaseCommand;
import net.theawesomegem.blockdropstweaker.common.command.add.DropEnchantAddCommand;
import net.theawesomegem.blockdropstweaker.common.command.remove.DropEnchantClearCommand;
import net.theawesomegem.blockdropstweaker.common.command.remove.DropEnchantRemoveCommand;
import net.theawesomegem.blockdropstweaker.util.ChatUtil;

public class DropEnchantmentCommand
extends BlockDropsTreeBaseCommand {
    public DropEnchantmentCommand() {
        this.addSubcommand((ICommand)new DropEnchantAddCommand());
        this.addSubcommand((ICommand)new DropEnchantRemoveCommand());
        this.addSubcommand((ICommand)new DropEnchantClearCommand());
    }

    public String func_71517_b() {
        return "enchant";
    }

    @Override
    protected String getCommandPath() {
        return "drop.enchant";
    }

    @Override
    protected void onCommand(MinecraftServer server, EntityPlayer player, String[] args) throws CommandException {
        BlockDropData blockDropData;
        IPlayerData playerData = (IPlayerData)player.getCapability(PlayerDataCapabilityProvider.PLAYERDATA_CAP, null);
        BlockDropData blockDropData2 = blockDropData = playerData.getSelectedBlock() == null ? null : ConfigurationHandler.blockDropMap.get(playerData.getSelectedBlock());
        if (blockDropData == null) {
            player.func_145747_a(ChatUtil.getNormalMessage("The block associated with the drop does not exist."));
            return;
        }
        DropData dropData = DropData.getDropData(blockDropData, playerData.getSelectedDrop());
        if (dropData == null) {
            player.func_145747_a(ChatUtil.getNormalMessage("Select a drop first using '/bd drop select'"));
            return;
        }
        player.func_145747_a(ChatUtil.getNormalMessage("-----Enchants-----"));
        for (String enchant : dropData.enchantmentList) {
            player.func_145747_a(ChatUtil.getNormalMessage(enchant));
        }
        player.func_145747_a(ChatUtil.getNormalMessage("----------------"));
    }
}

