/*
 * Decompiled with CFR 0.152.
 */
package net.theawesomegem.blockdropstweaker.common.blockconfig;

import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import net.theawesomegem.blockdropstweaker.common.blockconfig.BlockDropData;
import net.theawesomegem.blockdropstweaker.common.blockconfig.FortuneQuantityData;
import net.theawesomegem.blockdropstweaker.proxy.CommonProxy;
import org.apache.logging.log4j.Level;

public class ConfigurationHandler {
    public static Map<String, BlockDropData> blockDropMap = new HashMap<String, BlockDropData>();
    private static File modFolder = null;
    private static File blockConfigFile = null;
    private static JsonElement blockJson = null;

    public static void preInit(File file) {
        modFolder = new File(file, "blockdropstweaker");
        if (!(modFolder.exists() && modFolder.isDirectory() || modFolder.mkdir())) {
            CommonProxy.Logger.log(Level.FATAL, "Could not create the folder for configuration.");
        }
        if (modFolder == null || !modFolder.exists()) {
            return;
        }
        blockConfigFile = new File(modFolder, "blockdrops.json");
        if (!blockConfigFile.exists()) {
            ConfigurationHandler.createConfig();
        }
        blockJson = new JsonObject();
        ConfigurationHandler.loadConfig();
    }

    private static void createConfig() {
        try {
            if (!blockConfigFile.createNewFile()) {
                CommonProxy.Logger.log(Level.FATAL, "Could not create the block config file.");
                return;
            }
            ConfigurationHandler.saveConfig();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void loadConfig() {
        if (blockConfigFile == null || !blockConfigFile.exists()) {
            CommonProxy.Logger.log(Level.FATAL, "Could not load the block config file. File does not exist.");
            return;
        }
        try {
            String blockDropsString = Files.toString((File)blockConfigFile, (Charset)Charset.defaultCharset());
            blockJson = new JsonParser().parse(blockDropsString);
            ConfigurationHandler.loadBlockDrops();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void saveConfig() {
        if (blockConfigFile == null || !blockConfigFile.exists()) {
            CommonProxy.Logger.log(Level.FATAL, "Could not save the block config file. File does not exist.");
            return;
        }
        try {
            String blockDropsString = ConfigurationHandler.saveBlockDrops();
            boolean writeable = blockConfigFile.setWritable(true);
            if (!writeable) {
                CommonProxy.Logger.log(Level.FATAL, "Cannot write/save the block config file. Insufficient permission.");
                return;
            }
            PrintWriter writer = new PrintWriter(blockConfigFile);
            writer.write(blockDropsString);
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void loadBlockDrops() {
        JsonObject blockDropDataJson = blockJson.getAsJsonObject();
        Gson gson = new Gson();
        blockDropMap.clear();
        for (Map.Entry blockDataEntry : blockDropDataJson.entrySet()) {
            JsonElement blockData = (JsonElement)blockDataEntry.getValue();
            BlockDropData blockDropData = (BlockDropData)gson.fromJson(blockData, BlockDropData.class);
            blockDropMap.put((String)blockDataEntry.getKey(), blockDropData);
        }
    }

    private static String saveBlockDrops() {
        JsonObject blockDropDataJson = new JsonObject();
        Gson gson = new Gson();
        for (Map.Entry<String, BlockDropData> blockDataEntry : blockDropMap.entrySet()) {
            JsonElement element = gson.toJsonTree((Object)blockDataEntry.getValue());
            blockDropDataJson.add(blockDataEntry.getKey(), element);
        }
        return blockDropDataJson.toString();
    }

    public static FortuneQuantityData getQuantityData(int min, int max) {
        FortuneQuantityData fortuneQuantityData = new FortuneQuantityData();
        fortuneQuantityData.minquantity = min;
        fortuneQuantityData.maxquantity = max;
        return fortuneQuantityData;
    }

    public static BlockDropData getBlockDropData(Block block, String blockID, int metadata) {
        BlockDropData blockDropData = blockDropMap.get(blockID + "," + metadata);
        if (blockDropData == null) {
            blockDropData = blockDropMap.get(blockID + ",*");
        }
        if (blockDropData == null) {
            int[] blockOreIds;
            ItemStack blockItemStack = new ItemStack(Item.func_150898_a((Block)block), 1, metadata);
            if (blockItemStack.func_190926_b()) {
                return null;
            }
            for (int oreId : blockOreIds = OreDictionary.getOreIDs((ItemStack)blockItemStack)) {
                String oreName = OreDictionary.getOreName((int)oreId);
                blockDropData = blockDropMap.get("ore:" + oreName + ",*");
            }
        }
        return blockDropData;
    }
}

