/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.structures;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.block.BlockSilverPile;
import com.github.alexthe666.iceandfire.core.ModBlocks;
import com.github.alexthe666.iceandfire.entity.EntityIceDragon;
import com.github.alexthe666.iceandfire.structures.WorldGenCaveStalactites;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.storage.loot.LootTableList;

public class WorldGenIceDragonCave
extends WorldGenerator {
    public static final ResourceLocation ICEDRAGON_CHEST = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("iceandfire", "ice_dragon_female_cave"));
    public static final ResourceLocation ICEDRAGON_MALE_CHEST = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("iceandfire", "ice_dragon_male_cave"));
    private static final WorldGenCaveStalactites CEILING_DECO = new WorldGenCaveStalactites(ModBlocks.frozenStone);
    private static boolean isMale;

    public static void setGoldPile(World world, BlockPos pos, Random rand) {
        int chance = rand.nextInt(99) + 1;
        if (!(world.func_180495_p(pos).func_177230_c() instanceof BlockContainer)) {
            if (chance < 60) {
                int goldRand = Math.max(1, IceAndFire.CONFIG.dragonDenGoldAmount) * (isMale ? 1 : 2);
                boolean generateGold = rand.nextInt(goldRand) == 0;
                world.func_180501_a(pos, generateGold ? ModBlocks.silverPile.func_176223_P().func_177226_a((IProperty)BlockSilverPile.LAYERS, (Comparable)Integer.valueOf(1 + rand.nextInt(7))) : Blocks.field_150350_a.func_176223_P(), 3);
            } else if (chance == 61) {
                TileEntity tileentity1;
                world.func_180501_a(pos, Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)EnumFacing.field_176754_o[rand.nextInt(3)]), 3);
                if (world.func_180495_p(pos).func_177230_c() instanceof BlockChest && (tileentity1 = world.func_175625_s(pos)) instanceof TileEntityChest && !tileentity1.func_145837_r()) {
                    ((TileEntityChest)tileentity1).func_189404_a(isMale ? ICEDRAGON_MALE_CHEST : ICEDRAGON_CHEST, rand.nextLong());
                }
            }
        }
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        ArrayList<SphereInfo> sphereList = new ArrayList<SphereInfo>();
        isMale = rand.nextBoolean();
        int dragonAge = 75 + rand.nextInt(50);
        int radius = (int)((float)dragonAge * 0.2f) + rand.nextInt(8);
        this.createShell(worldIn, rand, position, radius, sphereList);
        for (int i = 0; i < 3 + rand.nextInt(2); ++i) {
            EnumFacing direction = EnumFacing.field_176754_o[rand.nextInt(EnumFacing.field_176754_o.length - 1)];
            this.createShell(worldIn, rand, position.func_177967_a(direction, radius - 2), 2 * (int)((float)radius / 3.0f) + rand.nextInt(8), sphereList);
        }
        for (SphereInfo info : sphereList) {
            this.hollowOut(worldIn, rand, info.pos, info.radius - 2);
            this.decorateCave(worldIn, rand, info.pos, info.radius + 2);
        }
        sphereList.clear();
        EntityIceDragon dragon = new EntityIceDragon(worldIn);
        dragon.setGender(isMale);
        dragon.growDragon(dragonAge);
        dragon.setAgingDisabled(true);
        dragon.func_70606_j(dragon.func_110138_aP());
        dragon.setVariant(rand.nextInt(4));
        dragon.func_70080_a((double)position.func_177958_n() + 0.5, (double)position.func_177956_o() + 0.5, (double)position.func_177952_p() + 0.5, rand.nextFloat() * 360.0f, 0.0f);
        dragon.setSleeping(true);
        dragon.homePos = position;
        dragon.setHunger(50);
        worldIn.func_72838_d((Entity)dragon);
        return false;
    }

    private void decorateCave(World worldIn, Random rand, BlockPos pos, int radius) {
        for (int i = 0; i < 15 + rand.nextInt(10); ++i) {
            CEILING_DECO.generate(worldIn, rand, this.offsetRandomlyByXZ(pos.func_177981_b(radius / 2 - 1), rand, rand.nextInt(radius) - radius / 2, rand.nextInt(radius) - radius / 2));
        }
        int j = radius;
        int k = radius / 2;
        int l = radius;
        float f = (float)(j + k + l) * 0.333f + 0.5f;
        for (BlockPos blockpos : BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-j, -k, -l), (BlockPos)pos.func_177982_a(j, k / 2, l))) {
            if (!(blockpos.func_177951_i((Vec3i)pos) <= (double)(f * f)) || worldIn.func_180495_p(blockpos.func_177977_b()).func_185904_a() != Material.field_151576_e || worldIn.func_180495_p(blockpos).func_185904_a() == Material.field_151576_e) continue;
            WorldGenIceDragonCave.setGoldPile(worldIn, blockpos, rand);
        }
    }

    private BlockPos offsetRandomlyBy(BlockPos in, Random rand, int offset1, int offset2) {
        return in.func_177967_a(EnumFacing.values()[rand.nextInt(EnumFacing.values().length - 1)], offset1).func_177967_a(EnumFacing.values()[rand.nextInt(EnumFacing.values().length - 1)], offset2);
    }

    private BlockPos offsetRandomlyByXZ(BlockPos in, Random rand, int offset1, int offset2) {
        return in.func_177982_a(offset1, 0, offset2);
    }

    private void createShell(World worldIn, Random rand, BlockPos position, int radius, List<SphereInfo> sphereList) {
        int j = radius;
        int k = radius / 2;
        int l = radius;
        float f = (float)(j + k + l) * 0.333f + 0.5f;
        for (BlockPos blockpos : BlockPos.func_177980_a((BlockPos)position.func_177982_a(-j, -k, -l), (BlockPos)position.func_177982_a(j, k, l))) {
            boolean doOres;
            if (!(blockpos.func_177951_i((Vec3i)position) <= (double)(f * f)) || worldIn.func_180495_p(position).func_177230_c() instanceof BlockContainer || !(worldIn.func_180495_p(position).func_177230_c().func_176195_g(worldIn.func_180495_p(position), worldIn, position) >= 0.0f)) continue;
            boolean bl = doOres = rand.nextInt(IceAndFire.CONFIG.oreToStoneRatioForDragonCaves + 1) == 0;
            if (doOres) {
                int chance = rand.nextInt(199) + 1;
                if (chance < 30) {
                    worldIn.func_180501_a(blockpos, Blocks.field_150366_p.func_176223_P(), 3);
                }
                if (chance > 30 && chance < 40) {
                    worldIn.func_180501_a(blockpos, Blocks.field_150352_o.func_176223_P(), 3);
                }
                if (chance > 40 && chance < 50) {
                    worldIn.func_180501_a(blockpos, IceAndFire.CONFIG.generateSilverOre ? ModBlocks.silverOre.func_176223_P() : ModBlocks.frozenStone.func_176223_P(), 3);
                }
                if (chance > 50 && chance < 60) {
                    worldIn.func_180501_a(blockpos, Blocks.field_150365_q.func_176223_P(), 3);
                }
                if (chance > 60 && chance < 70) {
                    worldIn.func_180501_a(blockpos, Blocks.field_150450_ax.func_176223_P(), 3);
                }
                if (chance > 70 && chance < 80) {
                    worldIn.func_180501_a(blockpos, Blocks.field_150369_x.func_176223_P(), 3);
                }
                if (chance > 80 && chance < 90) {
                    worldIn.func_180501_a(blockpos, Blocks.field_150482_ag.func_176223_P(), 3);
                }
                if (chance <= 90 || chance >= 1000) continue;
                worldIn.func_180501_a(blockpos, IceAndFire.CONFIG.generateSapphireOre ? ModBlocks.sapphireOre.func_176223_P() : Blocks.field_150412_bA.func_176223_P(), 3);
                continue;
            }
            worldIn.func_175656_a(blockpos, rand.nextBoolean() ? ModBlocks.frozenCobblestone.func_176223_P() : ModBlocks.frozenStone.func_176223_P());
        }
        sphereList.add(new SphereInfo(radius, position));
    }

    private void hollowOut(World worldIn, Random rand, BlockPos position, int radius) {
        int j = radius;
        int k = radius / 2;
        int l = radius;
        float f = (float)(j + k + l) * 0.333f + 0.5f;
        for (BlockPos blockpos : BlockPos.func_177980_a((BlockPos)position.func_177982_a(-j, -k, -l), (BlockPos)position.func_177982_a(j, k, l))) {
            if (!(blockpos.func_177951_i((Vec3i)position) <= (double)(f * f * MathHelper.func_76131_a((float)rand.nextFloat(), (float)0.75f, (float)1.0f))) || worldIn.func_180495_p(position).func_177230_c() instanceof BlockContainer) continue;
            worldIn.func_175656_a(blockpos, Blocks.field_150350_a.func_176223_P());
        }
    }

    private class SphereInfo {
        int radius;
        BlockPos pos;

        private SphereInfo(int radius, BlockPos pos) {
            this.radius = radius;
            this.pos = pos;
        }
    }
}

