/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.core.ModSounds;
import com.github.alexthe666.iceandfire.entity.DragonUtils;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.IaFDragonAttacks;
import com.github.alexthe666.iceandfire.entity.MiscEntityProperties;
import com.github.alexthe666.iceandfire.entity.StoneEntityProperties;
import net.ilexiconn.llibrary.server.entity.EntityPropertiesHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import org.apache.logging.log4j.Level;

public class IafDragonLogic {
    private EntityDragonBase dragon;

    public IafDragonLogic(EntityDragonBase dragon) {
        this.dragon = dragon;
    }

    public void updateDragonServer() {
        StoneEntityProperties properties;
        EntityPlayer ridingPlayer = this.dragon.getRidingPlayer();
        if (this.dragon.up()) {
            if (!this.dragon.isFlying() && !this.dragon.isHovering()) {
                this.dragon.spacebarTicks += 2;
            }
        } else if (this.dragon.dismount() && (this.dragon.isFlying() || this.dragon.isHovering())) {
            this.dragon.field_70181_x -= 0.4;
            this.dragon.setFlying(false);
            this.dragon.setHovering(false);
        }
        if (!this.dragon.dismount() && (this.dragon.isFlying() || this.dragon.isHovering())) {
            this.dragon.field_70181_x += 0.01;
        }
        if (this.dragon.attack() && this.dragon.func_184179_bs() != null && this.dragon.getDragonStage() > 1) {
            this.dragon.setBreathingFire(true);
            this.dragon.riderShootFire(this.dragon.func_184179_bs());
            this.dragon.fireStopTicks = 10;
        }
        if (this.dragon.strike() && this.dragon.func_184179_bs() != null && this.dragon.func_184179_bs() instanceof EntityPlayer) {
            EntityLivingBase target = DragonUtils.riderLookingAtEntity((EntityLivingBase)this.dragon, (EntityLivingBase)((EntityPlayer)this.dragon.func_184179_bs()), (double)this.dragon.getDragonStage() + (this.dragon.func_174813_aQ().field_72336_d - this.dragon.func_174813_aQ().field_72340_a));
            if (this.dragon.getAnimation() != EntityDragonBase.ANIMATION_BITE) {
                this.dragon.setAnimation(EntityDragonBase.ANIMATION_BITE);
            }
            if (target != null && !DragonUtils.hasSameOwner(this.dragon, (Entity)target)) {
                target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.dragon), (float)((int)this.dragon.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
            }
        }
        if (this.dragon.func_184179_bs() != null && this.dragon.func_184179_bs().func_70093_af()) {
            MiscEntityProperties properties2 = (MiscEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties(this.dragon.func_184179_bs(), MiscEntityProperties.class);
            if (properties2 != null) {
                properties2.hasDismountedDragon = true;
            }
            this.dragon.func_184179_bs().func_184210_p();
        }
        if (this.dragon.isFlying() && !this.dragon.isHovering() && this.dragon.func_184179_bs() != null && !this.dragon.field_70122_E && Math.max(Math.abs(this.dragon.field_70179_y), Math.abs(this.dragon.field_70159_w)) < (double)0.1f) {
            this.dragon.setHovering(true);
            this.dragon.setFlying(false);
        }
        if (!this.dragon.isFlying() && !this.dragon.isHovering() || this.dragon.func_70090_H()) {
            // empty if block
        }
        if (this.dragon.isHovering() && !this.dragon.isFlying() && this.dragon.func_184179_bs() != null && !this.dragon.field_70122_E && Math.max(Math.abs(this.dragon.field_70179_y), Math.abs(this.dragon.field_70159_w)) > (double)0.1f) {
            this.dragon.setFlying(true);
            this.dragon.usingGroundAttack = false;
            this.dragon.setHovering(false);
        }
        if (this.dragon.spacebarTicks > 0) {
            --this.dragon.spacebarTicks;
        }
        if (this.dragon.spacebarTicks > 20 && this.dragon.func_70902_q() != null && this.dragon.func_184188_bt().contains(this.dragon.func_70902_q()) && !this.dragon.isFlying() && !this.dragon.isHovering()) {
            this.dragon.setHovering(true);
        }
        if (this.dragon.isOverAir() && !this.dragon.func_184218_aH()) {
            double ydist = this.dragon.field_70167_r - this.dragon.field_70163_u;
            float planeDist = (float)((Math.abs(this.dragon.field_70159_w) + Math.abs(this.dragon.field_70179_y)) * 6.0);
            if (!this.dragon.isHovering()) {
                this.dragon.incrementDragonPitch((float)ydist * 10.0f);
            }
            this.dragon.setDragonPitch(MathHelper.func_76131_a((float)this.dragon.getDragonPitch(), (float)-60.0f, (float)40.0f));
            float plateau = 2.0f;
            if (this.dragon.getDragonPitch() > plateau) {
                this.dragon.decrementDragonPitch(planeDist * Math.abs(this.dragon.getDragonPitch()) / 90.0f);
            }
            if (this.dragon.getDragonPitch() < -plateau) {
                this.dragon.incrementDragonPitch(planeDist * Math.abs(this.dragon.getDragonPitch()) / 90.0f);
            }
            if (this.dragon.getDragonPitch() > 2.0f) {
                this.dragon.decrementDragonPitch(1.0f);
            } else if (this.dragon.getDragonPitch() < -2.0f) {
                this.dragon.incrementDragonPitch(1.0f);
            }
            if (this.dragon.getDragonPitch() < -45.0f && planeDist < 3.0f && this.dragon.isFlying() && !this.dragon.isHovering()) {
                this.dragon.setHovering(true);
            }
        } else {
            this.dragon.setDragonPitch(0.0f);
        }
        if (IceAndFire.CONFIG.doDragonsSleep && !this.dragon.func_70090_H() && !this.dragon.isSleeping() && this.dragon.field_70122_E && !this.dragon.isFlying() && !this.dragon.isHovering() && this.dragon.func_70638_az() == null && !this.dragon.isDaytime() && this.dragon.func_70681_au().nextInt(250) == 0 && this.dragon.func_70638_az() == null && this.dragon.func_184188_bt().isEmpty()) {
            this.dragon.setSleeping(true);
        }
        if (this.dragon.isSleeping() && (this.dragon.isFlying() || this.dragon.isHovering() || this.dragon.func_70090_H() || this.dragon.field_70170_p.func_175710_j(new BlockPos((Entity)this.dragon)) && this.dragon.isDaytime() && !this.dragon.func_70909_n() || this.dragon.isDaytime() && this.dragon.func_70909_n() || this.dragon.func_70638_az() != null || !this.dragon.func_184188_bt().isEmpty())) {
            this.dragon.setSleeping(false);
        }
        if (this.dragon.func_70906_o() && this.dragon.func_184179_bs() != null) {
            this.dragon.func_70904_g(false);
        }
        if (this.dragon.func_184207_aI() && !this.dragon.isOverAir() && this.dragon.isFlying() && !this.dragon.isHovering() && this.dragon.flyTicks > 40) {
            this.dragon.setFlying(false);
        }
        if (this.dragon.blockBreakCounter <= 0) {
            this.dragon.blockBreakCounter = IceAndFire.CONFIG.dragonBreakBlockCooldown;
        }
        this.dragon.updateBurnTarget();
        if (this.dragon.func_70906_o() && (this.dragon.getCommand() != 1 || this.dragon.func_184179_bs() != null)) {
            this.dragon.func_70904_g(false);
        }
        if (!this.dragon.func_70906_o() && this.dragon.getCommand() == 1 && this.dragon.func_184179_bs() == null) {
            this.dragon.func_70904_g(true);
        }
        if (this.dragon.func_70906_o()) {
            this.dragon.func_70661_as().func_75499_g();
        }
        if (this.dragon.func_70880_s()) {
            this.dragon.field_70170_p.func_72960_a((Entity)this.dragon, (byte)18);
        }
        this.dragon.ticksStill = (int)this.dragon.field_70169_q == (int)this.dragon.field_70165_t && (int)this.dragon.field_70166_s == (int)this.dragon.field_70161_v ? ++this.dragon.ticksStill : 0;
        if (this.dragon.isTackling() && !this.dragon.isFlying() && this.dragon.field_70122_E) {
            ++this.dragon.tacklingTicks;
            if (this.dragon.tacklingTicks == 40) {
                this.dragon.tacklingTicks = 0;
                this.dragon.setTackling(false);
                this.dragon.setFlying(false);
            }
        }
        if (this.dragon.func_70681_au().nextInt(500) == 0 && !this.dragon.isModelDead() && !this.dragon.isSleeping()) {
            this.dragon.roar();
        }
        if (this.dragon.isFlying() && this.dragon.func_70638_az() != null && this.dragon.airAttack == IaFDragonAttacks.Air.TACKLE) {
            this.dragon.setTackling(true);
        }
        if (this.dragon.isFlying() && this.dragon.func_70638_az() != null && this.dragon.isTackling() && this.dragon.func_174813_aQ().func_72321_a(2.0, 2.0, 2.0).func_72326_a(this.dragon.func_70638_az().func_174813_aQ())) {
            this.dragon.usingGroundAttack = true;
            this.dragon.randomizeAttacks();
            this.dragon.func_70638_az().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.dragon), (float)(this.dragon.getDragonStage() * 3));
            this.dragon.setFlying(false);
            this.dragon.setHovering(false);
        }
        if (this.dragon.isTackling() && (this.dragon.func_70638_az() == null || this.dragon.airAttack != IaFDragonAttacks.Air.TACKLE)) {
            this.dragon.setTackling(false);
            this.dragon.randomizeAttacks();
        }
        if ((properties = (StoneEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)this.dragon, StoneEntityProperties.class)) != null && properties.isStone || this.dragon.func_184218_aH()) {
            this.dragon.setFlying(false);
            this.dragon.setHovering(false);
        }
        if (this.dragon.isFlying() && this.dragon.field_70173_aa % 40 == 0 || this.dragon.isFlying() && this.dragon.isSleeping()) {
            this.dragon.setSleeping(false);
        }
        if (!this.dragon.canMove()) {
            if (this.dragon.func_70638_az() != null) {
                this.dragon.func_70624_b(null);
            }
            this.dragon.func_70661_as().func_75499_g();
        }
        this.dragon.updateCheckPlayer();
        if (this.dragon.isModelDead() && (this.dragon.isFlying() || this.dragon.isHovering())) {
            this.dragon.setFlying(false);
            this.dragon.setHovering(false);
        }
        if (ridingPlayer == null) {
            if (this.dragon.useFlyingPathFinder() && this.dragon.navigatorType != 1) {
                this.dragon.switchNavigator(1);
            }
        } else if ((this.dragon.useFlyingPathFinder() || this.dragon.isHovering()) && this.dragon.navigatorType != 2) {
            this.dragon.switchNavigator(2);
        }
        if (!this.dragon.useFlyingPathFinder() && !this.dragon.isHovering() && this.dragon.navigatorType != 0) {
            this.dragon.switchNavigator(0);
        }
        if (!this.dragon.isOverAir() && this.dragon.doesWantToLand() && (this.dragon.isFlying() || this.dragon.isHovering())) {
            this.dragon.setFlying(false);
            this.dragon.setHovering(false);
        }
        if (this.dragon.isHovering() && this.dragon.isFlying() && this.dragon.flyTicks > 40) {
            this.dragon.setHovering(false);
            this.dragon.setFlying(true);
        }
        if (this.dragon.isHovering() && !this.dragon.isFlying()) {
            if (this.dragon.isSleeping()) {
                this.dragon.setHovering(false);
            }
            ++this.dragon.hoverTicks;
            if (this.dragon.doesWantToLand() && !this.dragon.field_70122_E) {
                this.dragon.field_70181_x -= 0.25;
            } else {
                if (this.dragon.func_184179_bs() == null && !this.dragon.isBeyondHeight()) {
                    this.dragon.field_70181_x += 0.08;
                }
                if (this.dragon.hoverTicks > 40) {
                    if (!this.dragon.func_70631_g_()) {
                        this.dragon.setFlying(true);
                    }
                    this.dragon.setHovering(false);
                    this.dragon.flyHovering = 0;
                    this.dragon.hoverTicks = 0;
                    this.dragon.flyTicks = 0;
                }
            }
        }
        if (this.dragon.isSleeping()) {
            this.dragon.func_70661_as().func_75499_g();
        }
        if ((this.dragon.field_70122_E || this.dragon.func_70090_H()) && this.dragon.flyTicks != 0) {
            this.dragon.flyTicks = 0;
        }
        if (this.dragon.isAllowedToTriggerFlight() && this.dragon.isFlying() && this.dragon.doesWantToLand()) {
            this.dragon.setFlying(false);
            this.dragon.setHovering(this.dragon.isOverAir());
            if (!this.dragon.isOverAir()) {
                this.dragon.flyTicks = 0;
                this.dragon.setFlying(false);
            }
        }
        if (this.dragon.isFlying()) {
            ++this.dragon.flyTicks;
        }
        if ((this.dragon.isHovering() || this.dragon.isFlying()) && this.dragon.isSleeping()) {
            this.dragon.setFlying(false);
            this.dragon.setHovering(false);
        }
        if ((properties == null || properties != null && !properties.isStone) && !this.dragon.isFlying() && !this.dragon.isHovering() && (this.dragon.isAllowedToTriggerFlight() || this.dragon.field_70163_u < -1.0) && (this.dragon.func_70681_au().nextInt(1500) == 0 || this.dragon.field_70163_u < -1.0 || this.dragon.func_70638_az() != null && this.dragon.func_70638_az().field_70163_u + 5.0 < this.dragon.field_70163_u)) {
            this.dragon.setHovering(true);
            this.dragon.setSleeping(false);
            this.dragon.func_70904_g(false);
            this.dragon.flyHovering = 0;
            this.dragon.hoverTicks = 0;
            this.dragon.flyTicks = 0;
        }
        if (this.dragon.func_70638_az() != null && !this.dragon.func_184188_bt().isEmpty() && this.dragon.func_70902_q() != null && this.dragon.func_184188_bt().contains(this.dragon.func_70902_q())) {
            this.dragon.func_70624_b(null);
        }
        if (!this.dragon.isAgingDisabled()) {
            this.dragon.setAgeInTicks(this.dragon.getAgeInTicks() + 1);
            if (this.dragon.getAgeInTicks() % 24000 == 0) {
                this.dragon.updateAttributes();
                this.dragon.growDragon(0);
            }
        }
        if (this.dragon.getAgeInTicks() % IceAndFire.CONFIG.dragonHungerTickRate == 0 && this.dragon.getHunger() > 0) {
            this.dragon.setHunger(this.dragon.getHunger() - 1);
        }
        if (this.dragon.groundAttack == IaFDragonAttacks.Ground.FIRE && this.dragon.getDragonStage() < 2) {
            this.dragon.usingGroundAttack = true;
            this.dragon.randomizeAttacks();
            this.dragon.func_184185_a(this.dragon.getBabyFireSound(), 1.0f, 1.0f);
        }
        if (this.dragon.isBreathingFire()) {
            ++this.dragon.fireTicks;
            if (this.dragon.fireTicks > this.dragon.getDragonStage() * 25 || this.dragon.func_70902_q() != null && this.dragon.func_184188_bt().contains(this.dragon.func_70902_q()) && this.dragon.fireStopTicks <= 0) {
                this.dragon.setBreathingFire(false);
                this.dragon.randomizeAttacks();
                this.dragon.fireTicks = 0;
            }
            if (this.dragon.fireStopTicks > 0 && this.dragon.func_70902_q() != null && this.dragon.func_184188_bt().contains(this.dragon.func_70902_q())) {
                --this.dragon.fireStopTicks;
            }
        }
        if (this.dragon.isFlying() && this.dragon.func_70638_az() != null && this.dragon.func_174813_aQ().func_72321_a(3.0, 3.0, 3.0).func_72326_a(this.dragon.func_70638_az().func_174813_aQ())) {
            this.dragon.func_70652_k((Entity)this.dragon.func_70638_az());
        }
        if (this.dragon.isFlying() && this.dragon.airAttack == IaFDragonAttacks.Air.TACKLE && (this.dragon.field_70132_H || this.dragon.field_70122_E)) {
            this.dragon.usingGroundAttack = true;
            this.dragon.setFlying(false);
            this.dragon.setHovering(false);
        }
        if (this.dragon.isFlying() && this.dragon.usingGroundAttack) {
            this.dragon.airAttack = IaFDragonAttacks.Air.TACKLE;
        }
        if (this.dragon.isFlying() && this.dragon.airAttack == IaFDragonAttacks.Air.TACKLE && this.dragon.func_70638_az() != null && this.dragon.isTargetBlocked(this.dragon.func_70638_az().func_174791_d())) {
            this.dragon.randomizeAttacks();
        }
    }

    public void updateDragonClient() {
        if (!this.dragon.isModelDead()) {
            this.dragon.turn_buffer.calculateChainSwingBuffer(50.0f, 0, 4.0f, (EntityLivingBase)this.dragon);
            this.dragon.tail_buffer.calculateChainSwingBuffer(90.0f, 20, 5.0f, (EntityLivingBase)this.dragon);
            if (!this.dragon.field_70122_E) {
                this.dragon.roll_buffer.calculateChainFlapBuffer(55.0f, 1, 2.0f, 0.5f, (EntityLivingBase)this.dragon);
                this.dragon.pitch_buffer.calculateChainWaveBuffer(90.0f, 10, 1.0f, 0.5f, (EntityLivingBase)this.dragon);
                this.dragon.pitch_buffer_body.calculateChainWaveBuffer(80.0f, 10, 1.0f, 0.5f, (EntityLivingBase)this.dragon);
            }
        }
        this.dragon.walkCycle = this.dragon.walkCycle < 39 ? ++this.dragon.walkCycle : 0;
        if (this.dragon.getAnimation() == EntityDragonBase.ANIMATION_WINGBLAST && (this.dragon.getAnimationTick() == 17 || this.dragon.getAnimationTick() == 22 || this.dragon.getAnimationTick() == 28)) {
            this.dragon.spawnGroundEffects();
        }
        this.dragon.legSolver.update(this.dragon, this.dragon.getRenderSize() / 3.0f);
        this.dragon.flightCycle = this.dragon.flightCycle < 58 ? (this.dragon.flightCycle += 2) : 0;
        if (this.dragon.flightCycle == 2 && !this.dragon.isDiving() && (this.dragon.isFlying() || this.dragon.isHovering())) {
            float dragonSoundVolume = IceAndFire.CONFIG.dragonFlapNoiseDistance;
            float dragonSoundPitch = this.dragon.func_70647_i();
            this.dragon.func_184185_a(ModSounds.DRAGON_FLIGHT, dragonSoundVolume, dragonSoundPitch);
        }
        if (this.dragon.flightCycle == 11) {
            this.dragon.spawnGroundEffects();
        }
        if (this.dragon.isModelDead() && this.dragon.flightCycle != 0) {
            this.dragon.flightCycle = 0;
        }
    }

    public void updateDragonCommon() {
        boolean riding;
        boolean tackling;
        boolean hovering;
        boolean sleeping;
        boolean sitting;
        if (this.dragon.isBreathingFire() && this.dragon.burnProgress < 40) {
            ++this.dragon.burnProgress;
        } else if (!this.dragon.isBreathingFire()) {
            this.dragon.burnProgress = 0;
        }
        boolean bl = sitting = this.dragon.func_70906_o() && !this.dragon.isModelDead() && !this.dragon.isSleeping() && !this.dragon.isHovering() && !this.dragon.isFlying();
        if (sitting && this.dragon.sitProgress < 20.0f) {
            this.dragon.sitProgress += 0.5f;
        } else if (!sitting && this.dragon.sitProgress > 0.0f) {
            this.dragon.sitProgress -= 0.5f;
        }
        boolean bl2 = sleeping = this.dragon.isSleeping() && !this.dragon.isHovering() && !this.dragon.isFlying();
        if (sleeping && this.dragon.sleepProgress < 20.0f) {
            this.dragon.sleepProgress += 0.5f;
        } else if (!sleeping && this.dragon.sleepProgress > 0.0f) {
            this.dragon.sleepProgress -= 0.5f;
        }
        boolean fireBreathing = this.dragon.isBreathingFire();
        this.dragon.prevFireBreathProgress = this.dragon.fireBreathProgress;
        if (fireBreathing && this.dragon.fireBreathProgress < 10.0f) {
            this.dragon.fireBreathProgress += 0.5f;
        } else if (!fireBreathing && this.dragon.fireBreathProgress > 0.0f) {
            this.dragon.fireBreathProgress -= 0.5f;
        }
        boolean bl3 = hovering = this.dragon.isHovering() || this.dragon.isFlying() && this.dragon.airAttack == IaFDragonAttacks.Air.HOVER_BLAST && this.dragon.func_70638_az() != null && this.dragon.func_70011_f(this.dragon.func_70638_az().field_70165_t, this.dragon.field_70163_u, this.dragon.func_70638_az().field_70161_v) < 17.0;
        if (hovering && this.dragon.hoverProgress < 20.0f) {
            this.dragon.hoverProgress += 0.5f;
        } else if (!hovering && this.dragon.hoverProgress > 0.0f) {
            this.dragon.hoverProgress -= 2.0f;
        }
        boolean diving = this.dragon.isDiving();
        this.dragon.prevDiveProgress = this.dragon.diveProgress;
        if (diving && this.dragon.diveProgress < 10.0f) {
            this.dragon.diveProgress += 1.0f;
        } else if (!diving && this.dragon.diveProgress > 0.0f) {
            this.dragon.diveProgress -= 2.0f;
        }
        boolean bl4 = tackling = this.dragon.isTackling() && this.dragon.isOverAir();
        if (tackling && this.dragon.tackleProgress < 5.0f) {
            this.dragon.tackleProgress += 0.5f;
        } else if (!tackling && this.dragon.tackleProgress > 0.0f) {
            this.dragon.tackleProgress -= 1.5f;
        }
        boolean flying = this.dragon.isFlying();
        if (flying && this.dragon.flyProgress < 20.0f) {
            this.dragon.flyProgress += 0.5f;
        } else if (!flying && this.dragon.flyProgress > 0.0f) {
            this.dragon.flyProgress -= 2.0f;
        }
        boolean modeldead = this.dragon.isModelDead();
        if (modeldead && this.dragon.modelDeadProgress < 20.0f) {
            this.dragon.modelDeadProgress += 0.5f;
        } else if (!modeldead && this.dragon.modelDeadProgress > 0.0f) {
            this.dragon.modelDeadProgress -= 0.5f;
        }
        boolean bl5 = riding = this.dragon.func_184218_aH() && this.dragon.func_184187_bx() != null && this.dragon.func_184187_bx() instanceof EntityPlayer;
        if (riding && this.dragon.ridingProgress < 20.0f) {
            this.dragon.ridingProgress += 0.5f;
        } else if (!riding && this.dragon.ridingProgress > 0.0f) {
            this.dragon.ridingProgress -= 0.5f;
        }
        if (this.dragon.hasHadHornUse) {
            this.dragon.hasHadHornUse = false;
        }
        if (this.dragon.groundAttack == IaFDragonAttacks.Ground.FIRE && this.dragon.getDragonStage() < 2) {
            if (this.dragon.field_70170_p.field_72995_K) {
                this.dragon.spawnBabyParticles();
            }
            this.dragon.randomizeAttacks();
        }
    }

    public void updateDragonAttack() {
        EntityLivingBase target;
        double dist;
        if (this.dragon.isPlayingAttackAnimation() && this.dragon.func_70638_az() != null && this.dragon.func_70685_l((Entity)this.dragon.func_70638_az()) && (dist = (double)this.dragon.func_70032_d((Entity)(target = this.dragon.func_70638_az()))) < (double)this.dragon.getRenderSize() * 0.2574 * 2.0 + 2.0) {
            if (this.dragon.getAnimation() == EntityDragonBase.ANIMATION_BITE && this.dragon.getAnimationTick() > 15 && this.dragon.getAnimationTick() < 25) {
                target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.dragon), (float)((int)this.dragon.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
                this.dragon.usingGroundAttack = this.dragon.func_70681_au().nextBoolean();
                this.dragon.randomizeAttacks();
            }
            if (this.dragon.getAnimation() == EntityDragonBase.ANIMATION_TAILWHACK && this.dragon.getAnimationTick() > 20 && this.dragon.getAnimationTick() < 30) {
                target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.dragon), (float)((int)this.dragon.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
                target.func_70653_a((Entity)this.dragon, (float)this.dragon.getDragonStage() * 0.6f, (double)MathHelper.func_76126_a((float)(this.dragon.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.dragon.field_70177_z * ((float)Math.PI / 180)))));
                this.dragon.usingGroundAttack = this.dragon.func_70681_au().nextBoolean();
                this.dragon.randomizeAttacks();
            }
            if (this.dragon.getAnimation() == EntityDragonBase.ANIMATION_WINGBLAST && (this.dragon.getAnimationTick() == 15 || this.dragon.getAnimationTick() == 25 || this.dragon.getAnimationTick() == 35)) {
                target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.dragon), (float)((int)this.dragon.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
                target.func_70653_a((Entity)this.dragon, (float)this.dragon.getDragonStage() * 0.6f, (double)MathHelper.func_76126_a((float)(this.dragon.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.dragon.field_70177_z * ((float)Math.PI / 180)))));
                this.dragon.usingGroundAttack = this.dragon.func_70681_au().nextBoolean();
                this.dragon.randomizeAttacks();
            }
        }
    }

    public void debug() {
        String side = this.dragon.field_70170_p.field_72995_K ? "CLIENT" : "SERVER";
        String owner = this.dragon.func_70902_q() == null ? "null" : this.dragon.func_70902_q().func_70005_c_();
        String attackTarget = this.dragon.func_70638_az() == null ? "null" : this.dragon.func_70638_az().func_70005_c_();
        IceAndFire.logger.log(Level.INFO, "DRAGON DEBUG[" + side + "]:\nStage: " + this.dragon.getDragonStage() + "\nAge: " + this.dragon.getAgeInDays() + "\nVariant: " + this.dragon.getVariantName(this.dragon.getVariant()) + "\nOwner: " + owner + "\nAttack Target: " + attackTarget + "\nFlying: " + this.dragon.isFlying() + "\nHovering: " + this.dragon.isHovering() + "\nWidth: " + this.dragon.field_70130_N);
    }

    public void debugPathfinder(Path currentPath) {
    }
}

