/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.entity.DragonUtils;
import com.github.alexthe666.iceandfire.entity.EntityAmphithere;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntityIceDragon;
import com.github.alexthe666.iceandfire.entity.IaFDragonAttacks;
import com.github.alexthe666.iceandfire.util.IAFMath;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;

public class IaFDragonFlightManager {
    private EntityDragonBase dragon;
    private Vec3d target;
    private IaFDragonAttacks.Air prevAirAttack;
    private Vec3d startAttackVec;
    private Vec3d startPreyVec;
    private boolean hasStartedToScorch = false;
    private EntityLivingBase prevAttackTarget = null;

    public IaFDragonFlightManager(EntityDragonBase dragon) {
        this.dragon = dragon;
    }

    public static float approach(float number, float max, float min) {
        min = Math.abs(min);
        return number < max ? MathHelper.func_76131_a((float)(number + min), (float)number, (float)max) : MathHelper.func_76131_a((float)(number - min), (float)max, (float)number);
    }

    public static float approachDegrees(float number, float max, float min) {
        float add = MathHelper.func_76142_g((float)(max - number));
        return IaFDragonFlightManager.approach(number, number + add, min);
    }

    public static float degreesDifferenceAbs(float f1, float f2) {
        return Math.abs(MathHelper.func_76142_g((float)(f2 - f1)));
    }

    public void update() {
        if (this.dragon.func_70638_az() != null && !this.dragon.func_70638_az().field_70128_L) {
            if (this.dragon instanceof EntityIceDragon && this.dragon.func_70090_H()) {
                this.dragon.airAttack = this.dragon.func_70638_az() == null ? IaFDragonAttacks.Air.SCORCH_STREAM : IaFDragonAttacks.Air.TACKLE;
            }
            EntityLivingBase entity = this.dragon.func_70638_az();
            if (this.dragon.airAttack == IaFDragonAttacks.Air.TACKLE) {
                this.target = new Vec3d(entity.field_70165_t, entity.field_70163_u + (double)entity.field_70131_O, entity.field_70161_v);
            }
            if (this.dragon.airAttack == IaFDragonAttacks.Air.HOVER_BLAST) {
                float distY = 5 + this.dragon.getDragonStage() * 2;
                int randomDist = 20;
                if (this.dragon.func_70011_f(entity.field_70165_t, this.dragon.field_70163_u, entity.field_70161_v) < 4.0 || this.dragon.func_70011_f(entity.field_70165_t, this.dragon.field_70163_u, entity.field_70161_v) > 30.0) {
                    this.target = new Vec3d(entity.field_70165_t + (double)this.dragon.func_70681_au().nextInt(randomDist) - (double)(randomDist / 2), entity.field_70163_u + (double)distY, entity.field_70161_v + (double)this.dragon.func_70681_au().nextInt(randomDist) - (double)(randomDist / 2));
                }
                this.dragon.stimulateFire(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 3);
            }
            if (this.dragon.airAttack == IaFDragonAttacks.Air.SCORCH_STREAM && this.startPreyVec != null && this.startAttackVec != null) {
                float distX = (float)(this.startPreyVec.field_72450_a - this.startAttackVec.field_72450_a);
                float distY = 5 + this.dragon.getDragonStage() * 2;
                float distZ = (float)(this.startPreyVec.field_72449_c - this.startAttackVec.field_72449_c);
                this.target = new Vec3d(entity.field_70165_t + (double)distX, entity.field_70163_u + (double)distY, entity.field_70161_v + (double)distZ);
                this.dragon.tryScorchTarget();
                this.hasStartedToScorch = true;
                if (this.target != null && this.dragon.func_70011_f(this.target.field_72450_a, this.target.field_72448_b, this.target.field_72449_c) < 10.0) {
                    this.target = new Vec3d(entity.field_70165_t - (double)distX, entity.field_70163_u + (double)distY, entity.field_70161_v - (double)distZ);
                }
            }
        } else if (this.target == null || this.dragon.func_70011_f(this.target.field_72450_a, this.target.field_72448_b, this.target.field_72449_c) < 2.0 || !this.dragon.field_70170_p.func_175623_d(new BlockPos(this.target)) && (this.dragon.isHovering() || this.dragon.isFlying()) || this.dragon.getCommand() == 2 && this.dragon.shouldTPtoOwner()) {
            BlockPos viewBlock = DragonUtils.getBlockInView(this.dragon);
            if (this.dragon instanceof EntityIceDragon && !this.dragon.isHovering() && !this.dragon.isFlying()) {
                viewBlock = DragonUtils.getWaterBlockInView(this.dragon);
            }
            if (this.dragon.getCommand() == 2 && this.dragon.isFlying()) {
                viewBlock = DragonUtils.getBlockInViewEscort(this.dragon);
            }
            if (viewBlock != null) {
                this.target = new Vec3d((double)viewBlock.func_177958_n() + 0.5, (double)viewBlock.func_177956_o() + 0.5, (double)viewBlock.func_177952_p() + 0.5);
            }
        }
        if (this.target != null) {
            if (this.target.field_72448_b > (double)IceAndFire.CONFIG.maxDragonFlight) {
                this.target = new Vec3d(this.target.field_72450_a, (double)IceAndFire.CONFIG.maxDragonFlight, this.target.field_72449_c);
            }
            if (this.target.field_72448_b >= this.dragon.field_70163_u && !this.dragon.isModelDead()) {
                this.dragon.field_70181_x += 0.1;
            }
        }
        this.prevAirAttack = this.dragon.airAttack;
    }

    public Vec3d getFlightTarget() {
        return this.target == null ? Vec3d.field_186680_a : this.target;
    }

    private float getDistanceXZ(double x, double z) {
        float f = (float)(this.dragon.field_70165_t - x);
        float f2 = (float)(this.dragon.field_70161_v - z);
        return f * f + f2 * f2;
    }

    public void onSetAttackTarget(@Nullable EntityLivingBase entitylivingbaseIn) {
        if (this.prevAttackTarget != entitylivingbaseIn) {
            this.startPreyVec = entitylivingbaseIn != null ? new Vec3d(entitylivingbaseIn.field_70165_t, entitylivingbaseIn.field_70163_u, entitylivingbaseIn.field_70161_v) : new Vec3d(this.dragon.field_70165_t, this.dragon.field_70163_u, this.dragon.field_70161_v);
            this.startAttackVec = new Vec3d(this.dragon.field_70165_t, this.dragon.field_70163_u, this.dragon.field_70161_v);
        }
        this.prevAttackTarget = entitylivingbaseIn;
    }

    protected static class PlayerFlightMoveHelper<T extends EntityCreature>
    extends EntityMoveHelper {
        private T dragon;

        public PlayerFlightMoveHelper(T dragon) {
            super(dragon);
            this.dragon = dragon;
        }

        public void func_75641_c() {
            double flySpeed = this.field_75645_e * this.speedMod();
            Vec3d dragonVec = this.dragon.func_174791_d();
            Vec3d moveVec = new Vec3d(this.field_75646_b, this.field_75647_c, this.field_75644_d);
            Vec3d normalized = moveVec.func_178788_d(dragonVec).func_72432_b();
            double dist = dragonVec.func_72438_d(moveVec);
            ((EntityCreature)this.dragon).field_70159_w = normalized.field_72450_a * flySpeed;
            ((EntityCreature)this.dragon).field_70181_x = normalized.field_72448_b * flySpeed;
            ((EntityCreature)this.dragon).field_70179_y = normalized.field_72449_c * flySpeed;
            if (dist > 2.5E-7) {
                float yaw = (float)Math.toDegrees(Math.PI * 2 - Math.atan2(normalized.field_72450_a, normalized.field_72448_b));
                ((EntityCreature)this.dragon).field_70177_z = this.func_75639_a(((EntityCreature)this.dragon).field_70177_z, yaw, 5.0f);
                this.field_75648_a.func_70659_e((float)this.field_75645_e);
            }
            this.dragon.func_70091_d(MoverType.SELF, ((EntityCreature)this.dragon).field_70159_w, ((EntityCreature)this.dragon).field_70181_x, ((EntityCreature)this.dragon).field_70179_y);
        }

        public double speedMod() {
            return this.dragon instanceof EntityAmphithere ? 0.75 : 0.5;
        }
    }

    protected static class FlightMoveHelper
    extends EntityMoveHelper {
        private EntityDragonBase dragon;

        protected FlightMoveHelper(EntityDragonBase dragonBase) {
            super((EntityLiving)dragonBase);
            this.dragon = dragonBase;
        }

        public void func_75641_c() {
            if (this.dragon.field_70123_F) {
                this.dragon.field_70177_z += 180.0f;
                this.field_75645_e = 0.1f;
                this.dragon.flightManager.target = null;
                return;
            }
            float distX = (float)(this.dragon.flightManager.getFlightTarget().field_72450_a - this.dragon.field_70165_t);
            float distY = (float)(this.dragon.flightManager.getFlightTarget().field_72448_b - this.dragon.field_70163_u);
            float distZ = (float)(this.dragon.flightManager.getFlightTarget().field_72449_c - this.dragon.field_70161_v);
            double planeDist = MathHelper.func_76129_c((float)(distX * distX + distZ * distZ));
            double yDistMod = 1.0 - (double)MathHelper.func_76135_e((float)(distY * 0.7f)) / planeDist;
            distX = (float)((double)distX * yDistMod);
            distZ = (float)((double)distZ * yDistMod);
            planeDist = MathHelper.func_76129_c((float)(distX * distX + distZ * distZ));
            double dist = MathHelper.func_76129_c((float)(distX * distX + distZ * distZ + distY * distY));
            if (dist > 1.0) {
                float finPitch;
                float yawCopy = this.dragon.field_70177_z;
                float atan = (float)MathHelper.func_181159_b((double)distZ, (double)distX);
                float yawTurn = MathHelper.func_76142_g((float)(this.dragon.field_70177_z + 90.0f));
                float yawTurnAtan = MathHelper.func_76142_g((float)(atan * 57.295776f));
                this.dragon.field_70761_aq = this.dragon.field_70177_z = IaFDragonFlightManager.approachDegrees(yawTurn, yawTurnAtan, this.dragon.airAttack == IaFDragonAttacks.Air.TACKLE && this.dragon.func_70638_az() != null ? 10.0f : 4.0f) - 90.0f;
                if (IaFDragonFlightManager.degreesDifferenceAbs(yawCopy, this.dragon.field_70177_z) < 3.0f) {
                    this.field_75645_e = IaFDragonFlightManager.approach((float)this.field_75645_e, 1.8f, 0.005f * (1.8f / (float)this.field_75645_e));
                } else {
                    this.field_75645_e = IaFDragonFlightManager.approach((float)this.field_75645_e, 0.2f, 0.025f);
                    if (dist < 100.0 && this.dragon.func_70638_az() != null) {
                        this.field_75645_e *= dist / 100.0;
                    }
                }
                this.dragon.field_70125_A = finPitch = (float)(-(MathHelper.func_181159_b((double)(-distY), (double)planeDist) * 57.2957763671875));
                float yawTurnHead = this.dragon.field_70177_z + 90.0f;
                this.field_75645_e *= this.dragon.getFlightSpeedModifier();
                double lvt_16_1_ = this.field_75645_e * (double)MathHelper.func_76134_b((float)(yawTurnHead * ((float)Math.PI / 180))) * Math.abs((double)distX / dist);
                double lvt_18_1_ = this.field_75645_e * (double)MathHelper.func_76126_a((float)(yawTurnHead * ((float)Math.PI / 180))) * Math.abs((double)distZ / dist);
                double lvt_20_1_ = this.field_75645_e * (double)MathHelper.func_76126_a((float)(finPitch * ((float)Math.PI / 180))) * Math.abs((double)distY / dist);
                this.dragon.field_70159_w += lvt_16_1_ * 0.2;
                this.dragon.field_70181_x += lvt_20_1_ * 0.2;
                this.dragon.field_70179_y += lvt_18_1_ * 0.2;
            }
        }
    }

    protected static class GroundMoveHelper
    extends EntityMoveHelper {
        public GroundMoveHelper(EntityLiving entitylivingIn) {
            super(entitylivingIn);
        }

        public float distance(float rotateAngleFrom, float rotateAngleTo) {
            return (float)IAFMath.atan2_accurate(MathHelper.func_76126_a((float)(rotateAngleTo - rotateAngleFrom)), MathHelper.func_76134_b((float)(rotateAngleTo - rotateAngleFrom)));
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.STRAFE) {
                NodeProcessor nodeprocessor;
                float f = (float)this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
                float f1 = (float)this.field_75645_e * f;
                float f2 = this.field_188489_f;
                float f3 = this.field_188490_g;
                float f4 = MathHelper.func_76129_c((float)(f2 * f2 + f3 * f3));
                if (f4 < 1.0f) {
                    f4 = 1.0f;
                }
                f4 = f1 / f4;
                float f5 = MathHelper.func_76126_a((float)(this.field_75648_a.field_70177_z * ((float)Math.PI / 180)));
                float f6 = MathHelper.func_76134_b((float)(this.field_75648_a.field_70177_z * ((float)Math.PI / 180)));
                float f7 = (f2 *= f4) * f6 - (f3 *= f4) * f5;
                float f8 = f3 * f6 + f2 * f5;
                PathNavigate pathnavigate = this.field_75648_a.func_70661_as();
                if (pathnavigate != null && (nodeprocessor = pathnavigate.func_189566_q()) != null && nodeprocessor.func_186330_a((IBlockAccess)this.field_75648_a.field_70170_p, MathHelper.func_76128_c((double)(this.field_75648_a.field_70165_t + (double)f7)), MathHelper.func_76128_c((double)this.field_75648_a.field_70163_u), MathHelper.func_76128_c((double)(this.field_75648_a.field_70161_v + (double)f8))) != PathNodeType.WALKABLE) {
                    this.field_188489_f = 1.0f;
                    this.field_188490_g = 0.0f;
                    f1 = f;
                }
                this.field_75648_a.func_70659_e(f1);
                this.field_75648_a.func_191989_p(this.field_188489_f);
                this.field_75648_a.func_184646_p(this.field_188490_g);
                this.field_188491_h = EntityMoveHelper.Action.WAIT;
            } else if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                this.field_188491_h = EntityMoveHelper.Action.WAIT;
                EntityDragonBase dragonBase = (EntityDragonBase)this.field_75648_a;
                double d0 = this.field_75646_b - this.field_75648_a.field_70165_t;
                double d2 = this.field_75647_c - this.field_75648_a.field_70163_u;
                double d1 = this.field_75644_d - this.field_75648_a.field_70161_v;
                double d3 = d0 * d0 + d2 * d2 + d1 * d1;
                if (d3 < 2.500000277905201E-7) {
                    this.field_75648_a.func_191989_p(0.0f);
                    return;
                }
                float targetDegree = (float)(MathHelper.func_181159_b((double)d1, (double)d0) * 57.29577951308232) - 90.0f;
                float changeRange = 70.0f;
                if (dragonBase.field_70130_N > 2.0f) {
                    float ageMod = 1.0f - (float)Math.min(dragonBase.getAgeInDays(), 125) / 125.0f;
                    changeRange = 5.0f + ageMod * 10.0f;
                }
                this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, targetDegree, changeRange);
                this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                if (d2 > (double)this.field_75648_a.field_70138_W && d0 * d0 + d1 * d1 < (double)Math.max(1.0f, this.field_75648_a.field_70130_N)) {
                    this.field_75648_a.func_70683_ar().func_75660_a();
                    this.field_188491_h = EntityMoveHelper.Action.JUMPING;
                }
            } else if (this.field_188491_h == EntityMoveHelper.Action.JUMPING) {
                this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                if (this.field_75648_a.field_70122_E) {
                    this.field_188491_h = EntityMoveHelper.Action.WAIT;
                }
            } else {
                this.field_75648_a.func_191989_p(0.0f);
            }
        }
    }
}

