/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.block.BlockCharedPath;
import com.github.alexthe666.iceandfire.block.BlockFallingReturningState;
import com.github.alexthe666.iceandfire.block.BlockReturningState;
import com.github.alexthe666.iceandfire.block.IDragonProof;
import com.github.alexthe666.iceandfire.core.ModBlocks;
import com.github.alexthe666.iceandfire.entity.DragonUtils;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.FrozenEntityProperties;
import com.github.alexthe666.iceandfire.entity.tile.TileEntityDragonforgeInput;
import net.ilexiconn.llibrary.server.entity.EntityPropertiesHandler;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class IaFDragonDestructionManager {
    public static void destroyAreaFire(World world, BlockPos center, EntityDragonBase destroyer) {
        int stage = destroyer.getDragonStage();
        double damageRadius = 3.5;
        float dmgScale = (float)IceAndFire.CONFIG.dragonAttackDamageFire;
        if (stage <= 3) {
            for (BlockPos pos : BlockPos.func_177980_a((BlockPos)center.func_177982_a(-1, -1, -1), (BlockPos)center.func_177982_a(1, 1, 1))) {
                if (IceAndFire.CONFIG.dragonGriefing != 2 && world.field_73012_v.nextBoolean()) {
                    IBlockState transformState = IaFDragonDestructionManager.transformBlockFire(world.func_180495_p(pos));
                    world.func_175656_a(pos, transformState);
                    if (world.field_73012_v.nextBoolean() && transformState.func_185913_b() && world.func_175623_d(pos.func_177984_a())) {
                        world.func_175656_a(pos.func_177984_a(), Blocks.field_150480_ab.func_176223_P());
                    }
                }
                if (world.func_175625_s(pos) == null || !(world.func_175625_s(pos) instanceof TileEntityDragonforgeInput)) continue;
                ((TileEntityDragonforgeInput)world.func_175625_s(pos)).onHitWithFlame();
            }
            for (EntityLivingBase entityliving : world.func_72872_a(EntityLivingBase.class, new AxisAlignedBB((double)center.func_177958_n() - damageRadius, (double)center.func_177956_o() - damageRadius, (double)center.func_177952_p() - damageRadius, (double)center.func_177958_n() + damageRadius, (double)center.func_177956_o() + damageRadius, (double)center.func_177952_p() + damageRadius))) {
                if (DragonUtils.onSameTeam((Entity)destroyer, (Entity)entityliving) || destroyer.func_70028_i((Entity)entityliving) || !destroyer.func_70685_l((Entity)entityliving)) continue;
                entityliving.func_70097_a(IceAndFire.dragonFire, (float)stage * dmgScale);
                entityliving.func_70015_d(5 + stage * 5);
            }
        } else {
            int radius = stage == 4 ? 2 : 3;
            int j = radius + world.field_73012_v.nextInt(1);
            int k = radius + world.field_73012_v.nextInt(1);
            int l = radius + world.field_73012_v.nextInt(1);
            float f = (float)(j + k + l) * 0.333f + 0.5f;
            damageRadius = 2.5f + f * 1.2f;
            for (BlockPos blockpos : BlockPos.func_177980_a((BlockPos)center.func_177982_a(-j, -k, -l), (BlockPos)center.func_177982_a(j, k, l))) {
                if (blockpos.func_177951_i((Vec3i)center) <= (double)(f * f) && IceAndFire.CONFIG.dragonGriefing != 2 && world.field_73012_v.nextFloat() > (float)blockpos.func_177951_i((Vec3i)center) / (f * f)) {
                    IBlockState transformState = IaFDragonDestructionManager.transformBlockFire(world.func_180495_p(blockpos));
                    world.func_175656_a(blockpos, transformState);
                    if (world.field_73012_v.nextBoolean() && transformState.func_185913_b() && world.func_175623_d(blockpos.func_177984_a())) {
                        world.func_175656_a(blockpos.func_177984_a(), Blocks.field_150480_ab.func_176223_P());
                    }
                }
                if (world.func_175625_s(blockpos) == null || !(world.func_175625_s(blockpos) instanceof TileEntityDragonforgeInput)) continue;
                ((TileEntityDragonforgeInput)world.func_175625_s(blockpos)).onHitWithFlame();
            }
            for (EntityLivingBase entityliving : world.func_72872_a(EntityLivingBase.class, new AxisAlignedBB((double)center.func_177958_n() - damageRadius, (double)center.func_177956_o() - damageRadius, (double)center.func_177952_p() - damageRadius, (double)center.func_177958_n() + damageRadius, (double)center.func_177956_o() + damageRadius, (double)center.func_177952_p() + damageRadius))) {
                if (DragonUtils.onSameTeam((Entity)destroyer, (Entity)entityliving) || destroyer.func_70028_i((Entity)entityliving) || !destroyer.func_70685_l((Entity)entityliving)) continue;
                entityliving.func_70097_a(IceAndFire.dragonFire, (float)stage * dmgScale);
                entityliving.func_70015_d(5 + stage * 5);
            }
        }
    }

    public static void destroyAreaIce(World world, BlockPos center, EntityDragonBase destroyer) {
        int stage = destroyer.getDragonStage();
        double damageRadius = 3.5;
        float dmgScale = (float)IceAndFire.CONFIG.dragonAttackDamageIce;
        if (stage <= 3) {
            for (BlockPos pos : BlockPos.func_177980_a((BlockPos)center.func_177982_a(-1, -1, -1), (BlockPos)center.func_177982_a(1, 1, 1))) {
                if (IceAndFire.CONFIG.dragonGriefing != 2 && world.field_73012_v.nextBoolean()) {
                    IBlockState transformState = IaFDragonDestructionManager.transformBlockIce(world.func_180495_p(pos));
                    world.func_175656_a(pos, transformState);
                    if (world.field_73012_v.nextInt(9) == 0 && transformState.func_185913_b() && world.func_175623_d(pos.func_177984_a())) {
                        world.func_175656_a(pos.func_177984_a(), ModBlocks.dragon_ice_spikes.func_176223_P());
                    }
                }
                if (world.func_175625_s(pos) == null || !(world.func_175625_s(pos) instanceof TileEntityDragonforgeInput)) continue;
                ((TileEntityDragonforgeInput)world.func_175625_s(pos)).onHitWithFlame();
            }
            for (EntityLivingBase entityliving : world.func_72872_a(EntityLivingBase.class, new AxisAlignedBB((double)center.func_177958_n() - damageRadius, (double)center.func_177956_o() - damageRadius, (double)center.func_177952_p() - damageRadius, (double)center.func_177958_n() + damageRadius, (double)center.func_177956_o() + damageRadius, (double)center.func_177952_p() + damageRadius))) {
                if (DragonUtils.onSameTeam((Entity)destroyer, (Entity)entityliving) || destroyer.func_70028_i((Entity)entityliving) || !destroyer.func_70685_l((Entity)entityliving)) continue;
                entityliving.func_70097_a(IceAndFire.dragonIce, (float)stage * dmgScale);
                FrozenEntityProperties frozenProps = (FrozenEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)entityliving, FrozenEntityProperties.class);
                if (frozenProps == null) continue;
                frozenProps.setFrozenFor(50 * stage);
            }
        } else {
            int radius = stage == 4 ? 2 : 3;
            int j = radius + world.field_73012_v.nextInt(1);
            int k = radius + world.field_73012_v.nextInt(1);
            int l = radius + world.field_73012_v.nextInt(1);
            float f = (float)(j + k + l) * 0.333f + 0.5f;
            damageRadius = 2.5f + f * 1.2f;
            for (BlockPos blockpos : BlockPos.func_177980_a((BlockPos)center.func_177982_a(-j, -k, -l), (BlockPos)center.func_177982_a(j, k, l))) {
                if (blockpos.func_177951_i((Vec3i)center) <= (double)(f * f) && IceAndFire.CONFIG.dragonGriefing != 2 && world.field_73012_v.nextFloat() > (float)blockpos.func_177951_i((Vec3i)center) / (f * f)) {
                    IBlockState transformState = IaFDragonDestructionManager.transformBlockIce(world.func_180495_p(blockpos));
                    world.func_175656_a(blockpos, transformState);
                    if (world.field_73012_v.nextInt(9) == 0 && transformState.func_185913_b() && world.func_175623_d(blockpos.func_177984_a())) {
                        world.func_175656_a(blockpos.func_177984_a(), ModBlocks.dragon_ice_spikes.func_176223_P());
                    }
                }
                if (world.func_175625_s(blockpos) == null || !(world.func_175625_s(blockpos) instanceof TileEntityDragonforgeInput)) continue;
                ((TileEntityDragonforgeInput)world.func_175625_s(blockpos)).onHitWithFlame();
            }
            for (EntityLivingBase entityliving : world.func_72872_a(EntityLivingBase.class, new AxisAlignedBB((double)center.func_177958_n() - damageRadius, (double)center.func_177956_o() - damageRadius, (double)center.func_177952_p() - damageRadius, (double)center.func_177958_n() + damageRadius, (double)center.func_177956_o() + damageRadius, (double)center.func_177952_p() + damageRadius))) {
                if (DragonUtils.onSameTeam((Entity)destroyer, (Entity)entityliving) || destroyer.func_70028_i((Entity)entityliving) || !destroyer.func_70685_l((Entity)entityliving)) continue;
                entityliving.func_70097_a(IceAndFire.dragonIce, (float)stage * dmgScale);
                FrozenEntityProperties frozenProps = (FrozenEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)entityliving, FrozenEntityProperties.class);
                if (frozenProps == null) continue;
                frozenProps.setFrozenFor(50 * stage);
            }
        }
    }

    public static void destroyAreaFireCharge(World world, BlockPos center, EntityDragonBase destroyer) {
        block8: {
            if (destroyer == null) break block8;
            int stage = destroyer.getDragonStage();
            if (stage <= 3) {
                for (BlockPos pos : BlockPos.func_177980_a((BlockPos)center.func_177982_a(-2, -2, -2), (BlockPos)center.func_177982_a(2, 2, 2))) {
                    if (!((double)world.field_73012_v.nextFloat() > pos.func_177951_i((Vec3i)center)) || world.func_180495_p(pos).func_177230_c() instanceof IDragonProof) continue;
                    world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                }
                for (BlockPos pos : BlockPos.func_177980_a((BlockPos)center.func_177982_a(-2, -2, -2), (BlockPos)center.func_177982_a(2, 2, 2))) {
                    if (!world.field_73012_v.nextBoolean()) continue;
                    IBlockState transformState = IaFDragonDestructionManager.transformBlockFire(world.func_180495_p(pos));
                    world.func_175656_a(pos, transformState);
                    if (!world.field_73012_v.nextBoolean() || !transformState.func_185913_b() || !world.func_175623_d(pos.func_177984_a())) continue;
                    world.func_175656_a(pos.func_177984_a(), Blocks.field_150480_ab.func_176223_P());
                }
                for (EntityLiving entityliving : world.func_72872_a(EntityLiving.class, new AxisAlignedBB((double)center.func_177958_n() - 2.0, (double)center.func_177956_o() - 2.0, (double)center.func_177952_p() - 2.0, (double)center.func_177958_n() + 2.0, (double)center.func_177956_o() + 2.0, (double)center.func_177952_p() + 2.0))) {
                    if (destroyer.func_184191_r((Entity)entityliving) || destroyer.func_70028_i((Entity)entityliving) || !destroyer.func_70685_l((Entity)entityliving)) continue;
                    entityliving.func_70097_a(IceAndFire.dragonFire, (float)Math.max(1, stage - 1) * 2.0f);
                    entityliving.func_70015_d(15);
                }
            } else {
                int radius = stage == 4 ? 2 : 3;
                int j = radius + world.field_73012_v.nextInt(2);
                int k = radius + world.field_73012_v.nextInt(2);
                int l = radius + world.field_73012_v.nextInt(2);
                float f = (float)(j + k + l) * 0.333f + 0.5f;
                for (BlockPos blockpos : BlockPos.func_177980_a((BlockPos)center.func_177982_a(-j, -k, -l), (BlockPos)center.func_177982_a(j, k, l))) {
                    if (!(blockpos.func_177951_i((Vec3i)center) <= (double)(f * f)) || !(world.field_73012_v.nextFloat() > (float)blockpos.func_177951_i((Vec3i)center) / (f * f)) || world.func_180495_p(blockpos).func_177230_c() instanceof IDragonProof) continue;
                    world.func_175656_a(blockpos, Blocks.field_150350_a.func_176223_P());
                }
                for (BlockPos blockpos : BlockPos.func_177980_a((BlockPos)center.func_177982_a(-(++j), -(++k), -(++l)), (BlockPos)center.func_177982_a(j, k, l))) {
                    if (!(blockpos.func_177951_i((Vec3i)center) <= (double)(f * f))) continue;
                    IBlockState transformState = IaFDragonDestructionManager.transformBlockFire(world.func_180495_p(blockpos));
                    world.func_175656_a(blockpos, transformState);
                    if (!world.field_73012_v.nextBoolean() || !transformState.func_185913_b() || !world.func_175623_d(blockpos.func_177984_a())) continue;
                    world.func_175656_a(blockpos.func_177984_a(), Blocks.field_150480_ab.func_176223_P());
                }
                for (EntityLiving entityliving : world.func_72872_a(EntityLiving.class, new AxisAlignedBB((double)center.func_177958_n() - (double)j, (double)center.func_177956_o() - (double)k, (double)center.func_177952_p() - (double)l, (double)center.func_177958_n() + (double)j, (double)center.func_177956_o() + (double)k, (double)center.func_177952_p() + (double)l))) {
                    if (destroyer.func_184191_r((Entity)entityliving) || destroyer.func_70028_i((Entity)entityliving) || !destroyer.func_70685_l((Entity)entityliving)) continue;
                    entityliving.func_70097_a(IceAndFire.dragonFire, (float)Math.max(1, stage - 1) * 2.0f);
                    entityliving.func_70015_d(15);
                }
            }
        }
    }

    public static void destroyAreaIceCharge(World world, BlockPos center, EntityDragonBase destroyer) {
        block8: {
            if (destroyer == null) break block8;
            int stage = destroyer.getDragonStage();
            if (stage <= 3) {
                for (BlockPos pos : BlockPos.func_177980_a((BlockPos)center.func_177982_a(-2, -2, -2), (BlockPos)center.func_177982_a(2, 2, 2))) {
                    if (!((double)world.field_73012_v.nextFloat() > pos.func_177951_i((Vec3i)center)) || world.func_180495_p(pos).func_177230_c() instanceof IDragonProof) continue;
                    world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                }
                for (BlockPos pos : BlockPos.func_177980_a((BlockPos)center.func_177982_a(-2, -2, -2), (BlockPos)center.func_177982_a(2, 2, 2))) {
                    if (!world.field_73012_v.nextBoolean()) continue;
                    IBlockState transformState = IaFDragonDestructionManager.transformBlockIce(world.func_180495_p(pos));
                    world.func_175656_a(pos, transformState);
                    if (!world.field_73012_v.nextBoolean() || !transformState.func_185913_b() || !world.func_175623_d(pos.func_177984_a())) continue;
                    world.func_175656_a(pos.func_177984_a(), ModBlocks.dragon_ice_spikes.func_176223_P());
                }
                for (EntityLiving entityliving : world.func_72872_a(EntityLiving.class, new AxisAlignedBB((double)center.func_177958_n() - 2.0, (double)center.func_177956_o() - 2.0, (double)center.func_177952_p() - 2.0, (double)center.func_177958_n() + 2.0, (double)center.func_177956_o() + 2.0, (double)center.func_177952_p() + 2.0))) {
                    if (destroyer.func_184191_r((Entity)entityliving) || destroyer.func_70028_i((Entity)entityliving) || !destroyer.func_70685_l((Entity)entityliving)) continue;
                    entityliving.func_70097_a(IceAndFire.dragonIce, (float)Math.max(1, stage - 1) * 2.0f);
                    FrozenEntityProperties frozenProps = (FrozenEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)entityliving, FrozenEntityProperties.class);
                    if (frozenProps == null) continue;
                    frozenProps.setFrozenFor(400);
                }
            } else {
                int radius = stage == 4 ? 2 : 3;
                int j = radius + world.field_73012_v.nextInt(2);
                int k = radius + world.field_73012_v.nextInt(2);
                int l = radius + world.field_73012_v.nextInt(2);
                float f = (float)(j + k + l) * 0.333f + 0.5f;
                for (BlockPos blockpos : BlockPos.func_177980_a((BlockPos)center.func_177982_a(-j, -k, -l), (BlockPos)center.func_177982_a(j, k, l))) {
                    if (!(blockpos.func_177951_i((Vec3i)center) <= (double)(f * f)) || !(world.field_73012_v.nextFloat() > (float)blockpos.func_177951_i((Vec3i)center) / (f * f)) || world.func_180495_p(blockpos).func_177230_c() instanceof IDragonProof) continue;
                    world.func_175656_a(blockpos, Blocks.field_150350_a.func_176223_P());
                }
                for (BlockPos blockpos : BlockPos.func_177980_a((BlockPos)center.func_177982_a(-(++j), -(++k), -(++l)), (BlockPos)center.func_177982_a(j, k, l))) {
                    if (!(blockpos.func_177951_i((Vec3i)center) <= (double)(f * f))) continue;
                    IBlockState transformState = IaFDragonDestructionManager.transformBlockIce(world.func_180495_p(blockpos));
                    world.func_175656_a(blockpos, transformState);
                    if (!world.field_73012_v.nextBoolean() || !transformState.func_185913_b() || !world.func_175623_d(blockpos.func_177984_a())) continue;
                    world.func_175656_a(blockpos.func_177984_a(), ModBlocks.dragon_ice_spikes.func_176223_P());
                }
                for (EntityLiving entityliving : world.func_72872_a(EntityLiving.class, new AxisAlignedBB((double)center.func_177958_n() - (double)j, (double)center.func_177956_o() - (double)k, (double)center.func_177952_p() - (double)l, (double)center.func_177958_n() + (double)j, (double)center.func_177956_o() + (double)k, (double)center.func_177952_p() + (double)l))) {
                    if (destroyer.func_184191_r((Entity)entityliving) || destroyer.func_70028_i((Entity)entityliving) || !destroyer.func_70685_l((Entity)entityliving)) continue;
                    entityliving.func_70097_a(IceAndFire.dragonIce, (float)Math.max(1, stage - 1) * 2.0f);
                    FrozenEntityProperties frozenProps = (FrozenEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)entityliving, FrozenEntityProperties.class);
                    if (frozenProps == null) continue;
                    frozenProps.setFrozenFor(400);
                }
            }
        }
    }

    public static IBlockState transformBlockFire(IBlockState in) {
        if (in.func_177230_c() instanceof IDragonProof || !DragonUtils.canDragonBreak(in.func_177230_c())) {
            return in;
        }
        if (in.func_185904_a() == Material.field_151577_b || in.func_185904_a() == Material.field_151596_z) {
            return ModBlocks.charedGrass.func_176223_P().func_177226_a((IProperty)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.func_185904_a() == Material.field_151578_c && in.func_177230_c() == Blocks.field_150346_d) {
            return ModBlocks.charedDirt.func_176223_P().func_177226_a((IProperty)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.func_185904_a() == Material.field_151578_c && in.func_177230_c() == Blocks.field_150351_n) {
            return ModBlocks.charedGravel.func_176223_P().func_177226_a((IProperty)BlockFallingReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.func_185904_a() == Material.field_151576_e && (in.func_177230_c() == Blocks.field_150347_e || in.func_177230_c().func_149739_a().contains("cobblestone"))) {
            return ModBlocks.charedCobblestone.func_176223_P().func_177226_a((IProperty)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.func_185904_a() == Material.field_151576_e && in.func_177230_c() != ModBlocks.charedCobblestone) {
            return ModBlocks.charedStone.func_176223_P().func_177226_a((IProperty)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.func_177230_c() == Blocks.field_185774_da) {
            return ModBlocks.charedGrassPath.func_176223_P().func_177226_a((IProperty)BlockCharedPath.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.func_185904_a() == Material.field_151575_d) {
            return ModBlocks.ash.func_176223_P();
        }
        if (in.func_185904_a() == Material.field_151584_j || in.func_185904_a() == Material.field_151585_k || in.func_177230_c() == Blocks.field_150431_aC) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return in;
    }

    public static IBlockState transformBlockIce(IBlockState in) {
        if (in.func_177230_c() instanceof IDragonProof || !DragonUtils.canDragonBreak(in.func_177230_c())) {
            return in;
        }
        if (in.func_185904_a() == Material.field_151577_b || in.func_185904_a() == Material.field_151596_z) {
            return ModBlocks.frozenGrass.func_176223_P().func_177226_a((IProperty)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.func_185904_a() == Material.field_151578_c && in.func_177230_c() == Blocks.field_150346_d || in.func_185904_a() == Material.field_151596_z) {
            return ModBlocks.frozenDirt.func_176223_P().func_177226_a((IProperty)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.func_185904_a() == Material.field_151578_c && in.func_177230_c() == Blocks.field_150351_n) {
            return ModBlocks.frozenGravel.func_176223_P().func_177226_a((IProperty)BlockFallingReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.func_185904_a() == Material.field_151576_e && (in.func_177230_c() == Blocks.field_150347_e || in.func_177230_c().func_149739_a().contains("cobblestone"))) {
            return ModBlocks.frozenCobblestone.func_176223_P().func_177226_a((IProperty)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.func_185904_a() == Material.field_151576_e && in.func_177230_c() != ModBlocks.frozenCobblestone) {
            return ModBlocks.frozenStone.func_176223_P().func_177226_a((IProperty)BlockReturningState.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.func_177230_c() == Blocks.field_185774_da) {
            return ModBlocks.frozenGrassPath.func_176223_P().func_177226_a((IProperty)BlockCharedPath.REVERTS, (Comparable)Boolean.valueOf(true));
        }
        if (in.func_185904_a() == Material.field_151575_d) {
            return ModBlocks.frozenSplinters.func_176223_P();
        }
        if (in.func_185904_a() == Material.field_151586_h) {
            return Blocks.field_150432_aD.func_176223_P();
        }
        if (in.func_185904_a() == Material.field_151584_j || in.func_185904_a() == Material.field_151585_k || in.func_177230_c() == Blocks.field_150431_aC) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return in;
    }
}

