/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.core.ModBlocks;
import com.github.alexthe666.iceandfire.core.ModSounds;
import com.github.alexthe666.iceandfire.entity.StoneEntityProperties;
import com.github.alexthe666.iceandfire.entity.ai.PixieAIFlee;
import com.github.alexthe666.iceandfire.entity.ai.PixieAIFollowOwner;
import com.github.alexthe666.iceandfire.entity.ai.PixieAIPickupItem;
import com.github.alexthe666.iceandfire.entity.ai.PixieAISteal;
import com.github.alexthe666.iceandfire.entity.tile.TileEntityPixieHouse;
import com.github.alexthe666.iceandfire.message.MessageUpdatePixieHouse;
import com.google.common.base.Predicate;
import java.util.Random;
import javax.annotation.Nullable;
import net.ilexiconn.llibrary.server.entity.EntityPropertiesHandler;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityPixie
extends EntityTameable {
    public static final float[][] PARTICLE_RGB = new float[][]{{1.0f, 0.752f, 0.792f}, {0.831f, 0.662f, 1.0f}, {0.513f, 0.843f, 1.0f}, {0.654f, 0.909f, 0.615f}, {0.996f, 0.788f, 0.407f}};
    public static final ResourceLocation LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("iceandfire", "if_pixie"));
    private static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(EntityPixie.class, (DataSerializer)DataSerializers.field_187192_b);
    public Potion[] positivePotions = new Potion[]{MobEffects.field_76420_g, MobEffects.field_76430_j, MobEffects.field_76424_c, MobEffects.field_188425_z, MobEffects.field_76422_e};
    public Potion[] negativePotions = new Potion[]{MobEffects.field_76437_t, MobEffects.field_76431_k, MobEffects.field_76421_d, MobEffects.field_189112_A, MobEffects.field_76419_f};
    public boolean slowSpeed = false;
    public int ticksUntilHouseAI;
    private BlockPos housePos;
    private PixieAIFlee aiFlee;
    private PixieAISteal aiTempt;

    public EntityPixie(World worldIn) {
        super(worldIn);
        this.field_70765_h = new AIMoveControl(this);
        this.func_70105_a(0.4f, 0.8f);
        this.field_70728_aV = 3;
        this.func_184642_a(EntityEquipmentSlot.MAINHAND, 0.0f);
    }

    public static BlockPos getPositionRelativetoGround(Entity entity, World world, double x, double z, Random rand) {
        BlockPos pos = new BlockPos(x, entity.field_70163_u, z);
        for (int yDown = 0; yDown < 3; ++yDown) {
            if (world.func_175623_d(pos.func_177979_c(yDown))) continue;
            return pos.func_177981_b(yDown);
        }
        return pos;
    }

    public static BlockPos findAHouse(Entity entity, World world) {
        for (int xSearch = -10; xSearch < 10; ++xSearch) {
            for (int ySearch = -10; ySearch < 10; ++ySearch) {
                for (int zSearch = -10; zSearch < 10; ++zSearch) {
                    if (world.func_175625_s(entity.func_180425_c().func_177982_a(xSearch, ySearch, zSearch)) == null || !(world.func_175625_s(entity.func_180425_c().func_177982_a(xSearch, ySearch, zSearch)) instanceof TileEntityPixieHouse)) continue;
                    TileEntityPixieHouse house = (TileEntityPixieHouse)world.func_175625_s(entity.func_180425_c().func_177982_a(xSearch, ySearch, zSearch));
                    if (house.hasPixie) continue;
                    return entity.func_180425_c().func_177982_a(xSearch, ySearch, zSearch);
                }
            }
        }
        return entity.func_180425_c();
    }

    protected int func_70693_a(EntityPlayer player) {
        return 3;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        StoneEntityProperties properties = (StoneEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)this, StoneEntityProperties.class);
        if (!this.field_70170_p.field_72995_K && this.func_70681_au().nextInt(3) == 0 && this.func_184586_b(EnumHand.MAIN_HAND) != ItemStack.field_190927_a && !properties.isStone) {
            this.func_70099_a(this.func_184586_b(EnumHand.MAIN_HAND), 0.0f);
            this.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
            return true;
        }
        if (this.isOwnerClose() && (source == DamageSource.field_82729_p || source == DamageSource.field_76368_d || this.func_70902_q() != null && source.func_76346_g() == this.func_70902_q())) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public void func_70645_a(DamageSource cause) {
        if (!this.field_70170_p.field_72995_K && !this.func_184586_b(EnumHand.MAIN_HAND).func_190926_b()) {
            this.func_70099_a(this.func_184586_b(EnumHand.MAIN_HAND), 0.0f);
            this.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
        }
        super.func_70645_a(cause);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(COLOR, (Object)0);
    }

    protected void func_82167_n(Entity entityIn) {
        if (this.func_70902_q() != entityIn) {
            entityIn.func_70108_f((Entity)this);
        }
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
        if (!this.func_70090_H()) {
            this.func_70072_I();
        }
        if (onGroundIn) {
            if (this.field_70143_R > 0.0f) {
                state.func_177230_c().func_180658_a(this.field_70170_p, pos, (Entity)this, this.field_70143_R);
            }
            this.field_70143_R = 0.0f;
        } else if (y < 0.0) {
            this.field_70143_R = (float)((double)this.field_70143_R - y);
        }
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (player.func_184586_b(hand).func_111282_a(player, (EntityLivingBase)this, hand)) {
            return true;
        }
        if (this.func_152114_e((EntityLivingBase)player)) {
            if (player.func_184586_b(hand).func_77973_b() == Items.field_151102_aT && this.func_110143_aJ() < this.func_110138_aP()) {
                this.func_70691_i(5.0f);
                player.func_184586_b(hand).func_190918_g(1);
                this.func_184185_a(ModSounds.PIXIE_TAUNT, 1.0f, 1.0f);
                return true;
            }
            this.func_70904_g(!this.func_70906_o());
            return true;
        }
        if (player.func_184586_b(hand).func_77973_b() == Item.func_150898_a((Block)ModBlocks.jar_empty) && player.func_184586_b(hand).func_77960_j() == 0 && !this.func_70909_n()) {
            if (!player.func_184812_l_()) {
                player.func_184586_b(hand).func_190918_g(1);
            }
            ItemStack stack = new ItemStack(ModBlocks.jar_pixie, 1, this.getColor());
            if (!this.field_70170_p.field_72995_K) {
                if (!this.func_184586_b(EnumHand.MAIN_HAND).func_190926_b()) {
                    this.func_70099_a(this.func_184586_b(EnumHand.MAIN_HAND), 0.0f);
                }
                this.func_70099_a(stack, 0.0f);
            }
            this.func_70106_y();
        }
        return super.func_184645_a(player, hand);
    }

    public void flipAI(boolean flee) {
        if (flee) {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiTempt);
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiFlee);
        } else {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.aiFlee);
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiTempt);
        }
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new PixieAIFollowOwner(this, 1.0, 2.0f, 4.0f));
        this.field_70714_bg.func_75776_a(1, new PixieAIPickupItem(this, false));
        this.aiTempt = new PixieAISteal(this, 1.0);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.aiTempt);
        this.aiFlee = new PixieAIFlee<EntityPlayer>(this, EntityPlayer.class, 10.0f, new Predicate<EntityPlayer>(){

            public boolean apply(@Nullable EntityPlayer entity) {
                return true;
            }
        });
        this.field_70714_bg.func_75776_a(2, this.aiFlee);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AIMoveRandom());
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIEnterHouse());
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiFlee);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.setColor(this.field_70146_Z.nextInt(5));
        this.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
        return livingdata;
    }

    private boolean isBeyondHeight() {
        if (this.field_70163_u > (double)this.field_70170_p.func_72800_K()) {
            return true;
        }
        BlockPos height = this.field_70170_p.func_175645_m(new BlockPos((Entity)this));
        int maxY = 20 + height.func_177956_o();
        return this.field_70163_u > (double)maxY;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_70906_o() && !this.isBeyondHeight()) {
            this.field_70181_x += 0.08;
        } else {
            this.field_70765_h.field_188491_h = EntityMoveHelper.Action.WAIT;
        }
        if (this.field_70170_p.field_72995_K) {
            IceAndFire.PROXY.spawnParticle("if_pixie", this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, PARTICLE_RGB[this.getColor()][0], PARTICLE_RGB[this.getColor()][1], PARTICLE_RGB[this.getColor()][2]);
        }
        if (this.ticksUntilHouseAI > 0) {
            --this.ticksUntilHouseAI;
        }
        if (this.housePos != null && this.func_174831_c(this.housePos) < 1.5 && this.field_70170_p.func_175625_s(this.housePos) != null && this.field_70170_p.func_175625_s(this.housePos) instanceof TileEntityPixieHouse) {
            if (((TileEntityPixieHouse)this.field_70170_p.func_175625_s((BlockPos)this.housePos)).hasPixie) {
                this.housePos = null;
                this.field_70765_h.field_188491_h = EntityMoveHelper.Action.WAIT;
            } else {
                ((TileEntityPixieHouse)this.field_70170_p.func_175625_s((BlockPos)this.housePos)).hasPixie = true;
                ((TileEntityPixieHouse)this.field_70170_p.func_175625_s((BlockPos)this.housePos)).pixieType = this.getColor();
                ((TileEntityPixieHouse)this.field_70170_p.func_175625_s((BlockPos)this.housePos)).pixieItems.set(0, (Object)this.func_184586_b(EnumHand.MAIN_HAND));
                ((TileEntityPixieHouse)this.field_70170_p.func_175625_s((BlockPos)this.housePos)).tamedPixie = this.func_70909_n();
                ((TileEntityPixieHouse)this.field_70170_p.func_175625_s((BlockPos)this.housePos)).pixieOwnerUUID = this.func_184753_b();
                IceAndFire.NETWORK_WRAPPER.sendToAll((IMessage)new MessageUpdatePixieHouse(this.housePos.func_177986_g(), true, this.getColor()));
                this.func_70106_y();
            }
        }
        if (this.func_70902_q() != null && this.isOwnerClose() && this.field_70173_aa % 80 == 0) {
            this.func_70902_q().func_70690_d(new PotionEffect(this.positivePotions[this.getColor()], 100, 0, false, false));
        }
    }

    public int getColor() {
        return (Integer)this.func_184212_Q().func_187225_a(COLOR);
    }

    public void setColor(int color) {
        this.func_184212_Q().func_187227_b(COLOR, (Object)color);
    }

    public void func_70037_a(NBTTagCompound compound) {
        this.setColor(compound.func_74762_e("Color"));
        super.func_70037_a(compound);
    }

    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("Color", this.getColor());
        super.func_70014_b(compound);
    }

    @Nullable
    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return null;
    }

    public BlockPos getHousePos() {
        return this.housePos;
    }

    public boolean isOwnerClose() {
        return this.func_70909_n() && this.func_70902_q() != null && this.func_70068_e((Entity)this.func_70902_q()) < 100.0;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return ModSounds.PIXIE_IDLE;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return ModSounds.PIXIE_HURT;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return ModSounds.PIXIE_DIE;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LOOT;
    }

    class AIEnterHouse
    extends EntityAIBase {
        public AIEnterHouse() {
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            if (EntityPixie.this.isOwnerClose() || EntityPixie.this.func_70605_aq().func_75640_a() || EntityPixie.this.func_70906_o() || EntityPixie.this.field_70146_Z.nextInt(20) != 0 || EntityPixie.this.ticksUntilHouseAI != 0) {
                return false;
            }
            BlockPos blockpos1 = EntityPixie.findAHouse((Entity)EntityPixie.this, EntityPixie.this.field_70170_p);
            return !blockpos1.toString().equals(EntityPixie.this.func_180425_c().toString());
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75246_d() {
            BlockPos blockpos;
            BlockPos blockPos = blockpos = EntityPixie.this.getHousePos() == null ? EntityPixie.this.func_180425_c() : EntityPixie.this.getHousePos();
            if (blockpos == null) {
                blockpos = new BlockPos((Entity)EntityPixie.this);
            }
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos1 = EntityPixie.findAHouse((Entity)EntityPixie.this, EntityPixie.this.field_70170_p);
                EntityPixie.this.field_70765_h.func_75642_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 0.25);
                EntityPixie.this.housePos = blockpos1;
                if (EntityPixie.this.func_70638_az() != null) continue;
                EntityPixie.this.func_70671_ap().func_75650_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 180.0f, 20.0f);
            }
        }
    }

    class AIMoveRandom
    extends EntityAIBase {
        BlockPos target;

        public AIMoveRandom() {
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            this.target = EntityPixie.getPositionRelativetoGround((Entity)EntityPixie.this, EntityPixie.this.field_70170_p, EntityPixie.this.field_70165_t + (double)EntityPixie.this.field_70146_Z.nextInt(15) - 7.0, EntityPixie.this.field_70161_v + (double)EntityPixie.this.field_70146_Z.nextInt(15) - 7.0, EntityPixie.this.field_70146_Z);
            return !EntityPixie.this.isOwnerClose() && !EntityPixie.this.func_70906_o() && this.isDirectPathBetweenPoints(EntityPixie.this.func_180425_c(), this.target) && !EntityPixie.this.func_70605_aq().func_75640_a() && EntityPixie.this.field_70146_Z.nextInt(4) == 0 && EntityPixie.this.housePos == null;
        }

        protected boolean isDirectPathBetweenPoints(BlockPos posVec31, BlockPos posVec32) {
            RayTraceResult raytraceresult = EntityPixie.this.field_70170_p.func_147447_a(new Vec3d((double)posVec31.func_177958_n() + 0.5, (double)posVec31.func_177956_o() + 0.5, (double)posVec31.func_177952_p() + 0.5), new Vec3d((double)posVec32.func_177958_n() + 0.5, (double)posVec32.func_177956_o() + (double)EntityPixie.this.field_70131_O * 0.5, (double)posVec32.func_177952_p() + 0.5), false, true, false);
            return raytraceresult == null || raytraceresult.field_72313_a == RayTraceResult.Type.MISS;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75246_d() {
            if (!this.isDirectPathBetweenPoints(EntityPixie.this.func_180425_c(), this.target)) {
                this.target = EntityPixie.getPositionRelativetoGround((Entity)EntityPixie.this, EntityPixie.this.field_70170_p, EntityPixie.this.field_70165_t + (double)EntityPixie.this.field_70146_Z.nextInt(15) - 7.0, EntityPixie.this.field_70161_v + (double)EntityPixie.this.field_70146_Z.nextInt(15) - 7.0, EntityPixie.this.field_70146_Z);
            }
            if (EntityPixie.this.field_70170_p.func_175623_d(this.target)) {
                EntityPixie.this.field_70765_h.func_75642_a((double)this.target.func_177958_n() + 0.5, (double)this.target.func_177956_o() + 0.5, (double)this.target.func_177952_p() + 0.5, 0.25);
                if (EntityPixie.this.func_70638_az() == null) {
                    EntityPixie.this.func_70671_ap().func_75650_a((double)this.target.func_177958_n() + 0.5, (double)this.target.func_177956_o() + 0.5, (double)this.target.func_177952_p() + 0.5, 180.0f, 20.0f);
                }
            }
        }
    }

    class AIMoveControl
    extends EntityMoveHelper {
        public AIMoveControl(EntityPixie pixie) {
            super((EntityLiving)pixie);
            this.field_75645_e = 0.75;
        }

        public void func_75641_c() {
            if (EntityPixie.this.slowSpeed) {
                this.field_75645_e = 2.0;
            }
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                if (EntityPixie.this.field_70123_F) {
                    EntityPixie.this.field_70177_z += 180.0f;
                    this.field_75645_e = 0.1f;
                    BlockPos target = EntityPixie.getPositionRelativetoGround((Entity)EntityPixie.this, EntityPixie.this.field_70170_p, EntityPixie.this.field_70165_t + (double)EntityPixie.this.field_70146_Z.nextInt(15) - 7.0, EntityPixie.this.field_70161_v + (double)EntityPixie.this.field_70146_Z.nextInt(15) - 7.0, EntityPixie.this.field_70146_Z);
                    this.field_75646_b = target.func_177958_n();
                    this.field_75647_c = target.func_177956_o();
                    this.field_75644_d = target.func_177952_p();
                }
                double d0 = this.field_75646_b - EntityPixie.this.field_70165_t;
                double d1 = this.field_75647_c - EntityPixie.this.field_70163_u;
                double d2 = this.field_75644_d - EntityPixie.this.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if ((d3 = (double)MathHelper.func_76133_a((double)d3)) < EntityPixie.this.func_174813_aQ().func_72320_b()) {
                    this.field_188491_h = EntityMoveHelper.Action.WAIT;
                    EntityPixie.this.field_70159_w *= 0.5;
                    EntityPixie.this.field_70181_x *= 0.5;
                    EntityPixie.this.field_70179_y *= 0.5;
                } else {
                    EntityPixie.this.field_70159_w += d0 / d3 * 0.05 * this.field_75645_e;
                    EntityPixie.this.field_70181_x += d1 / d3 * 0.05 * this.field_75645_e;
                    EntityPixie.this.field_70179_y += d2 / d3 * 0.05 * this.field_75645_e;
                    if (EntityPixie.this.func_70638_az() == null) {
                        EntityPixie.this.field_70761_aq = EntityPixie.this.field_70177_z = -((float)MathHelper.func_181159_b((double)EntityPixie.this.field_70159_w, (double)EntityPixie.this.field_70179_y)) * 57.295776f;
                    } else {
                        double d4 = EntityPixie.this.func_70638_az().field_70165_t - EntityPixie.this.field_70165_t;
                        double d5 = EntityPixie.this.func_70638_az().field_70161_v - EntityPixie.this.field_70161_v;
                        EntityPixie.this.field_70761_aq = EntityPixie.this.field_70177_z = -((float)MathHelper.func_181159_b((double)d4, (double)d5)) * 57.295776f;
                    }
                }
            }
        }
    }
}

