/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.core.ModItems;
import com.github.alexthe666.iceandfire.core.ModSounds;
import com.github.alexthe666.iceandfire.entity.DragonType;
import com.github.alexthe666.iceandfire.entity.DragonUtils;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntityDragonIceCharge;
import com.github.alexthe666.iceandfire.entity.IaFDragonAttacks;
import com.github.alexthe666.iceandfire.entity.IaFDragonDestructionManager;
import com.github.alexthe666.iceandfire.entity.ai.AquaticAITempt;
import com.github.alexthe666.iceandfire.entity.ai.DragonAIEscort;
import com.github.alexthe666.iceandfire.entity.ai.DragonAILookIdle;
import com.github.alexthe666.iceandfire.entity.ai.DragonAIMate;
import com.github.alexthe666.iceandfire.entity.ai.DragonAIRide;
import com.github.alexthe666.iceandfire.entity.ai.DragonAITarget;
import com.github.alexthe666.iceandfire.entity.ai.DragonAITargetItems;
import com.github.alexthe666.iceandfire.entity.ai.DragonAIWander;
import com.github.alexthe666.iceandfire.entity.ai.DragonAIWatchClosest;
import com.github.alexthe666.iceandfire.message.MessageDragonSyncFire;
import com.google.common.base.Predicate;
import java.util.Random;
import javax.annotation.Nullable;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.ilexiconn.llibrary.server.animation.IAnimatedEntity;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityIceDragon
extends EntityDragonBase {
    public static final float[] growth_stage_1 = new float[]{1.0f, 3.0f};
    public static final float[] growth_stage_2 = new float[]{3.0f, 7.0f};
    public static final float[] growth_stage_3 = new float[]{7.0f, 12.5f};
    public static final float[] growth_stage_4 = new float[]{12.5f, 20.0f};
    public static final float[] growth_stage_5 = new float[]{20.0f, 30.0f};
    public static final ResourceLocation FEMALE_LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("iceandfire", "dragon/ice_dragon_female"));
    public static final ResourceLocation MALE_LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("iceandfire", "dragon/ice_dragon_male"));
    public static final ResourceLocation SKELETON_LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("iceandfire", "dragon/ice_dragon_skeleton"));
    private static final DataParameter<Boolean> SWIMMING = EntityDataManager.func_187226_a(EntityIceDragon.class, (DataSerializer)DataSerializers.field_187198_h);
    public static Animation ANIMATION_FIRECHARGE;
    public boolean isSwimming;
    public float swimProgress;
    public int ticksSwiming;
    public int swimCycle;

    public EntityIceDragon(World worldIn) {
        super(worldIn, DragonType.ICE, 1.0, 1 + IceAndFire.CONFIG.dragonAttackDamage, (double)IceAndFire.CONFIG.dragonHealth * 0.04, IceAndFire.CONFIG.dragonHealth, 0.15f, 0.4f);
        this.func_70105_a(0.78f, 1.2f);
        ANIMATION_SPEAK = Animation.create((int)20);
        ANIMATION_BITE = Animation.create((int)35);
        ANIMATION_SHAKEPREY = Animation.create((int)65);
        ANIMATION_TAILWHACK = Animation.create((int)40);
        ANIMATION_FIRECHARGE = Animation.create((int)25);
        ANIMATION_WINGBLAST = Animation.create((int)50);
        ANIMATION_ROAR = Animation.create((int)40);
        ANIMATION_EPIC_ROAR = Animation.create((int)60);
        this.growth_stages = new float[][]{growth_stage_1, growth_stage_2, growth_stage_3, growth_stage_4, growth_stage_5};
        this.field_70138_W = 1.0f;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, new DragonAIRide<EntityIceDragon>(this));
        this.field_70911_d = new EntityAISit((EntityTameable)this);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new DragonAIMate(this, 1.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new DragonAIEscort(this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.5, false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AquaticAITempt((EntityCreature)this, 1.0, ModItems.frost_stew, false));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new DragonAIWander(this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new DragonAIWatchClosest((EntityLiving)this, EntityLivingBase.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new DragonAILookIdle(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(4, new DragonAITarget<Entity>(this, EntityLivingBase.class, true, new Predicate<Entity>(){

            public boolean apply(@Nullable Entity entity) {
                return entity instanceof EntityLivingBase && DragonUtils.isAlive((EntityLivingBase)entity);
            }
        }));
        this.field_70715_bh.func_75776_a(5, new DragonAITargetItems((EntityCreature)this, false));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SWIMMING, (Object)false);
    }

    @Override
    public String getVariantName(int variant) {
        switch (variant) {
            default: {
                return "blue_";
            }
            case 1: {
                return "white_";
            }
            case 2: {
                return "sapphire_";
            }
            case 3: 
        }
        return "silver_";
    }

    public boolean func_70648_aU() {
        return true;
    }

    @Override
    public Item getVariantScale(int variant) {
        switch (variant) {
            default: {
                return ModItems.dragonscales_blue;
            }
            case 1: {
                return ModItems.dragonscales_white;
            }
            case 2: {
                return ModItems.dragonscales_sapphire;
            }
            case 3: 
        }
        return ModItems.dragonscales_silver;
    }

    @Override
    public Item getVariantEgg(int variant) {
        switch (variant) {
            default: {
                return ModItems.dragonegg_blue;
            }
            case 1: {
                return ModItems.dragonegg_white;
            }
            case 2: {
                return ModItems.dragonegg_sapphire;
            }
            case 3: 
        }
        return ModItems.dragonegg_silver;
    }

    public boolean func_96092_aw() {
        return false;
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("Swimming", this.isSwimming());
        compound.func_74768_a("SwimmingTicks", this.ticksSwiming);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setSwimming(compound.func_74767_n("Swimming"));
        this.ticksSwiming = compound.func_74762_e("SwimmingTicks");
    }

    @Override
    public boolean func_82171_bF() {
        return true;
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        this.func_70671_ap().func_75651_a(entityIn, 30.0f, 30.0f);
        if (!this.isPlayingAttackAnimation()) {
            switch (this.groundAttack) {
                case BITE: {
                    this.setAnimation(ANIMATION_BITE);
                    break;
                }
                case TAIL_WHIP: {
                    this.setAnimation(ANIMATION_TAILWHACK);
                    break;
                }
                case SHAKE_PREY: {
                    boolean flag = false;
                    if (new Random().nextInt(2) == 0 && this.isDirectPathBetweenPoints((Entity)this, this.func_174791_d().func_72441_c(0.0, (double)(this.field_70131_O / 2.0f), 0.0), entityIn.func_174791_d().func_72441_c(0.0, (double)(entityIn.field_70131_O / 2.0f), 0.0)) && entityIn.field_70130_N < this.field_70130_N * 0.5f && this.func_184179_bs() == null && this.getDragonStage() > 1 && !(entityIn instanceof EntityDragonBase) && !DragonUtils.isAnimaniaMob(entityIn)) {
                        this.setAnimation(ANIMATION_SHAKEPREY);
                        flag = true;
                        entityIn.func_184220_m((Entity)this);
                    }
                    if (flag) break;
                    this.groundAttack = IaFDragonAttacks.Ground.BITE;
                    this.setAnimation(ANIMATION_BITE);
                    break;
                }
                case WING_BLAST: {
                    this.setAnimation(ANIMATION_WINGBLAST);
                }
            }
        }
        return false;
    }

    @Override
    public void func_70636_d() {
        boolean swimming;
        super.func_70636_d();
        if (!this.isFlying() && !this.isHovering() && this.isSwimming() && !this.field_70170_p.field_72995_K) {
            this.flightManager.update();
        }
        if (!this.field_70170_p.field_72995_K && this.func_180799_ab() && this.isAllowedToTriggerFlight()) {
            this.setHovering(true);
            this.setSleeping(false);
            this.func_70904_g(false);
            this.flyHovering = 0;
            this.flyTicks = 0;
        }
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null) {
            float growSize;
            float f = growSize = this.isInMaterialWater() ? 1.0f : 0.5f;
            if (this.func_174813_aQ().func_72314_b((double)(2.5f + this.getRenderSize() * 0.33f), (double)(2.5f + this.getRenderSize() * 0.33f), (double)(2.5f + this.getRenderSize() * 0.33f)).func_72326_a(this.func_70638_az().func_174813_aQ())) {
                this.func_70652_k((Entity)this.func_70638_az());
            }
            if (this.groundAttack == IaFDragonAttacks.Ground.FIRE && (this.usingGroundAttack || this.field_70122_E)) {
                this.shootIceAtMob(this.func_70638_az());
            }
            if (this.airAttack == IaFDragonAttacks.Air.TACKLE && !this.usingGroundAttack && this.func_70068_e((Entity)this.func_70638_az()) < 100.0) {
                double difX = this.func_70638_az().field_70165_t - this.field_70165_t;
                double difY = this.func_70638_az().field_70163_u + (double)this.func_70638_az().field_70131_O - this.field_70163_u;
                double difZ = this.func_70638_az().field_70161_v - this.field_70161_v;
                this.field_70159_w += difX * 0.1;
                this.field_70181_x += difY * 0.1;
                this.field_70179_y += difZ * 0.1;
                if (this.func_174813_aQ().func_72314_b((double)(1.0f + this.getRenderSize() * 0.5f), (double)(1.0f + this.getRenderSize() * 0.5f), (double)(1.0f + this.getRenderSize() * 0.5f)).func_72326_a(this.func_70638_az().func_174813_aQ())) {
                    this.func_70652_k((Entity)this.func_70638_az());
                    this.usingGroundAttack = true;
                    this.randomizeAttacks();
                    this.setFlying(false);
                    this.setHovering(false);
                }
            }
        }
        boolean bl = swimming = this.isSwimming() && !this.isHovering() && !this.isFlying() && this.ridingProgress == 0.0f;
        if (swimming && this.swimProgress < 20.0f) {
            this.swimProgress += 0.5f;
        } else if (!swimming && this.swimProgress > 0.0f) {
            this.swimProgress -= 0.5f;
        }
        if (this.isInMaterialWater() && !this.isSwimming() && (!this.isFlying() && !this.isHovering() || this.flyTicks > 100)) {
            this.setSwimming(true);
            this.setHovering(false);
            this.setFlying(false);
            this.flyTicks = 0;
            this.ticksSwiming = 0;
        }
        if ((!this.isInMaterialWater() || this.isHovering() || this.isFlying()) && this.isSwimming()) {
            this.setSwimming(false);
            this.ticksSwiming = 0;
        }
        if (this.isSwimming()) {
            ++this.ticksSwiming;
            if (!(!this.isInMaterialWater() && !this.func_191953_am() || this.ticksSwiming <= 4000 && (this.func_70638_az() == null || this.func_70090_H() == this.func_70638_az().func_70090_H()) || this.func_70631_g_() || this.isHovering() || this.isFlying())) {
                this.setHovering(true);
                this.func_70664_aZ();
                this.field_70181_x += 0.8;
                this.setSwimming(false);
            }
        }
        if (!this.field_70170_p.field_72995_K && this.isHovering() && !this.isFlying() && (this.isInMaterialWater() || this.func_191953_am())) {
            this.field_70181_x += 0.2;
        }
        this.swimCycle = this.swimCycle < 48 ? (this.swimCycle += 2) : 0;
        if (this.isModelDead() && this.swimCycle != 0) {
            this.swimCycle = 0;
        }
    }

    public boolean isInsideWaterBlock() {
        return this.func_70055_a(Material.field_151586_h);
    }

    @Override
    public void riderShootFire(Entity controller) {
        if (this.func_70681_au().nextInt(5) == 0 && !this.func_70631_g_()) {
            if (this.getAnimation() != ANIMATION_FIRECHARGE) {
                this.setAnimation(ANIMATION_FIRECHARGE);
            } else if (this.getAnimationTick() == 15) {
                this.field_70177_z = this.field_70761_aq;
                Vec3d headVec = this.getHeadPosition();
                this.func_184185_a(ModSounds.ICEDRAGON_BREATH, 4.0f, 1.0f);
                double d2 = controller.func_70040_Z().field_72450_a;
                double d3 = controller.func_70040_Z().field_72448_b;
                double d4 = controller.func_70040_Z().field_72449_c;
                float inaccuracy = 1.0f;
                EntityDragonIceCharge entitylargefireball = new EntityDragonIceCharge(this.field_70170_p, this, d2 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, d3 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, d4 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy);
                float size = this.func_70631_g_() ? 0.4f : (this.isAdult() ? 1.3f : 0.8f);
                entitylargefireball.setSizes(size, size);
                entitylargefireball.func_70107_b(headVec.field_72450_a, headVec.field_72448_b, headVec.field_72449_c);
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72838_d((Entity)entitylargefireball);
                }
            }
        } else if (this.isBreathingFire()) {
            if (this.isActuallyBreathingFire()) {
                RayTraceResult mop;
                this.field_70177_z = this.field_70761_aq;
                if (this.field_70173_aa % 5 == 0) {
                    this.func_184185_a(ModSounds.ICEDRAGON_BREATH, 4.0f, 1.0f);
                }
                if ((mop = this.rayTraceRider(controller, 10 * this.getDragonStage(), 1.0f)) != null) {
                    this.stimulateFire(mop.field_72307_f.field_72450_a, mop.field_72307_f.field_72448_b, mop.field_72307_f.field_72449_c, 1);
                }
            }
        } else {
            this.setBreathingFire(true);
        }
    }

    @Override
    public ResourceLocation getDeadLootTable() {
        if (this.getDeathStage() >= this.getAgeInDays() / 5 / 2) {
            return SKELETON_LOOT;
        }
        return this.isMale() ? MALE_LOOT : FEMALE_LOOT;
    }

    public boolean isInMaterialWater() {
        return this.field_70170_p.func_72875_a(this.func_174813_aQ().func_72314_b((double)-0.1f, (double)-0.4f, (double)-0.1f), Material.field_151586_h);
    }

    private void shootIceAtMob(EntityLivingBase entity) {
        if (this.usingGroundAttack && this.groundAttack == IaFDragonAttacks.Ground.FIRE || !this.usingGroundAttack && (this.airAttack == IaFDragonAttacks.Air.SCORCH_STREAM || this.airAttack == IaFDragonAttacks.Air.HOVER_BLAST)) {
            if (this.usingGroundAttack && this.func_70681_au().nextInt(5) == 0 || !this.usingGroundAttack && this.airAttack == IaFDragonAttacks.Air.HOVER_BLAST) {
                if (this.getAnimation() != ANIMATION_FIRECHARGE) {
                    this.setAnimation(ANIMATION_FIRECHARGE);
                } else if (this.getAnimationTick() == 15) {
                    this.field_70177_z = this.field_70761_aq;
                    Vec3d headVec = this.getHeadPosition();
                    double d2 = entity.field_70165_t - headVec.field_72450_a;
                    double d3 = entity.field_70163_u - headVec.field_72448_b;
                    double d4 = entity.field_70161_v - headVec.field_72449_c;
                    float inaccuracy = 1.0f;
                    this.func_184185_a(ModSounds.ICEDRAGON_BREATH, 4.0f, 1.0f);
                    EntityDragonIceCharge entitylargefireball = new EntityDragonIceCharge(this.field_70170_p, this, d2 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, d3 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, d4 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy);
                    float size = this.func_70631_g_() ? 0.4f : (this.isAdult() ? 1.3f : 0.8f);
                    entitylargefireball.setSizes(size, size);
                    entitylargefireball.func_70107_b(headVec.field_72450_a, headVec.field_72448_b, headVec.field_72449_c);
                    if (!this.field_70170_p.field_72995_K) {
                        this.field_70170_p.func_72838_d((Entity)entitylargefireball);
                    }
                    if (entity.field_70128_L || entity == null) {
                        this.setBreathingFire(false);
                        this.usingGroundAttack = true;
                    }
                }
            } else if (this.isBreathingFire()) {
                if (this.isActuallyBreathingFire()) {
                    this.field_70177_z = this.field_70761_aq;
                    if (this.field_70173_aa % 5 == 0) {
                        this.func_184185_a(ModSounds.ICEDRAGON_BREATH, 4.0f, 1.0f);
                    }
                    this.stimulateFire(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 1);
                    if (entity.field_70128_L || entity == null) {
                        this.setBreathingFire(false);
                        this.usingGroundAttack = true;
                    }
                }
            } else {
                this.setBreathingFire(true);
            }
        }
        this.func_70625_a((Entity)entity, 360.0f, 360.0f);
    }

    @Override
    public void stimulateFire(double burnX, double burnY, double burnZ, int syncType) {
        if (syncType == 1 && !this.field_70170_p.field_72995_K) {
            IceAndFire.NETWORK_WRAPPER.sendToAll((IMessage)new MessageDragonSyncFire(this.func_145782_y(), burnX, burnY, burnZ, 0));
        }
        if (syncType == 2 && this.field_70170_p.field_72995_K) {
            IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageDragonSyncFire(this.func_145782_y(), burnX, burnY, burnZ, 0));
        }
        if (syncType == 3 && !this.field_70170_p.field_72995_K) {
            IceAndFire.NETWORK_WRAPPER.sendToAll((IMessage)new MessageDragonSyncFire(this.func_145782_y(), burnX, burnY, burnZ, 5));
        }
        if (syncType == 4 && this.field_70170_p.field_72995_K) {
            IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessageDragonSyncFire(this.func_145782_y(), burnX, burnY, burnZ, 5));
        }
        if (syncType > 2 && syncType < 6) {
            if (this.getAnimation() != ANIMATION_FIRECHARGE) {
                this.setAnimation(ANIMATION_FIRECHARGE);
            } else if (this.getAnimationTick() == 20) {
                this.field_70177_z = this.field_70761_aq;
                Vec3d headVec = this.getHeadPosition();
                double d2 = burnX - headVec.field_72450_a;
                double d3 = burnY - headVec.field_72448_b;
                double d4 = burnZ - headVec.field_72449_c;
                float inaccuracy = 1.0f;
                this.func_184185_a(ModSounds.FIREDRAGON_BREATH, 4.0f, 1.0f);
                EntityDragonIceCharge entitylargefireball = new EntityDragonIceCharge(this.field_70170_p, this, d2 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, d3 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, d4 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy);
                float size = this.func_70631_g_() ? 0.4f : (this.isAdult() ? 1.3f : 0.8f);
                entitylargefireball.setSizes(size, size);
                entitylargefireball.func_70107_b(headVec.field_72450_a, headVec.field_72448_b, headVec.field_72449_c);
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72838_d((Entity)entitylargefireball);
                }
            }
            return;
        }
        this.func_70661_as().func_75499_g();
        this.burnParticleX = burnX;
        this.burnParticleY = burnY;
        this.burnParticleZ = burnZ;
        Vec3d headPos = this.getHeadPosition();
        double d2 = burnX - headPos.field_72450_a;
        double d3 = burnY - headPos.field_72448_b;
        double d4 = burnZ - headPos.field_72449_c;
        float particleScale = MathHelper.func_76131_a((float)(this.getRenderSize() * 0.08f), (float)0.55f, (float)3.0f);
        double distance = Math.max(5.0 * this.func_70011_f(burnX, burnY, burnZ), 0.0);
        double conqueredDistance = (double)this.burnProgress / 40.0 * distance;
        int increment = (int)Math.ceil(conqueredDistance / 100.0);
        int i = 0;
        while ((double)i < conqueredDistance) {
            double progressX = headPos.field_72450_a + d2 * (double)((float)i / (float)distance);
            double progressY = headPos.field_72448_b + d3 * (double)((float)i / (float)distance);
            double progressZ = headPos.field_72449_c + d4 * (double)((float)i / (float)distance);
            if (this.canPositionBeSeen(progressX, progressY, progressZ)) {
                if (this.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(5) == 0) {
                    IceAndFire.PROXY.spawnDragonParticle("dragonice", headPos.field_72450_a, headPos.field_72448_b, headPos.field_72449_c, 0.0, 0.0, 0.0, this);
                }
            } else if (!this.field_70170_p.field_72995_K) {
                RayTraceResult result = this.field_70170_p.func_147447_a(new Vec3d(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v), new Vec3d(progressX, progressY, progressZ), false, true, false);
                BlockPos pos = result.func_178782_a();
                IaFDragonDestructionManager.destroyAreaIce(this.field_70170_p, pos, this);
            }
            i += increment;
        }
        if ((double)this.burnProgress >= 40.0 && this.canPositionBeSeen(burnX, burnY, burnZ)) {
            double spawnX = burnX + (double)this.field_70146_Z.nextFloat() * 3.0 - 1.5;
            double spawnY = burnY + (double)this.field_70146_Z.nextFloat() * 3.0 - 1.5;
            double spawnZ = burnZ + (double)this.field_70146_Z.nextFloat() * 3.0 - 1.5;
            if (!this.field_70170_p.field_72995_K) {
                IaFDragonDestructionManager.destroyAreaIce(this.field_70170_p, new BlockPos(spawnX, spawnY, spawnZ), this);
            }
        }
    }

    public boolean isSwimming() {
        if (this.field_70170_p.field_72995_K) {
            boolean swimming;
            this.isSwimming = swimming = ((Boolean)this.field_70180_af.func_187225_a(SWIMMING)).booleanValue();
            return swimming;
        }
        return this.isSwimming;
    }

    public void setSwimming(boolean swimming) {
        this.field_70180_af.func_187227_b(SWIMMING, (Object)swimming);
        if (!this.field_70170_p.field_72995_K) {
            this.isSwimming = swimming;
        }
    }

    protected SoundEvent func_184639_G() {
        return this.isTeen() ? ModSounds.ICEDRAGON_TEEN_IDLE : (this.isAdult() ? ModSounds.ICEDRAGON_ADULT_IDLE : ModSounds.ICEDRAGON_CHILD_IDLE);
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return this.isTeen() ? ModSounds.ICEDRAGON_TEEN_HURT : (this.isAdult() ? ModSounds.ICEDRAGON_ADULT_HURT : ModSounds.ICEDRAGON_CHILD_HURT);
    }

    protected SoundEvent func_184615_bR() {
        return this.isTeen() ? ModSounds.ICEDRAGON_TEEN_DEATH : (this.isAdult() ? ModSounds.ICEDRAGON_ADULT_DEATH : ModSounds.ICEDRAGON_CHILD_DEATH);
    }

    @Override
    public SoundEvent getRoarSound() {
        return this.isTeen() ? ModSounds.ICEDRAGON_TEEN_ROAR : (this.isAdult() ? ModSounds.ICEDRAGON_ADULT_ROAR : ModSounds.ICEDRAGON_CHILD_ROAR);
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{IAnimatedEntity.NO_ANIMATION, EntityDragonBase.ANIMATION_EAT, EntityDragonBase.ANIMATION_SPEAK, EntityDragonBase.ANIMATION_BITE, EntityDragonBase.ANIMATION_SHAKEPREY, ANIMATION_TAILWHACK, ANIMATION_FIRECHARGE, ANIMATION_WINGBLAST, ANIMATION_ROAR};
    }

    public boolean func_70877_b(@Nullable ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() != null && stack.func_77973_b() == ModItems.frost_stew;
    }

    @Override
    protected void breathFireAtPos(BlockPos burningTarget) {
        if (this.isBreathingFire()) {
            if (this.isActuallyBreathingFire()) {
                this.field_70177_z = this.field_70761_aq;
                if (this.field_70173_aa % 5 == 0) {
                    this.func_184185_a(ModSounds.ICEDRAGON_BREATH, 4.0f, 1.0f);
                }
                this.stimulateFire(burningTarget.func_177958_n(), burningTarget.func_177956_o(), burningTarget.func_177952_p(), 1);
            }
        } else {
            this.setBreathingFire(true);
        }
    }

    @Override
    public double getFlightSpeedModifier() {
        return super.getFlightSpeedModifier() * (double)(this.isInMaterialWater() ? 0.8f : 1.0f);
    }

    @Override
    public boolean isAllowedToTriggerFlight() {
        return super.isAllowedToTriggerFlight() && !this.func_70090_H();
    }

    @Override
    protected void spawnDeathParticles() {
        if (this.field_70170_p.field_72995_K) {
            for (int k = 0; k < 10; ++k) {
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                IceAndFire.PROXY.spawnParticle("snowflake", this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d2, d0, d1);
            }
        }
    }

    @Override
    protected void spawnBabyParticles() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 5; ++i) {
                float radiusAdd = (float)i * 0.15f;
                float headPosX = (float)(this.field_70165_t + (double)(1.8f * this.getRenderSize() * (0.3f + radiusAdd)) * Math.cos((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0));
                float headPosZ = (float)(this.field_70161_v + (double)(1.8f * this.getRenderSize() * (0.3f + radiusAdd)) * Math.sin((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0));
                float headPosY = (float)(this.field_70163_u + 0.5 * (double)this.getRenderSize() * (double)0.3f);
                IceAndFire.PROXY.spawnParticle("dragonice", headPosX, headPosY, headPosZ, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public int getStartMetaForType() {
        return 4;
    }

    @Override
    public SoundEvent getBabyFireSound() {
        return SoundEvents.field_187618_I;
    }

    @Override
    protected ItemStack getSkull() {
        return new ItemStack(ModItems.dragon_skull, 1, 1);
    }

    @Override
    protected ItemStack getHorn() {
        return new ItemStack(ModItems.dragon_horn_ice);
    }

    @Override
    public boolean useFlyingPathFinder() {
        return this.isFlying() || this.isInMaterialWater();
    }
}

