/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.core;

import com.github.alexthe666.iceandfire.core.ModBlocks;
import com.github.alexthe666.iceandfire.core.ModItems;
import com.github.alexthe666.iceandfire.entity.EntityAmphithereArrow;
import com.github.alexthe666.iceandfire.entity.EntityCockatriceEgg;
import com.github.alexthe666.iceandfire.entity.EntityDeathWormEgg;
import com.github.alexthe666.iceandfire.entity.EntityDragonArrow;
import com.github.alexthe666.iceandfire.entity.EntityHippogryphEgg;
import com.github.alexthe666.iceandfire.entity.EntitySeaSerpentArrow;
import com.github.alexthe666.iceandfire.entity.EntityStymphalianArrow;
import com.github.alexthe666.iceandfire.enums.EnumDragonArmor;
import com.github.alexthe666.iceandfire.enums.EnumSeaSerpent;
import com.github.alexthe666.iceandfire.enums.EnumSkullType;
import com.github.alexthe666.iceandfire.enums.EnumTroll;
import com.github.alexthe666.iceandfire.recipe.DragonForgeRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.dispenser.BehaviorProjectileDispense;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;

public class ModRecipes {
    public static List<DragonForgeRecipe> FIRE_FORGE_RECIPES = new ArrayList<DragonForgeRecipe>();
    public static List<DragonForgeRecipe> ICE_FORGE_RECIPES = new ArrayList<DragonForgeRecipe>();
    public static List<ItemStack> BANNER_ITEMS = new ArrayList<ItemStack>();

    public static void preInit() {
        FIRE_FORGE_RECIPES.add(new DragonForgeRecipe(new ItemStack(Items.field_151042_j), new ItemStack(ModItems.fire_dragon_blood), new ItemStack(ModItems.dragonsteel_fire_ingot)));
        ICE_FORGE_RECIPES.add(new DragonForgeRecipe(new ItemStack(Items.field_151042_j), new ItemStack(ModItems.ice_dragon_blood), new ItemStack(ModItems.dragonsteel_ice_ingot)));
        BlockDispenser.field_149943_a.func_82595_a((Object)ModItems.stymphalian_arrow, (Object)new BehaviorProjectileDispense(){

            protected IProjectile func_82499_a(World worldIn, IPosition position, ItemStack stackIn) {
                EntityStymphalianArrow entityarrow = new EntityStymphalianArrow(worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
                entityarrow.field_70251_a = EntityArrow.PickupStatus.ALLOWED;
                return entityarrow;
            }
        });
        BlockDispenser.field_149943_a.func_82595_a((Object)ModItems.amphithere_arrow, (Object)new BehaviorProjectileDispense(){

            protected IProjectile func_82499_a(World worldIn, IPosition position, ItemStack stackIn) {
                EntityAmphithereArrow entityarrow = new EntityAmphithereArrow(worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
                entityarrow.field_70251_a = EntityArrow.PickupStatus.ALLOWED;
                return entityarrow;
            }
        });
        BlockDispenser.field_149943_a.func_82595_a((Object)ModItems.sea_serpent_arrow, (Object)new BehaviorProjectileDispense(){

            protected IProjectile func_82499_a(World worldIn, IPosition position, ItemStack stackIn) {
                EntitySeaSerpentArrow entityarrow = new EntitySeaSerpentArrow(worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
                entityarrow.field_70251_a = EntityArrow.PickupStatus.ALLOWED;
                return entityarrow;
            }
        });
        BlockDispenser.field_149943_a.func_82595_a((Object)ModItems.dragonbone_arrow, (Object)new BehaviorProjectileDispense(){

            protected IProjectile func_82499_a(World worldIn, IPosition position, ItemStack stackIn) {
                EntityDragonArrow entityarrow = new EntityDragonArrow(worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
                entityarrow.field_70251_a = EntityArrow.PickupStatus.ALLOWED;
                return entityarrow;
            }
        });
        BlockDispenser.field_149943_a.func_82595_a((Object)ModItems.hippogryph_egg, (Object)new BehaviorProjectileDispense(){

            protected IProjectile func_82499_a(World worldIn, IPosition position, ItemStack stackIn) {
                EntityHippogryphEgg entityarrow = new EntityHippogryphEgg(worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c(), stackIn);
                return entityarrow;
            }
        });
        BlockDispenser.field_149943_a.func_82595_a((Object)ModItems.rotten_egg, (Object)new BehaviorProjectileDispense(){

            protected IProjectile func_82499_a(World worldIn, IPosition position, ItemStack stackIn) {
                EntityCockatriceEgg entityarrow = new EntityCockatriceEgg(worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
                return entityarrow;
            }
        });
        BlockDispenser.field_149943_a.func_82595_a((Object)ModItems.deathworm_egg, (Object)new BehaviorProjectileDispense(){

            protected IProjectile func_82499_a(World worldIn, IPosition position, ItemStack stackIn) {
                EntityDeathWormEgg entityarrow = new EntityDeathWormEgg(worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c(), stackIn.func_77960_j() == 1);
                return entityarrow;
            }
        });
        OreDictionary.registerOre((String)"desertMyrmexEgg", (ItemStack)new ItemStack(ModItems.myrmex_desert_egg, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"jungleMyrmexEgg", (ItemStack)new ItemStack(ModItems.myrmex_jungle_egg, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"charredBlock", (Block)ModBlocks.charedDirt);
        OreDictionary.registerOre((String)"charredBlock", (Block)ModBlocks.charedGrass);
        OreDictionary.registerOre((String)"charredBlock", (Block)ModBlocks.charedGrassPath);
        OreDictionary.registerOre((String)"charredBlock", (Block)ModBlocks.charedGravel);
        OreDictionary.registerOre((String)"charredBlock", (Block)ModBlocks.charedCobblestone);
        OreDictionary.registerOre((String)"charredBlock", (Block)ModBlocks.charedStone);
        OreDictionary.registerOre((String)"frozenBlock", (Block)ModBlocks.frozenDirt);
        OreDictionary.registerOre((String)"frozenBlock", (Block)ModBlocks.frozenGrass);
        OreDictionary.registerOre((String)"frozenBlock", (Block)ModBlocks.frozenGrassPath);
        OreDictionary.registerOre((String)"frozenBlock", (Block)ModBlocks.frozenGravel);
        OreDictionary.registerOre((String)"frozenBlock", (Block)ModBlocks.frozenCobblestone);
        OreDictionary.registerOre((String)"frozenBlock", (Block)ModBlocks.frozenStone);
        OreDictionary.registerOre((String)"ingotFireDragonsteel", (Item)ModItems.dragonsteel_fire_ingot);
        OreDictionary.registerOre((String)"blockFireDragonsteel", (Block)ModBlocks.dragonsteel_fire_block);
        OreDictionary.registerOre((String)"ingotIceDragonsteel", (Item)ModItems.dragonsteel_ice_ingot);
        OreDictionary.registerOre((String)"blockIceDragonsteel", (Block)ModBlocks.dragonsteel_ice_block);
        OreDictionary.registerOre((String)"ingotSilver", (Item)ModItems.silverIngot);
        OreDictionary.registerOre((String)"nuggetSilver", (Item)ModItems.silverNugget);
        OreDictionary.registerOre((String)"oreSilver", (Block)ModBlocks.silverOre);
        OreDictionary.registerOre((String)"blockSilver", (Block)ModBlocks.silverBlock);
        OreDictionary.registerOre((String)"gemSapphire", (Item)ModItems.sapphireGem);
        OreDictionary.registerOre((String)"oreSapphire", (Block)ModBlocks.sapphireOre);
        OreDictionary.registerOre((String)"blockSapphire", (Block)ModBlocks.sapphireBlock);
        OreDictionary.registerOre((String)"boneWither", (Item)ModItems.witherbone);
        OreDictionary.registerOre((String)"fireDragonScaleBlock", (Block)ModBlocks.dragonscale_red);
        OreDictionary.registerOre((String)"fireDragonScaleBlock", (Block)ModBlocks.dragonscale_bronze);
        OreDictionary.registerOre((String)"fireDragonScaleBlock", (Block)ModBlocks.dragonscale_gray);
        OreDictionary.registerOre((String)"fireDragonScaleBlock", (Block)ModBlocks.dragonscale_green);
        OreDictionary.registerOre((String)"iceDragonScaleBlock", (Block)ModBlocks.dragonscale_blue);
        OreDictionary.registerOre((String)"iceDragonScaleBlock", (Block)ModBlocks.dragonscale_white);
        OreDictionary.registerOre((String)"iceDragonScaleBlock", (Block)ModBlocks.dragonscale_sapphire);
        OreDictionary.registerOre((String)"iceDragonScaleBlock", (Block)ModBlocks.dragonscale_silver);
        OreDictionary.registerOre((String)"woolBlock", (ItemStack)new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"foodMeat", (Item)Items.field_151076_bf);
        OreDictionary.registerOre((String)"foodMeat", (Item)Items.field_151077_bg);
        OreDictionary.registerOre((String)"foodMeat", (Item)Items.field_151082_bd);
        OreDictionary.registerOre((String)"foodMeat", (Item)Items.field_151083_be);
        OreDictionary.registerOre((String)"foodMeat", (Item)Items.field_151147_al);
        OreDictionary.registerOre((String)"foodMeat", (Item)Items.field_151157_am);
        OreDictionary.registerOre((String)"foodMeat", (Item)Items.field_179561_bm);
        OreDictionary.registerOre((String)"foodMeat", (Item)Items.field_179557_bn);
        OreDictionary.registerOre((String)"foodMeat", (Item)Items.field_179558_bo);
        OreDictionary.registerOre((String)"foodMeat", (Item)Items.field_179559_bp);
        OreDictionary.registerOre((String)"boneWithered", (Item)ModItems.witherbone);
        OreDictionary.registerOre((String)"boneDragon", (Item)ModItems.dragonbone);
        for (EnumSeaSerpent enumSeaSerpent : EnumSeaSerpent.values()) {
            OreDictionary.registerOre((String)"seaSerpentScales", (Item)enumSeaSerpent.scale);
        }
        OreDictionary.registerOre((String)"listAllEgg", (ItemStack)new ItemStack(ModItems.hippogryph_egg, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"objectEgg", (ItemStack)new ItemStack(ModItems.hippogryph_egg, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"bakingEgg", (ItemStack)new ItemStack(ModItems.hippogryph_egg, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"egg", (ItemStack)new ItemStack(ModItems.hippogryph_egg, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"ingredientEgg", (ItemStack)new ItemStack(ModItems.hippogryph_egg, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"foodSimpleEgg", (ItemStack)new ItemStack(ModItems.hippogryph_egg, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"listAllEgg", (ItemStack)new ItemStack(ModItems.deathworm_egg, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"objectEgg", (ItemStack)new ItemStack(ModItems.deathworm_egg, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"bakingEgg", (ItemStack)new ItemStack(ModItems.deathworm_egg, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"egg", (ItemStack)new ItemStack(ModItems.deathworm_egg, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"ingredientEgg", (ItemStack)new ItemStack(ModItems.deathworm_egg, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"foodSimpleEgg", (ItemStack)new ItemStack(ModItems.deathworm_egg, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"listAllEgg", (ItemStack)new ItemStack(ModItems.myrmex_jungle_egg, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"objectEgg", (ItemStack)new ItemStack(ModItems.myrmex_jungle_egg, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"bakingEgg", (ItemStack)new ItemStack(ModItems.myrmex_jungle_egg, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"egg", (ItemStack)new ItemStack(ModItems.myrmex_jungle_egg, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"ingredientEgg", (ItemStack)new ItemStack(ModItems.myrmex_jungle_egg, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"foodSimpleEgg", (ItemStack)new ItemStack(ModItems.myrmex_jungle_egg, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"listAllEgg", (ItemStack)new ItemStack(ModItems.myrmex_desert_egg, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"objectEgg", (ItemStack)new ItemStack(ModItems.myrmex_desert_egg, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"bakingEgg", (ItemStack)new ItemStack(ModItems.myrmex_desert_egg, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"egg", (ItemStack)new ItemStack(ModItems.myrmex_desert_egg, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"ingredientEgg", (ItemStack)new ItemStack(ModItems.myrmex_desert_egg, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"foodSimpleEgg", (ItemStack)new ItemStack(ModItems.myrmex_desert_egg, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"toolAxe", (Item)ModItems.dragonbone_axe);
        OreDictionary.registerOre((String)"toolAxe", (Item)ModItems.myrmex_desert_axe);
        OreDictionary.registerOre((String)"toolAxe", (Item)ModItems.myrmex_jungle_axe);
        OreDictionary.registerOre((String)"toolAxe", (Item)ModItems.silver_axe);
        OreDictionary.registerOre((String)"toolAxe", (Item)ModItems.dragonsteel_fire_axe);
        OreDictionary.registerOre((String)"toolAxe", (Item)ModItems.dragonsteel_ice_axe);
        ModRecipes.addBanner("fire", new ItemStack(ModItems.fire_dragon_heart));
        ModRecipes.addBanner("ice", new ItemStack(ModItems.ice_dragon_heart));
        ModRecipes.addBanner("fire_head", new ItemStack(ModItems.dragon_skull, 1, 0));
        ModRecipes.addBanner("ice_head", new ItemStack(ModItems.dragon_skull, 1, 1));
        ModRecipes.addBanner("amphithere", new ItemStack(ModItems.amphithere_feather));
        ModRecipes.addBanner("bird", new ItemStack(ModItems.stymphalian_bird_feather));
        ModRecipes.addBanner("eye", new ItemStack(ModItems.cyclops_eye));
        ModRecipes.addBanner("fae", new ItemStack(ModItems.pixie_wings));
        ModRecipes.addBanner("feather", new ItemStack(Items.field_151008_G));
        ModRecipes.addBanner("gorgon", new ItemStack(ModItems.gorgon_head));
        ModRecipes.addBanner("hippocampus", new ItemStack(ModItems.hippocampus_fin));
        ModRecipes.addBanner("hippogryph_head", new ItemStack(EnumSkullType.HIPPOGRYPH.skull_item));
        ModRecipes.addBanner("mermaid", new ItemStack(ModItems.siren_tear));
        ModRecipes.addBanner("sea_serpent", new ItemStack(ModItems.sea_serpent_fang));
        ModRecipes.addBanner("troll", new ItemStack(ModItems.troll_tusk));
        ModRecipes.addBanner("weezer", new ItemStack(ModItems.weezer_blue_album));
        GameRegistry.addSmelting((Block)ModBlocks.silverOre, (ItemStack)new ItemStack(ModItems.silverIngot), (float)1.0f);
        GameRegistry.addSmelting((Block)ModBlocks.sapphireOre, (ItemStack)new ItemStack(ModItems.sapphireGem), (float)1.0f);
        GameRegistry.addSmelting((Block)ModBlocks.myrmex_desert_resin_block, (ItemStack)new ItemStack(ModBlocks.myrmex_desert_resin_glass), (float)1.0f);
        GameRegistry.addSmelting((Block)ModBlocks.myrmex_jungle_resin_block, (ItemStack)new ItemStack(ModBlocks.myrmex_jungle_resin_glass), (float)1.0f);
        GameRegistry.addSmelting((Block)ModBlocks.frozenDirt, (ItemStack)new ItemStack(Blocks.field_150346_d), (float)0.1f);
        GameRegistry.addSmelting((Block)ModBlocks.frozenGrass, (ItemStack)new ItemStack((Block)Blocks.field_150349_c), (float)0.1f);
        GameRegistry.addSmelting((Block)ModBlocks.frozenGrassPath, (ItemStack)new ItemStack(Blocks.field_185774_da), (float)0.1f);
        GameRegistry.addSmelting((Block)ModBlocks.frozenCobblestone, (ItemStack)new ItemStack(Blocks.field_150347_e), (float)0.1f);
        GameRegistry.addSmelting((Block)ModBlocks.frozenStone, (ItemStack)new ItemStack(Blocks.field_150348_b), (float)0.1f);
        GameRegistry.addSmelting((Block)ModBlocks.frozenGravel, (ItemStack)new ItemStack(Blocks.field_150351_n), (float)0.1f);
        GameRegistry.addSmelting((Block)ModBlocks.frozenSplinters, (ItemStack)new ItemStack(Items.field_151055_y, 3), (float)0.1f);
        ModItems.blindfoldArmor.setRepairItem(new ItemStack(Items.field_151007_F));
        ModItems.silverMetal.setRepairItem(new ItemStack(ModItems.silverIngot));
        ModItems.silverTools.setRepairItem(new ItemStack(ModItems.silverIngot));
        ModItems.boneTools.setRepairItem(new ItemStack(ModItems.dragonbone));
        ModItems.fireBoneTools.setRepairItem(new ItemStack(ModItems.dragonbone));
        ModItems.iceBoneTools.setRepairItem(new ItemStack(ModItems.dragonbone));
        for (Enum enum_ : EnumDragonArmor.values()) {
            ((EnumDragonArmor)enum_).armorMaterial.setRepairItem(new ItemStack(EnumDragonArmor.getScaleItem((EnumDragonArmor)enum_)));
        }
        ModItems.dragonsteel_fire_armor.setRepairItem(new ItemStack(ModItems.dragonsteel_fire_ingot));
        ModItems.dragonsteel_ice_armor.setRepairItem(new ItemStack(ModItems.dragonsteel_ice_ingot));
        ModItems.sheep.setRepairItem(new ItemStack(Blocks.field_150325_L));
        ModItems.earplugsArmor.setRepairItem(new ItemStack(Blocks.field_150471_bO));
        ModItems.yellow_deathworm.setRepairItem(new ItemStack(ModItems.deathworm_chitin, 1, 0));
        ModItems.white_deathworm.setRepairItem(new ItemStack(ModItems.deathworm_chitin, 1, 1));
        ModItems.red_deathworm.setRepairItem(new ItemStack(ModItems.deathworm_chitin, 1, 2));
        ModItems.trollWeapon.setRepairItem(new ItemStack(Blocks.field_150348_b));
        ModItems.troll_mountain.setRepairItem(new ItemStack(EnumTroll.MOUNTAIN.leather));
        ModItems.troll_forest.setRepairItem(new ItemStack(EnumTroll.FOREST.leather));
        ModItems.troll_frost.setRepairItem(new ItemStack(EnumTroll.FROST.leather));
        ModItems.hippogryph_sword_tools.setRepairItem(new ItemStack(ModItems.hippogryph_talon));
        ModItems.hippocampus_sword_tools.setRepairItem(new ItemStack(ModItems.shiny_scales));
        ModItems.amphithere_sword_tools.setRepairItem(new ItemStack(ModItems.amphithere_feather));
        ModItems.dragonsteel_fire_tools.setRepairItem(new ItemStack(ModItems.dragonsteel_fire_ingot));
        ModItems.dragonsteel_ice_tools.setRepairItem(new ItemStack(ModItems.dragonsteel_ice_ingot));
        ModItems.stymphalian_sword_tools.setRepairItem(new ItemStack(ModItems.stymphalian_bird_feather));
        ModItems.myrmexChitin.setRepairItem(new ItemStack(ModItems.myrmex_desert_chitin));
        ModItems.myrmexDesert.setRepairItem(new ItemStack(ModItems.myrmex_desert_chitin));
        ModItems.myrmexJungle.setRepairItem(new ItemStack(ModItems.myrmex_jungle_chitin));
        for (Enum enum_ : EnumSeaSerpent.values()) {
            ((EnumSeaSerpent)enum_).armorMaterial.setRepairItem(new ItemStack(((EnumSeaSerpent)enum_).scale));
        }
        ItemStack waterBreathingPotion = new ItemStack((Item)Items.field_151068_bn, 1, 0);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("Potion", "water_breathing");
        waterBreathingPotion.func_77982_d(tag);
        BrewingRecipeRegistry.addRecipe((ItemStack)new ItemStack((Item)Items.field_151068_bn, 1, 0), (ItemStack)new ItemStack(ModItems.shiny_scales), (ItemStack)waterBreathingPotion);
    }

    public static BannerPattern addBanner(String name, ItemStack craftingStack) {
        Class[] classes = new Class[]{String.class, String.class, ItemStack.class};
        Object[] names = new Object[]{name, "iceandfire." + name, craftingStack};
        BANNER_ITEMS.add(craftingStack);
        return (BannerPattern)EnumHelper.addEnum(BannerPattern.class, (String)name.toUpperCase(), (Class[])classes, (Object[])names);
    }

    public static void postInit() {
        block2: {
            NonNullList copperItems;
            block3: {
                NonNullList bronzeItems = OreDictionary.getOres((String)"nuggetBronze");
                copperItems = OreDictionary.getOres((String)"nuggetCopper");
                if (bronzeItems.isEmpty()) break block3;
                for (ItemStack bronzeIngot : bronzeItems) {
                    if (bronzeIngot == ItemStack.field_190927_a) continue;
                    GameRegistry.addSmelting((Item)ModItems.stymphalian_bird_feather, (ItemStack)bronzeIngot.func_77946_l(), (float)1.0f);
                    break block2;
                }
                break block2;
            }
            if (copperItems.isEmpty()) break block2;
            for (ItemStack copperIngot : copperItems) {
                if (copperIngot == ItemStack.field_190927_a) continue;
                GameRegistry.addSmelting((Item)ModItems.stymphalian_bird_feather, (ItemStack)copperIngot.func_77946_l(), (float)1.0f);
                break;
            }
        }
    }

    public static DragonForgeRecipe getFireForgeRecipe(ItemStack stack) {
        for (DragonForgeRecipe recipe : FIRE_FORGE_RECIPES) {
            if (!OreDictionary.itemMatches((ItemStack)recipe.getInput(), (ItemStack)stack, (boolean)false)) continue;
            return recipe;
        }
        return null;
    }

    public static DragonForgeRecipe getIceForgeRecipe(ItemStack stack) {
        for (DragonForgeRecipe recipe : ICE_FORGE_RECIPES) {
            if (!OreDictionary.itemMatches((ItemStack)recipe.getInput(), (ItemStack)stack, (boolean)false)) continue;
            return recipe;
        }
        return null;
    }

    public static DragonForgeRecipe getFireForgeRecipeForBlood(ItemStack stack) {
        for (DragonForgeRecipe recipe : FIRE_FORGE_RECIPES) {
            if (!OreDictionary.itemMatches((ItemStack)recipe.getBlood(), (ItemStack)stack, (boolean)false)) continue;
            return recipe;
        }
        return null;
    }

    public static DragonForgeRecipe getIceForgeRecipeForBlood(ItemStack stack) {
        for (DragonForgeRecipe recipe : ICE_FORGE_RECIPES) {
            if (!OreDictionary.itemMatches((ItemStack)recipe.getBlood(), (ItemStack)stack, (boolean)false)) continue;
            return recipe;
        }
        return null;
    }
}

