/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.render.entity.layer;

import com.github.alexthe666.iceandfire.ClientProxy;
import com.github.alexthe666.iceandfire.client.model.util.IceAndFireTabulaModel;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import net.ilexiconn.llibrary.client.model.tools.AdvancedModelRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelHorse;
import net.minecraft.client.model.ModelQuadruped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.util.ReportedException;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class LayerDragonRider
implements LayerRenderer<EntityDragonBase> {
    private final RenderLiving render;

    public LayerDragonRider(RenderLiving renderIn) {
        this.render = renderIn;
    }

    public void doRenderLayer(EntityDragonBase dragon, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        GlStateManager.func_179094_E();
        if (!dragon.func_184188_bt().isEmpty()) {
            float dragonScale = dragon.getRenderSize() / 3.0f;
            for (Entity passenger : dragon.func_184188_bt()) {
                boolean prey = dragon.func_184179_bs() == null || dragon.func_184179_bs().func_145782_y() != passenger.func_145782_y();
                ClientProxy.currentDragonRiders.remove(passenger.func_110124_au());
                float riderRot = passenger.field_70126_B + (passenger.field_70177_z - passenger.field_70126_B) * partialTicks;
                int animationTicks = 0;
                if (dragon.getAnimation() == EntityDragonBase.ANIMATION_SHAKEPREY) {
                    animationTicks = dragon.getAnimationTick();
                }
                if (animationTicks == 0 || animationTicks >= 15) {
                    this.translateToBody();
                }
                if (prey) {
                    if (animationTicks == 0 || animationTicks >= 15 || dragon.isFlying()) {
                        this.translateToHead();
                        Render render = Minecraft.func_71410_x().func_175598_ae().func_78713_a(passenger);
                        ModelBase modelBase = null;
                        if (render instanceof RenderLiving) {
                            modelBase = ((RenderLiving)render).func_177087_b();
                        }
                        if ((passenger.field_70131_O > passenger.field_70130_N || modelBase instanceof ModelBiped) && !(modelBase instanceof ModelQuadruped) && !(modelBase instanceof ModelHorse)) {
                            GlStateManager.func_179109_b((float)(-0.15f * passenger.field_70131_O), (float)(0.1f * dragonScale - 0.1f * passenger.field_70131_O), (float)(-0.1f * dragonScale - 0.1f * passenger.field_70130_N));
                            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                            GlStateManager.func_179114_b((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        } else {
                            boolean horse = modelBase instanceof ModelHorse;
                            GlStateManager.func_179109_b((float)((horse ? -0.08f : -0.15f) * passenger.field_70130_N), (float)(0.1f * dragonScale - 0.15f * passenger.field_70130_N), (float)(-0.1f * dragonScale - 0.1f * passenger.field_70130_N));
                            GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        }
                    } else {
                        GlStateManager.func_179109_b((float)0.0f, (float)(0.555f * dragonScale), (float)(-0.5f * dragonScale));
                    }
                } else {
                    GlStateManager.func_179109_b((float)0.0f, (float)(-0.01f * dragonScale), (float)(-0.035f * dragonScale));
                }
                GlStateManager.func_179094_E();
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)(riderRot + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)(1.0f / dragonScale), (float)(1.0f / dragonScale), (float)(1.0f / dragonScale));
                GlStateManager.func_179109_b((float)0.0f, (float)-0.25f, (float)0.0f);
                this.renderEntity(passenger, 0.0, 0.0, 0.0, 0.0f, partialTicks, true);
                GlStateManager.func_179121_F();
                ClientProxy.currentDragonRiders.add(passenger.func_110124_au());
            }
        }
        GlStateManager.func_179121_F();
    }

    protected void translateToBody() {
        this.postRender(((IceAndFireTabulaModel)this.render.func_177087_b()).getCube("BodyUpper"), 0.0625f);
        this.postRender(((IceAndFireTabulaModel)this.render.func_177087_b()).getCube("Neck1"), 0.0625f);
    }

    protected void translateToHead() {
        this.postRender(((IceAndFireTabulaModel)this.render.func_177087_b()).getCube("Neck2"), 0.0625f);
        this.postRender(((IceAndFireTabulaModel)this.render.func_177087_b()).getCube("Neck3"), 0.0625f);
        this.postRender(((IceAndFireTabulaModel)this.render.func_177087_b()).getCube("Head"), 0.0625f);
    }

    protected void postRender(AdvancedModelRenderer renderer, float scale) {
        if (renderer.field_78795_f == 0.0f && renderer.field_78796_g == 0.0f && renderer.field_78808_h == 0.0f) {
            if (renderer.field_78800_c != 0.0f || renderer.field_78797_d != 0.0f || renderer.field_78798_e != 0.0f) {
                GlStateManager.func_179109_b((float)(renderer.field_78800_c * scale), (float)(renderer.field_78797_d * scale), (float)(renderer.field_78798_e * scale));
            }
        } else {
            GlStateManager.func_179109_b((float)(renderer.field_78800_c * scale), (float)(renderer.field_78797_d * scale), (float)(renderer.field_78798_e * scale));
            if (renderer.field_78808_h != 0.0f) {
                GlStateManager.func_179114_b((float)(renderer.field_78808_h * 57.295776f), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (renderer.field_78796_g != 0.0f) {
                GlStateManager.func_179114_b((float)(renderer.field_78796_g * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if (renderer.field_78795_f != 0.0f) {
                GlStateManager.func_179114_b((float)(renderer.field_78795_f * 57.295776f), (float)1.0f, (float)0.0f, (float)0.0f);
            }
        }
    }

    public void renderEntity(Entity entityIn, double x, double y, double z, float yaw, float partialTicks, boolean p_188391_10_) {
        block4: {
            Render render = null;
            RenderManager manager = Minecraft.func_71410_x().func_175598_ae();
            try {
                render = manager.func_78713_a(entityIn);
                if (render == null || manager.field_78724_e == null) break block4;
                try {
                    render.func_76986_a(entityIn, x, y, z, yaw, partialTicks);
                }
                catch (Throwable throwable1) {
                    throw new ReportedException(CrashReport.func_85055_a((Throwable)throwable1, (String)"Rendering entity in world"));
                }
            }
            catch (Throwable throwable3) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable3, (String)"Rendering entity in world");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Entity being rendered");
                entityIn.func_85029_a(crashreportcategory);
                CrashReportCategory crashreportcategory1 = crashreport.func_85058_a("Renderer details");
                crashreportcategory1.func_71507_a("Assigned renderer", (Object)render);
                crashreportcategory1.func_71507_a("Location", (Object)CrashReportCategory.func_85074_a((double)x, (double)y, (double)z));
                crashreportcategory1.func_71507_a("Rotation", (Object)Float.valueOf(yaw));
                crashreportcategory1.func_71507_a("Delta", (Object)Float.valueOf(partialTicks));
                throw new ReportedException(crashreport);
            }
        }
    }

    public boolean func_177142_b() {
        return false;
    }
}

