/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.render.entity;

import com.github.alexthe666.iceandfire.client.render.entity.layer.LayerDragonArmor;
import com.github.alexthe666.iceandfire.client.render.entity.layer.LayerDragonBanner;
import com.github.alexthe666.iceandfire.client.render.entity.layer.LayerDragonEyes;
import com.github.alexthe666.iceandfire.client.render.entity.layer.LayerDragonRider;
import com.github.alexthe666.iceandfire.client.texture.ArrayLayeredTexture;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.enums.EnumDragonTextures;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderDragonBase
extends RenderLiving<EntityDragonBase> {
    private Map<String, ResourceLocation> LAYERED_TEXTURE_CACHE = Maps.newHashMap();
    private boolean fire;

    public RenderDragonBase(RenderManager renderManager, ModelBase model, boolean fire) {
        super(renderManager, model, 0.8f);
        this.func_177094_a(new LayerDragonEyes(this));
        this.func_177094_a(new LayerDragonRider(this));
        this.func_177094_a(new LayerDragonBanner(this));
        this.func_177094_a(new LayerDragonArmor(this, fire));
        this.fire = fire;
    }

    public boolean shouldRender(EntityDragonBase dragon, ICamera camera, double camX, double camY, double camZ) {
        return true;
    }

    protected void preRenderCallback(EntityDragonBase entity, float f) {
        this.field_76989_e = entity.getRenderSize() / 3.0f;
        GL11.glScalef((float)this.field_76989_e, (float)this.field_76989_e, (float)this.field_76989_e);
        float f7 = entity.prevDragonPitch + (entity.getDragonPitch() - entity.prevDragonPitch) * f;
        GL11.glRotatef((float)f7, (float)1.0f, (float)0.0f, (float)0.0f);
    }

    protected ResourceLocation getEntityTexture(EntityDragonBase entity) {
        String baseTexture = entity.getVariantName(entity.getVariant()) + " " + entity.getDragonStage() + entity.isModelDead() + entity.isMale() + entity.isSkeletal() + entity.isSleeping() + entity.isBlinking();
        ResourceLocation resourcelocation = this.LAYERED_TEXTURE_CACHE.get(baseTexture);
        if (resourcelocation == null) {
            resourcelocation = EnumDragonTextures.getTextureFromDragon(entity);
            ArrayList<String> tex = new ArrayList<String>();
            tex.add(resourcelocation.toString());
            if (entity.isMale() && !entity.isSkeletal()) {
                if (this.fire) {
                    tex.add(EnumDragonTextures.getDragonEnum((EntityDragonBase)entity).FIRE_MALE_OVERLAY.toString());
                } else {
                    tex.add(EnumDragonTextures.getDragonEnum((EntityDragonBase)entity).ICE_MALE_OVERLAY.toString());
                }
            }
            ArrayLayeredTexture layeredBase = new ArrayLayeredTexture(tex);
            Minecraft.func_71410_x().func_110434_K().func_110579_a(resourcelocation, (ITextureObject)layeredBase);
            this.LAYERED_TEXTURE_CACHE.put(baseTexture, resourcelocation);
        }
        return resourcelocation;
    }
}

