/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.model.animator;

import com.github.alexthe666.iceandfire.client.model.animator.IceAndFireTabulaModelAnimator;
import com.github.alexthe666.iceandfire.client.model.util.EnumDragonAnimations;
import com.github.alexthe666.iceandfire.client.model.util.IIceAndFireTabulaModelAnimator;
import com.github.alexthe666.iceandfire.client.model.util.IceAndFireTabulaModel;
import com.github.alexthe666.iceandfire.client.model.util.LegArticulator;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntityIceDragon;
import net.ilexiconn.llibrary.LLibrary;
import net.ilexiconn.llibrary.client.model.tools.AdvancedModelRenderer;
import net.ilexiconn.llibrary.server.animation.IAnimatedEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class IceDragonTabulaModelAnimator
extends IceAndFireTabulaModelAnimator
implements IIceAndFireTabulaModelAnimator<EntityIceDragon> {
    private IceAndFireTabulaModel[] walkPoses;
    private IceAndFireTabulaModel[] flyPoses;
    private IceAndFireTabulaModel[] swimPoses;
    private AdvancedModelRenderer[] neckParts;
    private AdvancedModelRenderer[] tailParts;
    private AdvancedModelRenderer[] tailPartsWBody;
    private AdvancedModelRenderer[] toesPartsL;
    private AdvancedModelRenderer[] toesPartsR;
    private AdvancedModelRenderer[] clawL;
    private AdvancedModelRenderer[] clawR;

    public IceDragonTabulaModelAnimator() {
        super(EnumDragonAnimations.GROUND_POSE.icedragon_model);
        this.walkPoses = new IceAndFireTabulaModel[]{EnumDragonAnimations.WALK1.icedragon_model, EnumDragonAnimations.WALK2.icedragon_model, EnumDragonAnimations.WALK3.icedragon_model, EnumDragonAnimations.WALK4.icedragon_model};
        this.flyPoses = new IceAndFireTabulaModel[]{EnumDragonAnimations.FLIGHT1.icedragon_model, EnumDragonAnimations.FLIGHT2.icedragon_model, EnumDragonAnimations.FLIGHT3.icedragon_model, EnumDragonAnimations.FLIGHT4.icedragon_model, EnumDragonAnimations.FLIGHT5.icedragon_model, EnumDragonAnimations.FLIGHT6.icedragon_model};
        this.swimPoses = new IceAndFireTabulaModel[]{EnumDragonAnimations.SWIM1.icedragon_model, EnumDragonAnimations.SWIM2.icedragon_model, EnumDragonAnimations.SWIM3.icedragon_model, EnumDragonAnimations.SWIM4.icedragon_model, EnumDragonAnimations.SWIM5.icedragon_model};
    }

    @Override
    public void init(IceAndFireTabulaModel model) {
        this.neckParts = new AdvancedModelRenderer[]{model.getCube("Neck1"), model.getCube("Neck2"), model.getCube("Neck3"), model.getCube("Neck3"), model.getCube("Head")};
        this.tailParts = new AdvancedModelRenderer[]{model.getCube("Tail1"), model.getCube("Tail2"), model.getCube("Tail3"), model.getCube("Tail4")};
        this.tailPartsWBody = new AdvancedModelRenderer[]{model.getCube("BodyLower"), model.getCube("Tail1"), model.getCube("Tail2"), model.getCube("Tail3"), model.getCube("Tail4")};
        this.toesPartsL = new AdvancedModelRenderer[]{model.getCube("ToeL1"), model.getCube("ToeL2"), model.getCube("ToeL3")};
        this.toesPartsR = new AdvancedModelRenderer[]{model.getCube("ToeR1"), model.getCube("ToeR2"), model.getCube("ToeR3")};
        this.clawL = new AdvancedModelRenderer[]{model.getCube("ClawL")};
        this.clawR = new AdvancedModelRenderer[]{model.getCube("ClawR")};
    }

    @Override
    public void setRotationAngles(IceAndFireTabulaModel model, EntityIceDragon entity, float limbSwing, float limbSwingAmount, float ageInTicks, float rotationYaw, float rotationPitch, float scale) {
        IceAndFireTabulaModel currentPosition;
        int prevIndex;
        int currentIndex;
        model.resetToDefaultPose();
        this.animate(model, entity, limbSwing, limbSwingAmount, ageInTicks, rotationYaw, rotationPitch, scale);
        boolean walking = !entity.isHovering() && !entity.isFlying() && entity.hoverProgress <= 0.0f && entity.flyProgress <= 0.0f;
        boolean swimming = entity.func_70090_H() && entity.swimProgress > 0.0f;
        int n = currentIndex = walking ? entity.walkCycle / 10 : entity.flightCycle / 10;
        if (swimming) {
            currentIndex = entity.swimCycle / 10;
        }
        if ((prevIndex = currentIndex - 1) < 0) {
            int n2 = swimming ? 4 : (prevIndex = walking ? 3 : 5);
        }
        IceAndFireTabulaModel iceAndFireTabulaModel = swimming ? this.swimPoses[currentIndex] : (currentPosition = walking ? this.walkPoses[currentIndex] : this.flyPoses[currentIndex]);
        IceAndFireTabulaModel prevPosition = swimming ? this.swimPoses[prevIndex] : (walking ? this.walkPoses[prevIndex] : this.flyPoses[prevIndex]);
        float delta = (float)(walking ? entity.walkCycle : entity.flightCycle) / 10.0f % 1.0f;
        if (swimming) {
            delta = (float)entity.swimCycle / 10.0f % 1.0f;
        }
        float deltaTicks = delta + LLibrary.PROXY.getPartialTicks() / 10.0f;
        if (delta == 0.0f) {
            deltaTicks = 0.0f;
        }
        for (AdvancedModelRenderer cube : model.getCubes().values()) {
            float z;
            float y;
            float x;
            float prevZ;
            float prevY;
            float prevX;
            AdvancedModelRenderer walkPart;
            this.genderMob(entity, cube);
            if (!swimming && walking && entity.flyProgress <= 0.0f && entity.hoverProgress <= 0.0f && entity.modelDeadProgress <= 0.0f) {
                walkPart = EnumDragonAnimations.GROUND_POSE.icedragon_model.getCube(cube.field_78802_n);
                if (prevPosition.getCube(cube.field_78802_n) != null) {
                    prevX = prevPosition.getCube((String)cube.field_78802_n).field_78795_f;
                    prevY = prevPosition.getCube((String)cube.field_78802_n).field_78796_g;
                    prevZ = prevPosition.getCube((String)cube.field_78802_n).field_78808_h;
                    x = currentPosition.getCube((String)cube.field_78802_n).field_78795_f;
                    y = currentPosition.getCube((String)cube.field_78802_n).field_78796_g;
                    z = currentPosition.getCube((String)cube.field_78802_n).field_78808_h;
                    if (this.isHorn(cube) || this.isWing(model, cube) && (entity.getAnimation() == EntityDragonBase.ANIMATION_WINGBLAST || entity.getAnimation() == EntityDragonBase.ANIMATION_EPIC_ROAR)) {
                        this.addToRotateAngle(cube, limbSwingAmount, walkPart.field_78795_f, walkPart.field_78796_g, walkPart.field_78808_h);
                    } else {
                        this.addToRotateAngle(cube, limbSwingAmount, prevX + deltaTicks * this.distance(prevX, x), prevY + deltaTicks * this.distance(prevY, y), prevZ + deltaTicks * this.distance(prevZ, z));
                    }
                }
            }
            if (entity.modelDeadProgress > 0.0f) {
                if (!this.isPartEqual(cube, EnumDragonAnimations.DEAD.icedragon_model.getCube(cube.field_78802_n))) {
                    this.transitionTo(cube, EnumDragonAnimations.DEAD.icedragon_model.getCube(cube.field_78802_n), entity.modelDeadProgress, 20.0f, cube.field_78802_n.equals("ThighR") || cube.field_78802_n.equals("ThighL"));
                }
                if (cube.field_78802_n.equals("BodyUpper")) {
                    cube.field_78797_d += 0.35f * entity.modelDeadProgress;
                }
            }
            if (entity.sleepProgress > 0.0f && !this.isPartEqual(cube, EnumDragonAnimations.SLEEPING_POSE.icedragon_model.getCube(cube.field_78802_n))) {
                this.transitionTo(cube, EnumDragonAnimations.SLEEPING_POSE.icedragon_model.getCube(cube.field_78802_n), entity.sleepProgress, 20.0f, false);
            }
            if (entity.hoverProgress > 0.0f && !this.isPartEqual(cube, EnumDragonAnimations.HOVERING_POSE.icedragon_model.getCube(cube.field_78802_n)) && !this.isWing(model, cube) && !cube.field_78802_n.contains("Tail")) {
                this.transitionTo(cube, EnumDragonAnimations.HOVERING_POSE.icedragon_model.getCube(cube.field_78802_n), entity.hoverProgress, 20.0f, false);
            }
            if (entity.flyProgress > 0.0f && !this.isPartEqual(cube, EnumDragonAnimations.FLYING_POSE.icedragon_model.getCube(cube.field_78802_n))) {
                this.transitionTo(cube, EnumDragonAnimations.FLYING_POSE.icedragon_model.getCube(cube.field_78802_n), entity.flyProgress - entity.diveProgress * 2.0f, 20.0f, false);
            }
            if (entity.sitProgress > 0.0f && !entity.func_184218_aH() && !this.isPartEqual(cube, EnumDragonAnimations.SITTING_POSE.icedragon_model.getCube(cube.field_78802_n))) {
                this.transitionTo(cube, EnumDragonAnimations.SITTING_POSE.icedragon_model.getCube(cube.field_78802_n), entity.sitProgress, 20.0f, false);
            }
            if (entity.ridingProgress > 0.0f && !this.isHorn(cube) && EnumDragonAnimations.SIT_ON_PLAYER_POSE.icedragon_model.getCube(cube.field_78802_n) != null && !this.isPartEqual(cube, EnumDragonAnimations.SIT_ON_PLAYER_POSE.icedragon_model.getCube(cube.field_78802_n))) {
                this.transitionTo(cube, EnumDragonAnimations.SIT_ON_PLAYER_POSE.icedragon_model.getCube(cube.field_78802_n), entity.ridingProgress, 20.0f, false);
                if (cube.field_78802_n.equals("BodyUpper")) {
                    cube.field_78798_e += (-12.0f - cube.field_78798_e) / 20.0f * entity.ridingProgress;
                }
            }
            if (entity.tackleProgress > 0.0f && !this.isPartEqual(EnumDragonAnimations.TACKLE.icedragon_model.getCube(cube.field_78802_n), EnumDragonAnimations.FLYING_POSE.icedragon_model.getCube(cube.field_78802_n)) && !this.isWing(model, cube)) {
                this.transitionTo(cube, EnumDragonAnimations.TACKLE.icedragon_model.getCube(cube.field_78802_n), entity.tackleProgress, 5.0f, false);
            }
            if (entity.diveProgress > 0.0f && !this.isPartEqual(cube, EnumDragonAnimations.DIVING_POSE.icedragon_model.getCube(cube.field_78802_n))) {
                this.transitionTo(cube, EnumDragonAnimations.DIVING_POSE.icedragon_model.getCube(cube.field_78802_n), entity.diveProgress, 10.0f, false);
            }
            if (entity.swimProgress > 0.0f && !this.isPartEqual(cube, EnumDragonAnimations.SWIM_POSE.icedragon_model.getCube(cube.field_78802_n))) {
                this.transitionTo(cube, EnumDragonAnimations.SWIM_POSE.icedragon_model.getCube(cube.field_78802_n), entity.swimProgress, 20.0f, false);
            }
            if (entity.fireBreathProgress > 0.0f && !this.isPartEqual(cube, EnumDragonAnimations.STREAM_BREATH.icedragon_model.getCube(cube.field_78802_n)) && !this.isWing(model, cube) && !cube.field_78802_n.contains("Finger")) {
                if (entity.prevFireBreathProgress <= entity.fireBreathProgress) {
                    this.transitionTo(cube, EnumDragonAnimations.BLAST_CHARGE3.icedragon_model.getCube(cube.field_78802_n), MathHelper.func_76131_a((float)entity.fireBreathProgress, (float)0.0f, (float)5.0f), 5.0f, false);
                }
                this.transitionTo(cube, EnumDragonAnimations.STREAM_BREATH.icedragon_model.getCube(cube.field_78802_n), MathHelper.func_76131_a((float)(entity.fireBreathProgress - 5.0f), (float)0.0f, (float)5.0f), 5.0f, false);
            }
            if (!walking && !swimming) {
                AdvancedModelRenderer flightPart = EnumDragonAnimations.FLYING_POSE.icedragon_model.getCube(cube.field_78802_n);
                prevX = prevPosition.getCube((String)cube.field_78802_n).field_78795_f;
                prevY = prevPosition.getCube((String)cube.field_78802_n).field_78796_g;
                prevZ = prevPosition.getCube((String)cube.field_78802_n).field_78808_h;
                x = currentPosition.getCube((String)cube.field_78802_n).field_78795_f;
                y = currentPosition.getCube((String)cube.field_78802_n).field_78796_g;
                z = currentPosition.getCube((String)cube.field_78802_n).field_78808_h;
                if (x != flightPart.field_78795_f || y != flightPart.field_78796_g || z != flightPart.field_78808_h) {
                    this.setRotateAngle(cube, 1.0f, prevX + deltaTicks * this.distance(prevX, x), prevY + deltaTicks * this.distance(prevY, y), prevZ + deltaTicks * this.distance(prevZ, z));
                }
            }
            if (!swimming || !(entity.flyProgress <= 0.0f) || !(entity.hoverProgress <= 0.0f) || !(entity.modelDeadProgress <= 0.0f)) continue;
            walkPart = EnumDragonAnimations.SWIM_POSE.icedragon_model.getCube(cube.field_78802_n);
            if (prevPosition.getCube(cube.field_78802_n) == null) continue;
            prevX = prevPosition.getCube((String)cube.field_78802_n).field_78795_f;
            prevY = prevPosition.getCube((String)cube.field_78802_n).field_78796_g;
            prevZ = prevPosition.getCube((String)cube.field_78802_n).field_78808_h;
            x = currentPosition.getCube((String)cube.field_78802_n).field_78795_f;
            y = currentPosition.getCube((String)cube.field_78802_n).field_78796_g;
            z = currentPosition.getCube((String)cube.field_78802_n).field_78808_h;
            if (x == walkPart.field_78795_f && y == walkPart.field_78796_g && z == walkPart.field_78808_h) continue;
            this.setRotateAngle(cube, limbSwingAmount, prevX + deltaTicks * this.distance(prevX, x), prevY + deltaTicks * this.distance(prevY, y), prevZ + deltaTicks * this.distance(prevZ, z));
        }
        float speed_walk = 0.2f;
        float speed_idle = 0.05f;
        float speed_fly = 0.2f;
        float degree_walk = 0.5f;
        float degree_idle = 0.5f;
        float degree_fly = 0.5f;
        if (!entity.func_175446_cd()) {
            if (!walking) {
                model.bob(model.getCube("BodyUpper"), -speed_fly, degree_fly * 5.0f, false, ageInTicks, 1.0f);
                model.walk(model.getCube("BodyUpper"), -speed_fly, degree_fly * 0.1f, false, 0.0f, 0.0f, ageInTicks, 1.0f);
                model.chainWave(this.tailPartsWBody, speed_fly, degree_fly * -0.1f, 0.0, ageInTicks, 1.0f);
                model.chainWave(this.neckParts, speed_fly, degree_fly * 0.2f, -4.0, ageInTicks, 1.0f);
                model.chainWave(this.toesPartsL, speed_fly, degree_fly * 0.2f, -2.0, ageInTicks, 1.0f);
                model.chainWave(this.toesPartsR, speed_fly, degree_fly * 0.2f, -2.0, ageInTicks, 1.0f);
                model.walk(model.getCube("ThighR"), -speed_fly, degree_fly * 0.1f, false, 0.0f, 0.0f, ageInTicks, 1.0f);
                model.walk(model.getCube("ThighL"), -speed_fly, degree_fly * 0.1f, true, 0.0f, 0.0f, ageInTicks, 1.0f);
            } else {
                model.bob(model.getCube("BodyUpper"), speed_walk * 2.0f, degree_walk * 1.7f, false, limbSwing, limbSwingAmount);
                model.bob(model.getCube("ThighR"), speed_walk, degree_walk * 1.7f, false, limbSwing, limbSwingAmount);
                model.bob(model.getCube("ThighL"), speed_walk, degree_walk * 1.7f, false, limbSwing, limbSwingAmount);
                model.chainSwing(this.tailParts, speed_walk, degree_walk * 0.25f, -2.0, limbSwing, limbSwingAmount);
                model.chainWave(this.tailParts, speed_walk, degree_walk * 0.15f, 2.0, limbSwing, limbSwingAmount);
                model.chainSwing(this.neckParts, speed_walk, degree_walk * 0.15f, 2.0, limbSwing, limbSwingAmount);
                model.chainWave(this.neckParts, speed_walk, degree_walk * 0.05f, -2.0, limbSwing, limbSwingAmount);
                model.chainSwing(this.tailParts, speed_idle, degree_idle * 0.25f, -2.0, ageInTicks, 1.0f);
                model.chainWave(this.tailParts, speed_idle, degree_idle * 0.15f, -2.0, ageInTicks, 1.0f);
                model.chainWave(this.neckParts, speed_idle, degree_idle * -0.15f, -3.0, ageInTicks, 1.0f);
                model.walk(model.getCube("Neck1"), speed_idle, degree_idle * 0.05f, false, 0.0f, 0.0f, ageInTicks, 1.0f);
            }
            model.bob(model.getCube("BodyUpper"), speed_idle, degree_idle * 1.3f, false, ageInTicks, 1.0f);
            model.bob(model.getCube("ThighR"), speed_idle, -degree_idle * 1.3f, false, ageInTicks, 1.0f);
            model.bob(model.getCube("ThighL"), speed_idle, -degree_idle * 1.3f, false, ageInTicks, 1.0f);
            model.bob(model.getCube("armR1"), speed_idle, -degree_idle * 1.3f, false, ageInTicks, 1.0f);
            model.bob(model.getCube("armL1"), speed_idle, -degree_idle * 1.3f, false, ageInTicks, 1.0f);
            if (entity.getAnimation() != EntityDragonBase.ANIMATION_SHAKEPREY || entity.getAnimation() != EntityDragonBase.ANIMATION_ROAR) {
                model.faceTarget(rotationYaw, rotationPitch, 4.0f, this.neckParts);
            }
            if (entity.isActuallyBreathingFire()) {
                float speed_shake = 0.7f;
                float degree_shake = 0.1f;
                model.chainFlap(this.neckParts, speed_shake, degree_shake, 2.0, ageInTicks, 1.0f);
                model.chainSwing(this.neckParts, speed_shake * 0.65f, degree_shake * 0.1f, 1.0, ageInTicks, 1.0f);
            }
        }
        if (!entity.isModelDead()) {
            entity.turn_buffer.applyChainSwingBuffer((ModelRenderer[])this.neckParts);
            entity.tail_buffer.applyChainSwingBuffer((ModelRenderer[])this.tailPartsWBody);
            if (entity.flyProgress > 0.0f || entity.hoverProgress > 0.0f) {
                entity.roll_buffer.applyChainFlapBuffer(new ModelRenderer[]{model.getCube("BodyUpper")});
                entity.pitch_buffer_body.applyChainWaveBuffer(new ModelRenderer[]{model.getCube("BodyUpper")});
                entity.pitch_buffer.applyChainWaveBufferReverse((ModelRenderer[])this.tailPartsWBody);
            }
        }
        if (entity.field_70130_N >= 2.0f && entity.flyProgress == 0.0f && entity.hoverProgress == 0.0f) {
            LegArticulator.articulateQuadruped(entity, entity.legSolver, model.getCube("BodyUpper"), model.getCube("BodyLower"), model.getCube("Neck1"), model.getCube("ThighL"), model.getCube("LegL"), this.toesPartsL, model.getCube("ThighR"), model.getCube("LegR"), this.toesPartsR, model.getCube("armL1"), model.getCube("armL2"), this.clawL, model.getCube("armR1"), model.getCube("armR2"), this.clawR, 1.0f, 0.5f, 0.5f, -0.15f, -0.15f, 0.0f, Minecraft.func_71410_x().func_184121_ak());
        }
    }

    private void genderMob(EntityIceDragon entity, AdvancedModelRenderer cube) {
        if (!entity.isMale()) {
            IceAndFireTabulaModel maleModel = EnumDragonAnimations.MALE.icedragon_model;
            IceAndFireTabulaModel femaleModel = EnumDragonAnimations.FEMALE.icedragon_model;
            float x = femaleModel.getCube((String)cube.field_78802_n).field_78795_f;
            float y = femaleModel.getCube((String)cube.field_78802_n).field_78796_g;
            float z = femaleModel.getCube((String)cube.field_78802_n).field_78808_h;
            if (x != maleModel.getCube((String)cube.field_78802_n).field_78795_f || y != maleModel.getCube((String)cube.field_78802_n).field_78796_g || z != maleModel.getCube((String)cube.field_78802_n).field_78808_h) {
                this.setRotateAngle(cube, 1.0f, x, y, z);
            }
        }
    }

    private boolean isWing(IceAndFireTabulaModel model, AdvancedModelRenderer modelRenderer) {
        return model.getCube("armL1") == modelRenderer || model.getCube("armR1") == modelRenderer || model.getCube((String)"armL1").field_78805_m.contains(modelRenderer) || model.getCube((String)"armR1").field_78805_m.contains(modelRenderer);
    }

    private boolean isHorn(AdvancedModelRenderer modelRenderer) {
        return modelRenderer.field_78802_n.contains("Horn");
    }

    public void animate(IceAndFireTabulaModel model, EntityIceDragon entity, float limbSwing, float limbSwingAmount, float ageInTicks, float rotationYaw, float rotationPitch, float scale) {
        model.llibAnimator.update((IAnimatedEntity)entity);
        model.llibAnimator.setAnimation(EntityIceDragon.ANIMATION_FIRECHARGE);
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumDragonAnimations.BLAST_CHARGE1.icedragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumDragonAnimations.BLAST_CHARGE2.icedragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(5);
        this.moveToPose(model, EnumDragonAnimations.BLAST_CHARGE3.icedragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.resetKeyframe(5);
        model.llibAnimator.setAnimation(EntityIceDragon.ANIMATION_SPEAK);
        model.llibAnimator.startKeyframe(5);
        this.rotate(model.llibAnimator, model.getCube("Jaw"), 18.0f, 0.0f, 0.0f);
        model.llibAnimator.move((ModelRenderer)model.getCube("Jaw"), 0.0f, 0.0f, 0.2f);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.setStaticKeyframe(5);
        model.llibAnimator.startKeyframe(5);
        this.rotate(model.llibAnimator, model.getCube("Jaw"), 18.0f, 0.0f, 0.0f);
        model.llibAnimator.move((ModelRenderer)model.getCube("Jaw"), 0.0f, 0.0f, 0.2f);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.resetKeyframe(5);
        model.llibAnimator.setAnimation(EntityIceDragon.ANIMATION_BITE);
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumDragonAnimations.BITE1.icedragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(5);
        this.moveToPose(model, EnumDragonAnimations.BITE2.icedragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(5);
        this.moveToPose(model, EnumDragonAnimations.BITE3.icedragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.resetKeyframe(10);
        model.llibAnimator.setAnimation(EntityIceDragon.ANIMATION_SHAKEPREY);
        model.llibAnimator.startKeyframe(15);
        this.moveToPose(model, EnumDragonAnimations.GRAB1.icedragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumDragonAnimations.GRAB2.icedragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumDragonAnimations.GRAB_SHAKE1.icedragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumDragonAnimations.GRAB_SHAKE2.icedragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumDragonAnimations.GRAB_SHAKE3.icedragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.resetKeyframe(10);
        model.llibAnimator.setAnimation(EntityIceDragon.ANIMATION_TAILWHACK);
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumDragonAnimations.TAIL_WHIP1.icedragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumDragonAnimations.TAIL_WHIP2.icedragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumDragonAnimations.TAIL_WHIP3.icedragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.resetKeyframe(10);
        model.llibAnimator.setAnimation(EntityIceDragon.ANIMATION_WINGBLAST);
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumDragonAnimations.WING_BLAST1.icedragon_model);
        model.llibAnimator.move((ModelRenderer)model.getCube("BodyUpper"), 0.0f, -4.0f, 0.0f);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(5);
        this.moveToPose(model, EnumDragonAnimations.WING_BLAST2.icedragon_model);
        model.llibAnimator.move((ModelRenderer)model.getCube("BodyUpper"), 0.0f, -4.0f, 0.0f);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(5);
        this.moveToPose(model, EnumDragonAnimations.WING_BLAST3.icedragon_model);
        model.llibAnimator.move((ModelRenderer)model.getCube("BodyUpper"), 0.0f, -4.0f, 0.0f);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(5);
        this.moveToPose(model, EnumDragonAnimations.WING_BLAST4.icedragon_model);
        model.llibAnimator.move((ModelRenderer)model.getCube("BodyUpper"), 0.0f, -4.0f, 0.0f);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(5);
        this.moveToPose(model, EnumDragonAnimations.WING_BLAST5.icedragon_model);
        model.llibAnimator.move((ModelRenderer)model.getCube("BodyUpper"), 0.0f, -4.0f, 0.0f);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(5);
        this.moveToPose(model, EnumDragonAnimations.WING_BLAST6.icedragon_model);
        model.llibAnimator.move((ModelRenderer)model.getCube("BodyUpper"), 0.0f, -4.0f, 0.0f);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(5);
        this.moveToPose(model, EnumDragonAnimations.WING_BLAST5.icedragon_model);
        model.llibAnimator.move((ModelRenderer)model.getCube("BodyUpper"), 0.0f, -4.0f, 0.0f);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.resetKeyframe(10);
        model.llibAnimator.setAnimation(EntityIceDragon.ANIMATION_ROAR);
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumDragonAnimations.ROAR1.icedragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumDragonAnimations.ROAR2.icedragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumDragonAnimations.ROAR3.icedragon_model);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.resetKeyframe(10);
        model.llibAnimator.setAnimation(EntityIceDragon.ANIMATION_EPIC_ROAR);
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumDragonAnimations.EPIC_ROAR1.icedragon_model);
        model.llibAnimator.move((ModelRenderer)model.getCube("BodyUpper"), 0.0f, -6.8f, 0.0f);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumDragonAnimations.EPIC_ROAR2.icedragon_model);
        model.llibAnimator.move((ModelRenderer)model.getCube("BodyUpper"), 0.0f, -6.8f, 0.0f);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumDragonAnimations.EPIC_ROAR3.icedragon_model);
        model.llibAnimator.move((ModelRenderer)model.getCube("BodyUpper"), 0.0f, -6.8f, 0.0f);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumDragonAnimations.EPIC_ROAR2.icedragon_model);
        model.llibAnimator.move((ModelRenderer)model.getCube("BodyUpper"), 0.0f, -6.8f, 0.0f);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.startKeyframe(10);
        this.moveToPose(model, EnumDragonAnimations.EPIC_ROAR3.icedragon_model);
        model.llibAnimator.move((ModelRenderer)model.getCube("BodyUpper"), 0.0f, -6.8f, 0.0f);
        model.llibAnimator.endKeyframe();
        model.llibAnimator.resetKeyframe(10);
    }
}

