/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.gui;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.ilexiconn.llibrary.LLibrary;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiLabel;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.ForgeHooksClient;
import org.apache.commons.lang3.StringUtils;

public class IceAndFireMainMenu
extends GuiMainMenu {
    public static final int LAYER_COUNT = 2;
    public static final ResourceLocation splash = new ResourceLocation("iceandfire", "splashes.txt");
    private static final ResourceLocation MINECRAFT_TITLE_TEXTURES = new ResourceLocation("textures/gui/title/minecraft.png");
    private static final ResourceLocation BESTIARY_TEXTURE = new ResourceLocation("iceandfire:textures/gui/main_menu/bestiary_menu.png");
    private static final ResourceLocation TABLE_TEXTURE = new ResourceLocation("iceandfire:textures/gui/main_menu/table.png");
    public static ResourceLocation[] pageFlipTextures;
    public static ResourceLocation[] drawingTextures;
    private final String[] namePartsArray = "Go Play My Other Mods Like Fossils Archeology Revival and Rats And Soon To Be Joined By Other Cool Stuff Too Dont Play The Knock Off Mods".split(" ");
    private int layerTick;
    private String splashText;
    private boolean isFlippingPage = false;
    private int pageFlip = 0;
    private Picture[] drawnPictures;
    private Enscription[] drawnEnscriptions;
    private float globalAlpha = 1.0f;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IceAndFireMainMenu() {
        pageFlipTextures = new ResourceLocation[]{new ResourceLocation("iceandfire", "textures/gui/main_menu/page_1.png"), new ResourceLocation("iceandfire", "textures/gui/main_menu/page_2.png"), new ResourceLocation("iceandfire", "textures/gui/main_menu/page_3.png"), new ResourceLocation("iceandfire", "textures/gui/main_menu/page_4.png"), new ResourceLocation("iceandfire", "textures/gui/main_menu/page_5.png"), new ResourceLocation("iceandfire", "textures/gui/main_menu/page_6.png")};
        for (int i = 0; i < drawingTextures.length; ++i) {
            IceAndFireMainMenu.drawingTextures[i] = new ResourceLocation("iceandfire", "textures/gui/main_menu/drawing_" + (i + 1) + ".png");
        }
        this.resetDrawnImages();
        BufferedReader reader = null;
        try {
            String s;
            ArrayList<String> list = new ArrayList<String>();
            reader = IceAndFireMainMenu.getURLContents("https://raw.githubusercontent.com/Alex-the-666/Ice_and_Fire/1.8.4-1.12.2/src/main/resources/assets/iceandfire/splashes.txt", "assets/iceandfire/splashes.txt");
            while ((s = reader.readLine()) != null) {
                if ((s = s.trim()).isEmpty()) continue;
                list.add(s);
            }
            if (!list.isEmpty()) {
                do {
                    this.splashText = (String)list.get(new Random().nextInt(list.size()));
                } while (this.splashText.hashCode() == 125780783);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static BufferedReader getURLContents(String urlString, String backupFileLoc) {
        InputStream is;
        URL url;
        BufferedReader reader = null;
        boolean useBackup = false;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            url = null;
            useBackup = true;
        }
        if (url != null) {
            URLConnection connection = null;
            try {
                connection = url.openConnection();
                InputStream is2 = connection.getInputStream();
                reader = new BufferedReader(new InputStreamReader(is2));
            }
            catch (IOException e) {
                IceAndFire.logger.error("Ice and Fire couldn't download splash texts for main menu");
                useBackup = true;
            }
        }
        if (useBackup && (is = IceAndFireMainMenu.class.getClassLoader().getResourceAsStream(backupFileLoc)) != null) {
            reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        }
        return reader;
    }

    public void func_73732_a(FontRenderer fontRenderer, String string, int x, int y, int color) {
        if (string.equals(this.splashText)) {
            fontRenderer.func_175063_a(string, (float)(x - fontRenderer.func_78256_a(string) / 2), (float)y, 15853921);
        } else {
            fontRenderer.func_175063_a(string, (float)(x - fontRenderer.func_78256_a(string) / 2), (float)y, color);
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
    }

    private void resetDrawnImages() {
        int x;
        int y;
        int i;
        this.globalAlpha = 0.0f;
        Random random = new Random();
        this.drawnPictures = new Picture[1 + random.nextInt(2)];
        int cornerRight = 32;
        int cornerLeft = 32;
        boolean left = random.nextBoolean();
        for (i = 0; i < this.drawnPictures.length; ++i) {
            left = !left;
            y = random.nextInt(25);
            x = left ? -15 - random.nextInt(20) - 128 : 30 + random.nextInt(20);
            this.drawnPictures[i] = new Picture(random.nextInt(drawingTextures.length - 1), x, y, 0.5f, random.nextFloat() * 0.5f + 0.5f);
        }
        this.drawnEnscriptions = new Enscription[4 + random.nextInt(8)];
        for (i = 0; i < this.drawnEnscriptions.length; ++i) {
            left = !left;
            y = 10 + random.nextInt(130);
            x = left ? -30 - random.nextInt(30) - 50 : 30 + random.nextInt(30);
            String s1 = this.generateNewRandomName(Minecraft.func_71410_x().field_71464_q, 50, random);
            this.drawnEnscriptions[i] = new Enscription(s1, x, y, random.nextFloat() * 0.5f + 0.5f, 10259323);
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        float flipTick = this.layerTick % 40;
        if (this.globalAlpha < 1.0f && !this.isFlippingPage && flipTick < 30.0f) {
            this.globalAlpha += 0.1f;
        }
        if (this.globalAlpha > 0.0f && flipTick > 30.0f) {
            this.globalAlpha -= 0.1f;
        }
        if (flipTick == 0.0f && !this.isFlippingPage) {
            this.isFlippingPage = true;
        }
        if (this.isFlippingPage) {
            if (this.layerTick % 2 == 0) {
                ++this.pageFlip;
            }
            if (this.pageFlip == 6) {
                this.pageFlip = 0;
                this.isFlippingPage = false;
                this.resetDrawnImages();
            }
        }
        ++this.layerTick;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int i;
        GlStateManager.func_179098_w();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        this.field_146297_k.func_110434_K().func_110577_a(TABLE_TEXTURE);
        this.drawTexturedModalRect(0.0, 0.0, 0.0, 0.0, this.field_146294_l, this.field_146295_m, this.field_146294_l, this.field_146295_m, this.field_73735_i);
        this.field_146297_k.func_110434_K().func_110577_a(BESTIARY_TEXTURE);
        this.drawTexturedModalRect(50.0, 0.0, 0.0, 0.0, this.field_146294_l - 100, this.field_146295_m, this.field_146294_l - 100, this.field_146295_m, this.field_73735_i);
        if (this.isFlippingPage) {
            this.field_146297_k.func_110434_K().func_110577_a(pageFlipTextures[Math.min(5, this.pageFlip)]);
            this.drawTexturedModalRect(50.0, 0.0, 0.0, 0.0, this.field_146294_l - 100, this.field_146295_m, this.field_146294_l - 100, this.field_146295_m, this.field_73735_i);
        } else {
            int middleX = this.field_146294_l / 2;
            int middleY = this.field_146295_m / 5;
            float widthScale = (float)this.field_146294_l / 427.0f;
            float imageScale = widthScale * 128.0f;
            for (Enscription enscription : this.drawnEnscriptions) {
                float f2 = 60.0f - partialTicks;
                int color = 10259323;
                int opacity = 10 + (int)(255.0f * enscription.alpha * this.globalAlpha);
                this.field_146297_k.field_71464_q.func_78276_b(enscription.text, (int)((float)enscription.x * widthScale) + middleX, (int)((float)enscription.y * widthScale) + middleY, color | opacity << 24);
            }
            for (Picture picture : this.drawnPictures) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)(picture.alpha * this.globalAlpha + 0.01f));
                this.field_146297_k.func_110434_K().func_110577_a(drawingTextures[picture.image]);
                ScaledResolution res = new ScaledResolution(this.field_146297_k);
                this.drawTexturedModalRect((float)picture.x * widthScale + (float)middleX, (float)picture.y * widthScale + (float)middleY, 0.0, 0.0, imageScale, imageScale, imageScale, imageScale, this.field_73735_i);
            }
        }
        GlStateManager.func_179098_w();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        this.field_146289_q.func_175063_a("Ice and Fire " + ChatFormatting.YELLOW + "1.8.4", 2.0f, (float)(this.field_146295_m - 10), -1);
        GlStateManager.func_179094_E();
        this.field_146297_k.func_110434_K().func_110577_a(MINECRAFT_TITLE_TEXTURES);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.field_146294_l / 2 - 137, 10, 0, 0, 155, 44);
        this.func_73729_b(this.field_146294_l / 2 - 137 + 155, 10, 0, 45, 155, 44);
        GlStateManager.func_179109_b((float)(this.field_146294_l / 2 + 100), (float)85.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)-20.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f1 = 1.8f - MathHelper.func_76135_e((float)(MathHelper.func_76126_a((float)((float)(Minecraft.func_71386_F() % 1000L) / 1000.0f * (float)Math.PI * 2.0f)) * 0.1f));
        f1 = f1 * 100.0f / (float)(this.field_146289_q.func_78256_a(this.splashText) + 32);
        GlStateManager.func_179109_b((float)0.0f, (float)(f1 * 10.0f), (float)0.0f);
        GlStateManager.func_179152_a((float)f1, (float)f1, (float)f1);
        this.func_73732_a(this.field_146289_q, this.splashText, 0, -40, 0xFFFFFF);
        GlStateManager.func_179121_F();
        ForgeHooksClient.renderMainMenu((GuiMainMenu)this, (FontRenderer)this.field_146289_q, (int)this.field_146294_l, (int)this.field_146295_m, (String)"");
        String s1 = "Copyright Mojang AB. Do not distribute!";
        this.func_73731_b(this.field_146289_q, s1, this.field_146294_l - this.field_146289_q.func_78256_a(s1) - 2, this.field_146295_m - 10, -1);
        for (i = 0; i < this.field_146292_n.size(); ++i) {
            ((GuiButton)this.field_146292_n.get(i)).func_191745_a(this.field_146297_k, mouseX, mouseY, LLibrary.PROXY.getPartialTicks());
        }
        for (i = 0; i < this.field_146293_o.size(); ++i) {
            ((GuiLabel)this.field_146293_o.get(i)).func_146159_a(this.field_146297_k, mouseX, mouseY);
        }
    }

    public void drawTexturedModalRect(double x, double y, double u, double v, double width, double height, double textureWidth, double textureHeight, double zLevel) {
        float f = 1.0f / (float)textureWidth;
        float f1 = 1.0f / (float)textureHeight;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        builder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        builder.func_181662_b(x, y + height, zLevel).func_187315_a(u * (double)f, (v + (double)((float)height)) * (double)f1).func_181675_d();
        builder.func_181662_b(x + width, y + height, zLevel).func_187315_a((u + (double)((float)width)) * (double)f, (v + (double)((float)height)) * (double)f1).func_181675_d();
        builder.func_181662_b(x + width, y, zLevel).func_187315_a((u + (double)((float)width)) * (double)f, v * (double)f1).func_181675_d();
        builder.func_181662_b(x, y, zLevel).func_187315_a(u * (double)f, v * (double)f1).func_181675_d();
        tessellator.func_78381_a();
    }

    public String generateNewRandomName(FontRenderer fontRendererIn, int length, Random rand) {
        int i = rand.nextInt(2) + 3;
        String s = "";
        for (int j = 0; j < i; ++j) {
            if (j > 0) {
                s = s + " ";
            }
            s = s + this.namePartsArray[rand.nextInt(this.namePartsArray.length)];
        }
        List list = fontRendererIn.func_78271_c(s, length);
        return StringUtils.join((Iterable)(list.size() >= 2 ? list.subList(0, 2) : list), (String)" ");
    }

    static {
        drawingTextures = new ResourceLocation[18];
    }

    private class Enscription {
        String text;
        int x;
        int y;
        int color;
        float alpha;

        public Enscription(String text, int x, int y, float alpha, int color) {
            this.text = text;
            this.x = x;
            this.y = y;
            this.alpha = alpha;
            this.color = color;
        }
    }

    private class Picture {
        int image;
        int x;
        int y;
        float alpha;
        float scale;

        public Picture(int image, int x, int y, float alpha, float scale) {
            this.image = image;
            this.x = x;
            this.y = y;
            this.alpha = alpha;
            this.scale = scale;
        }
    }
}

