/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.util;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.event.entity.living.LivingDropsEvent;

public final class WorldUtils {
    private static final HashSet<Material> SOLID_MATERIALS = Sets.newHashSet((Object[])new Material[]{Material.field_151576_e, Material.field_151574_g, Material.field_151592_s, Material.field_151573_f, Material.field_151588_w, Material.field_151598_x, Material.field_151591_t, Material.field_76233_E});

    private WorldUtils() {
    }

    public static void playBroadcast(World world, @Nullable SoundEvent event) {
        WorldUtils.playBroadcast(world, event, 1.0f, 1.0f);
    }

    public static void playBroadcast(World world, @Nullable SoundEvent event, float volume, float pitch) {
        if (event == null) {
            return;
        }
        world.func_175661_b(EntityPlayer.class, T -> true).forEach(player -> world.func_184133_a(null, player.func_180425_c(), event, SoundCategory.BLOCKS, volume, pitch));
    }

    public static void removeTask(EntityLiving entity, Class<? extends EntityAIBase> clazz) {
        entity.field_70714_bg.field_75782_a.removeIf(task -> clazz.isAssignableFrom(task.field_75733_a.getClass()));
    }

    public static boolean isSolid(World world, BlockPos pos, EnumFacing facing, IBlockState state) {
        return SOLID_MATERIALS.contains(state.func_185904_a()) && state.func_193401_d((IBlockAccess)world, pos, facing.func_176734_d()) == BlockFaceShape.SOLID;
    }

    public static int getNaturalLightFromNeighbors(World worldIn, BlockPos pos) {
        return WorldUtils.getNaturalLight(worldIn, pos, true, 0);
    }

    private static int getNaturalLight(World worldIn, BlockPos pos, boolean checkNeighbors, int amount) {
        if (pos.func_177958_n() >= -30000000 && pos.func_177952_p() >= -30000000 && pos.func_177958_n() < 30000000 && pos.func_177952_p() < 30000000) {
            if (checkNeighbors && worldIn.func_180495_p(pos).func_185916_f()) {
                int i1 = WorldUtils.getNaturalLight(worldIn, pos.func_177984_a(), false, 0);
                int i = WorldUtils.getNaturalLight(worldIn, pos.func_177974_f(), false, 0);
                int j = WorldUtils.getNaturalLight(worldIn, pos.func_177976_e(), false, 0);
                int k = WorldUtils.getNaturalLight(worldIn, pos.func_177968_d(), false, 0);
                int l = WorldUtils.getNaturalLight(worldIn, pos.func_177978_c(), false, 0);
                if (i > i1) {
                    i1 = i;
                }
                if (j > i1) {
                    i1 = j;
                }
                if (k > i1) {
                    i1 = k;
                }
                if (l > i1) {
                    i1 = l;
                }
                return i1;
            }
            if (pos.func_177956_o() < 0) {
                return 0;
            }
            if (pos.func_177956_o() >= 256) {
                pos = new BlockPos(pos.func_177958_n(), 255, pos.func_177952_p());
            }
            Chunk chunk = worldIn.func_175726_f(pos);
            return WorldUtils.getNaturalLightSubtracted(chunk, pos, amount);
        }
        return 15;
    }

    private static int getNaturalLightSubtracted(Chunk chunkIn, BlockPos pos, int amount) {
        int l;
        int i = pos.func_177958_n() & 0xF;
        int j = pos.func_177956_o();
        int k = pos.func_177952_p() & 0xF;
        ExtendedBlockStorage extendedblockstorage = chunkIn.func_76587_i()[j >> 4];
        if (extendedblockstorage == Chunk.field_186036_a) {
            return chunkIn.func_177412_p().field_73011_w.func_191066_m() && amount < EnumSkyBlock.SKY.field_77198_c ? EnumSkyBlock.SKY.field_77198_c - amount : 0;
        }
        int n = l = !chunkIn.func_177412_p().field_73011_w.func_191066_m() ? 0 : extendedblockstorage.func_76670_c(i, j & 0xF, k);
        if ((l -= amount) < 0) {
            l = 0;
        }
        return l;
    }

    public static double getDistance(BlockPos pos1, BlockPos pos2) {
        assert (pos1 != null);
        assert (pos2 != null);
        return new Vec3d((Vec3i)pos1).func_72438_d(new Vec3d((Vec3i)pos2));
    }

    public static boolean spawnGhast(World world, BlockPos pos) {
        EntityGhast ghast = new EntityGhast(world);
        double failures = 1.0;
        int i = 0;
        double xPos = pos.func_177958_n();
        double yPos = pos.func_177956_o();
        double zPos = pos.func_177952_p();
        do {
            ghast.func_70012_b(xPos, yPos, zPos, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
            AxisAlignedBB box = ghast.func_174813_aQ().func_186670_a(ghast.func_180425_c().func_177981_b(5));
            boolean blocked = StreamSupport.stream(BlockPos.MutableBlockPos.func_177980_a((BlockPos)WorldUtils.getMin(box), (BlockPos)WorldUtils.getMax(box)).spliterator(), false).anyMatch(p -> !world.func_175623_d(p));
            if (!blocked) {
                return world.func_72838_d((Entity)ghast);
            }
            xPos = (double)pos.func_177958_n() + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * Math.max(20.0, failures += 1.0);
            yPos = (double)pos.func_177956_o() + failures;
            zPos = (double)pos.func_177952_p() + (world.field_73012_v.nextDouble() - world.field_73012_v.nextDouble()) * Math.max(20.0, failures);
        } while (++i < 200);
        return false;
    }

    public static boolean isWater(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c() == Blocks.field_150355_j || state.func_177230_c() == Blocks.field_150358_i;
    }

    public static boolean isWaterSource(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c() == Blocks.field_150355_j && (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0;
    }

    public static AxisAlignedBB toInts(AxisAlignedBB box) {
        return new AxisAlignedBB((double)((int)box.field_72340_a), (double)((int)box.field_72338_b), (double)((int)box.field_72339_c), (double)((int)box.field_72336_d), (double)((int)box.field_72337_e), (double)((int)box.field_72334_f));
    }

    public static Set<BlockPos> getPosAround(BlockPos pos, EnumFacing.Axis axis) {
        HashSet posSet = Sets.newHashSet();
        for (int i = -1; i <= 1; ++i) {
            block6: for (int j = -1; j <= 1; ++j) {
                switch (axis) {
                    case X: {
                        posSet.add(pos.func_177982_a(0, i, j));
                        continue block6;
                    }
                    case Y: {
                        posSet.add(pos.func_177982_a(i, 0, j));
                        continue block6;
                    }
                    case Z: {
                        posSet.add(pos.func_177982_a(i, j, 0));
                    }
                }
            }
        }
        return posSet;
    }

    public static BlockPos getMin(AxisAlignedBB box) {
        return new BlockPos(box.field_72340_a, box.field_72338_b, box.field_72339_c);
    }

    public static BlockPos getMax(AxisAlignedBB box) {
        return new BlockPos(box.field_72336_d, box.field_72337_e, box.field_72334_f);
    }

    public static boolean matches(IBlockState a, IBlockState b) {
        return b == null || a.equals(b);
    }

    public static void addDrop(LivingDropsEvent evt, ItemStack drop) {
        EntityItem item = new EntityItem(evt.getEntityLiving().func_130014_f_(), evt.getEntityLiving().field_70165_t, evt.getEntityLiving().field_70163_u, evt.getEntityLiving().field_70161_v, drop);
        item.func_174869_p();
        evt.getDrops().add(item);
    }

    public static boolean isPast(World world, TimeFrame frame) {
        return frame.start < WorldUtils.getDayTicks(world);
    }

    public static boolean isTimeFrame(World world, TimeFrame frame) {
        return frame.isBetween(WorldUtils.getDayTicks(world));
    }

    public static boolean isMoonPhase(World world, MoonPhase phase) {
        return phase.ordinal() == world.field_73011_w.func_76559_b(world.func_72820_D());
    }

    public static int getDayTicks(World world) {
        return (int)((double)world.func_72820_D() % Time.DAY.getTicks());
    }

    public static boolean isPrecipitationAt(World world, BlockPos pos) {
        if (world.func_72896_J() && world.func_175678_i(pos)) {
            return world.func_175725_q(pos).func_177956_o() <= pos.func_177956_o();
        }
        return false;
    }

    public static void setWeatherCleared(MinecraftServer server) {
        for (int i = 0; i < server.field_71305_c.length; ++i) {
            WorldServer world = server.field_71305_c[i];
            WorldInfo info = world.func_72912_H();
            info.func_176142_i((int)Time.DAY.ticks);
            info.func_76080_g(0);
            info.func_76090_f(0);
            info.func_76084_b(false);
            info.func_76069_a(false);
        }
    }

    public static void setAllWorldTimes(MinecraftServer server, TimeFrame time) {
        for (int i = 0; i < server.field_71305_c.length; ++i) {
            server.field_71305_c[i].func_72877_b((long)time.start);
        }
    }

    public static enum TimeFrame {
        DAWN(0, 3600),
        MORNING(1000),
        NOON(5000, 7000),
        DUSK(10200, 12700),
        MIDNIGHT(17000, 19000),
        NIGHT(13001, 24000),
        DAY(0, 13000);

        private static final Random rand;
        private int start;
        private int end;

        private TimeFrame(int start, int end) {
            this.start = start;
            this.end = end;
        }

        private TimeFrame(int time) {
            this(time, time);
        }

        public boolean isBetween(int time) {
            return time >= this.start && time <= this.end;
        }

        public int randomBetween() {
            return rand.nextInt(this.end - this.start + 1) + this.start;
        }

        static {
            rand = new Random();
        }
    }

    public static enum Time {
        SECOND(0.27),
        MINUTE(16.6),
        HOUR(1000.0),
        DAY(24000.0);

        private double ticks;

        private Time(double ticks) {
            this.ticks = ticks;
        }

        public double getTicks() {
            return this.ticks;
        }
    }

    public static enum MoonPhase {
        Full,
        WaningGibbous,
        LastQuarter,
        WaningCrescent,
        New,
        WaxingCrescent,
        FirstQuarter,
        WaxingGibbous;

    }
}

