/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.util;

import betterwithmods.util.VectorBuilder;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class StackEjector {
    private ItemStack stack;
    private VectorBuilder positionBuilder;
    private VectorBuilder motionBuilder;
    private int pickupDelay;

    public StackEjector(VectorBuilder position, VectorBuilder motion) {
        this.positionBuilder = position;
        this.motionBuilder = motion;
    }

    public StackEjector setStack(@Nonnull ItemStack stack) {
        this.stack = stack;
        return this;
    }

    public VectorBuilder getPositionBuilder() {
        return this.positionBuilder;
    }

    public VectorBuilder getMotionBuilder() {
        return this.motionBuilder;
    }

    public void ejectStack(@Nonnull World world, @Nonnull Vec3d p, @Nonnull Vec3d m) {
        Preconditions.checkNotNull((Object)this.stack, (Object)"stack");
        if (world.field_72995_K) {
            return;
        }
        Vec3d position = this.getPositionBuilder().build(p);
        Vec3d motion = this.getMotionBuilder().build(m);
        if (position == null) {
            return;
        }
        EntityItem item = new EntityItem(world, position.field_72450_a, position.field_72448_b, position.field_72449_c, this.stack);
        item.func_174867_a(this.pickupDelay);
        if (motion != null) {
            item.field_70159_w = motion.field_72450_a;
            item.field_70181_x = motion.field_72448_b;
            item.field_70179_y = motion.field_72449_c;
        }
        world.func_72838_d((Entity)item);
    }

    public StackEjector setPickupDelay(int pickupDelay) {
        this.pickupDelay = pickupDelay;
        return this;
    }
}

