/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.util;

import betterwithmods.common.registry.block.recipe.BlockIngredient;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SetBlockIngredient
extends BlockIngredient
implements Set<BlockIngredient> {
    private final Set<BlockIngredient> ingredients = Sets.newHashSet();

    public SetBlockIngredient() {
        super(new ItemStack[0]);
    }

    public SetBlockIngredient(BlockIngredient ... ingredients) {
        super(new ItemStack[0]);
        this.ingredients.addAll(Arrays.asList(ingredients));
    }

    @Override
    public boolean apply(World world, BlockPos pos, @Nullable IBlockState state) {
        return this.ingredients.stream().anyMatch(i -> i.apply(world, pos, state));
    }

    @Override
    public boolean apply(@Nullable ItemStack stack) {
        return this.ingredients.stream().anyMatch(i -> i.apply(stack));
    }

    @Override
    public int size() {
        return this.ingredients.size();
    }

    @Override
    public boolean isEmpty() {
        return this.ingredients.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.ingredients.contains(o);
    }

    @Override
    @Nonnull
    public Iterator<BlockIngredient> iterator() {
        return this.ingredients.iterator();
    }

    @Override
    @Nonnull
    public Object[] toArray() {
        return this.ingredients.toArray();
    }

    @Override
    @Nonnull
    public <T> T[] toArray(@Nonnull T[] ts) {
        return this.ingredients.toArray(ts);
    }

    @Override
    public boolean add(BlockIngredient ingredient) {
        return this.ingredients.add(ingredient);
    }

    @Override
    public boolean remove(Object o) {
        return this.ingredients.remove(o);
    }

    @Override
    public boolean containsAll(@Nonnull Collection<?> collection) {
        return this.ingredients.contains(collection);
    }

    @Override
    public boolean addAll(@Nonnull Collection<? extends BlockIngredient> collection) {
        return this.ingredients.addAll(collection);
    }

    @Override
    public boolean retainAll(@Nonnull Collection<?> collection) {
        return this.ingredients.retainAll(collection);
    }

    @Override
    public boolean removeAll(@Nonnull Collection<?> collection) {
        return this.ingredients.removeAll(collection);
    }

    @Override
    public void clear() {
        this.ingredients.clear();
    }
}

