/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class ExplosionHelper {
    Explosion explosion;
    private final List<BlockPos> affectedBlockPositions;
    private final List<Entity> affectedEntities;

    public ExplosionHelper(Explosion explosion) {
        this.explosion = explosion;
        this.affectedBlockPositions = Lists.newArrayList();
        this.affectedEntities = Lists.newArrayList();
    }

    public World getWorld() {
        return this.explosion.field_77287_j;
    }

    public Vec3d getPosition() {
        return this.explosion.getPosition();
    }

    public Entity getExploder() {
        return this.explosion.field_77283_e;
    }

    public float getSize() {
        return this.explosion.field_77280_f;
    }

    public List<BlockPos> getAffectedBlocks() {
        return this.affectedBlockPositions;
    }

    public List<Entity> getAffectedEntities() {
        return this.affectedEntities;
    }

    public void calculateBlocks(float size, boolean ignoreLiquids) {
        HashSet set = Sets.newHashSet();
        int i = 16;
        this.affectedBlockPositions.clear();
        World world = this.getWorld();
        Vec3d pos = this.getPosition();
        double x = pos.field_72450_a;
        double y = pos.field_72448_b;
        double z = pos.field_72449_c;
        Entity exploder = this.getExploder();
        for (int rx = 0; rx < i; ++rx) {
            for (int ry = 0; ry < i; ++ry) {
                for (int rz = 0; rz < i; ++rz) {
                    if (rx != 0 && rx != i - 1 && ry != 0 && ry != i - 1 && rz != 0 && rz != i - 1) continue;
                    double dx = (float)rx / (float)(i - 1) * 2.0f - 1.0f;
                    double dy = (float)ry / (float)(i - 1) * 2.0f - 1.0f;
                    double dz = (float)rz / (float)(i - 1) * 2.0f - 1.0f;
                    double length = Math.sqrt(dx * dx + dy * dy + dz * dz);
                    dx /= length;
                    dy /= length;
                    dz /= length;
                    float rayDistance = size * (0.7f + world.field_73012_v.nextFloat() * 0.6f);
                    double xRay = x;
                    double yRay = y;
                    double zRay = z;
                    float f1 = 0.3f;
                    float rayWaterDistance = rayDistance;
                    while (rayDistance > 0.0f) {
                        BlockPos blockpos = new BlockPos(xRay, yRay, zRay);
                        IBlockState iblockstate = world.func_180495_p(blockpos);
                        boolean isLiquid = iblockstate.func_185904_a().func_76224_d();
                        if (iblockstate.func_185904_a() != Material.field_151579_a) {
                            float resistance = exploder != null ? exploder.func_180428_a(this.explosion, world, blockpos, iblockstate) : iblockstate.func_177230_c().getExplosionResistance(world, blockpos, null, this.explosion);
                            float cost = (resistance + f1) * f1;
                            rayWaterDistance -= cost;
                        }
                        if (!ignoreLiquids || !isLiquid) {
                            rayDistance = rayWaterDistance;
                        }
                        if (rayDistance > 0.0f && (exploder == null || exploder.func_174816_a(this.explosion, world, blockpos, iblockstate, rayDistance))) {
                            set.add(blockpos);
                        }
                        xRay += dx * (double)f1;
                        yRay += dy * (double)f1;
                        zRay += dz * (double)f1;
                        rayDistance -= 0.225f;
                        rayWaterDistance -= 0.225f;
                    }
                }
            }
        }
        this.affectedBlockPositions.addAll(set);
    }

    public void calculateEntities(float size) {
        this.affectedEntities.clear();
        World world = this.getWorld();
        Vec3d pos = this.getPosition();
        double x = pos.field_72450_a;
        double y = pos.field_72448_b;
        double z = pos.field_72449_c;
        Entity exploder = this.getExploder();
        float doubleSize = size * 2.0f;
        AxisAlignedBB aabb = new AxisAlignedBB(x, y, z, x, y, z).func_186662_g((double)doubleSize + 1.0);
        List list = world.func_72839_b(exploder, aabb);
        for (Entity entity : list) {
            double dz;
            double dy;
            double dx;
            double length;
            double explosionRatio;
            if (entity.func_180427_aV() || !((explosionRatio = entity.func_70011_f(x, y, z) / (double)doubleSize) <= 1.0) || (length = (double)MathHelper.func_76133_a((double)((dx = entity.field_70165_t - x) * dx + (dy = entity.field_70163_u + (double)entity.func_70047_e() - y) * dy + (dz = entity.field_70161_v - z) * dz))) == 0.0) continue;
            this.affectedEntities.add(entity);
        }
    }

    public void createExplosion() {
        World world = this.getWorld();
        Vec3d pos = this.getPosition();
        world.func_72885_a(this.getExploder(), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, this.getSize(), this.causesFire(), this.damagesTerrain());
    }

    private boolean damagesTerrain() {
        return this.explosion.field_82755_b;
    }

    private boolean causesFire() {
        return this.explosion.field_77286_a;
    }
}

