/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.tweaks;

import betterwithmods.common.BWMRecipes;
import betterwithmods.module.Feature;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.RandomUtils;

public class MossGeneration
extends Feature {
    private static HashMap<Block, IBlockState> CONVERTED_BLOCKS = new HashMap();
    public static int RADIUS;
    public static int RATE;
    public static boolean DISABLE_VINE_RECIPES;

    public static void addBlockConversion(Block block, IBlockState mossyState) {
        CONVERTED_BLOCKS.put(block, mossyState);
    }

    @Override
    public void setupConfig() {
        RADIUS = this.loadPropInt("Moss radius from the mob spawner", "", 5);
        RATE = this.loadPropInt("Moss grow rate", "1 out of this rate will cause a moss to try to generate", 100);
        DISABLE_VINE_RECIPES = this.loadPropBool("Disable Vine Recipes", "Disables the mossy cobblestone and mossy brick recipes involving vines.", true);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        if (DISABLE_VINE_RECIPES) {
            BWMRecipes.removeRecipe("minecraft:mossy_cobblestone");
            BWMRecipes.removeRecipe("minecraft:mossy_stonebrick");
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
        MossGeneration.addBlockConversion(Blocks.field_150347_e, Blocks.field_150341_Y.func_176223_P());
        MossGeneration.addBlockConversion(Blocks.field_150417_aV, Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.MOSSY));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void generateMossNearSpawner(TickEvent.WorldTickEvent event) {
        List<BlockPos> positions;
        World world = event.world;
        if (world.field_72995_K || event.phase != TickEvent.Phase.END || event.side != Side.SERVER) {
            return;
        }
        if (world.field_73012_v.nextInt(RATE) != 0) {
            return;
        }
        List list = world.field_147482_g;
        synchronized (list) {
            positions = world.field_147482_g.stream().filter(t -> t instanceof TileEntityMobSpawner).map(TileEntity::func_174877_v).collect(Collectors.toList());
        }
        positions.forEach(pos -> {
            BlockPos min = pos.func_177982_a(-RADIUS, -RADIUS, -RADIUS);
            BlockPos max = pos.func_177982_a(RADIUS, RADIUS, RADIUS);
            MossGeneration.randomPosition(world, min, max).ifPresent(p -> MossGeneration.getMossyVariant(world.func_180495_p(p)).ifPresent(mossy -> world.func_175656_a(p, mossy)));
        });
    }

    private static Optional<BlockPos> randomPosition(World world, BlockPos start, BlockPos end) {
        if (world.func_175707_a(start, end)) {
            return Optional.of(new BlockPos(MossGeneration.randomRange(start.func_177958_n(), end.func_177958_n()), MossGeneration.randomRange(start.func_177956_o(), end.func_177956_o()), MossGeneration.randomRange(start.func_177952_p(), end.func_177952_p())));
        }
        return Optional.empty();
    }

    private static Optional<IBlockState> getMossyVariant(IBlockState state) {
        return Optional.ofNullable(CONVERTED_BLOCKS.get(state.func_177230_c()));
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    @Override
    public String getFeatureDescription() {
        return "Cobblestone or Stonebrick within the spawning radius of a Mob Spawner will randomly grow into the Mossy version.";
    }

    private static int randomRange(int start, int end) {
        int d = end - start;
        return start + RandomUtils.nextInt((int)0, (int)d);
    }
}

