/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.hardcore.world.villagers;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public class VillagerLevel
implements ICapabilitySerializable<NBTTagCompound> {
    @CapabilityInject(value=VillagerLevel.class)
    public static Capability<VillagerLevel> CAPABILITY_LEVEL;
    private int level;
    private int experience;

    public VillagerLevel() {
        this(0, 0);
    }

    public VillagerLevel(int level, int experience) {
        this.level = level;
        this.experience = experience;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CAPABILITY_LEVEL;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (this.hasCapability(capability, facing)) {
            return (T)CAPABILITY_LEVEL.cast((Object)this);
        }
        return null;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("level", this.level);
        tag.func_74768_a("experience", this.experience);
        return tag;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.level = nbt.func_74762_e("level");
        this.experience = nbt.func_74762_e("experience");
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void incrementLevel() {
        ++this.level;
    }

    public void addExperience(int add) {
        this.experience += add;
    }

    public int getExperience() {
        return this.experience;
    }

    public void setExperience(int experience) {
        this.experience = experience;
    }

    public static class Storage
    implements Capability.IStorage<VillagerLevel> {
        @Nullable
        public NBTBase writeNBT(Capability<VillagerLevel> capability, VillagerLevel instance, EnumFacing side) {
            return instance.serializeNBT();
        }

        public void readNBT(Capability<VillagerLevel> capability, VillagerLevel instance, EnumFacing side, NBTBase nbt) {
            instance.deserializeNBT((NBTTagCompound)nbt);
        }
    }
}

