/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.hardcore.world.saplings;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWMRecipes;
import betterwithmods.common.registry.block.recipe.BlockDropIngredient;
import betterwithmods.common.registry.block.recipe.BlockIngredient;
import betterwithmods.module.Feature;
import betterwithmods.module.hardcore.world.saplings.BlockSaplingCrop;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class HCSapling
extends Feature {
    public static List<SaplingConversion> SAPLING_CONVERSIONS = Lists.newArrayList();

    public static IBlockState getSapling(BlockPlanks.EnumType type) {
        return Blocks.field_150345_g.func_176223_P().func_177226_a((IProperty)BlockSapling.field_176480_a, (Comparable)type);
    }

    @Override
    public String getFeatureDescription() {
        return "Change saplings to grow in stages before becoming a tree";
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        for (BlockPlanks.EnumType type : BlockPlanks.EnumType.values()) {
            IBlockState sapling = HCSapling.getSapling(type);
            Block crop = (Block)new BlockSaplingCrop(sapling).setRegistryName("betterwithmods", String.format("sapling_crop_%s", type.func_176610_l()));
            BWMBlocks.registerBlock(crop, null);
            SAPLING_CONVERSIONS.add(new SaplingConversion(new BlockDropIngredient(BWMRecipes.getStackFromState(sapling)), crop));
        }
    }

    @SubscribeEvent
    public void onBlockPlaced(BlockEvent.PlaceEvent event) {
        if (event.getPlacedBlock().func_177230_c() instanceof BlockSapling) {
            IBlockState state = event.getPlacedBlock();
            IBlockState replaced = event.getBlockSnapshot().getReplacedBlock();
            if (replaced.func_185904_a().func_76222_j()) {
                for (SaplingConversion conversion : SAPLING_CONVERSIONS) {
                    if (!conversion.ingredient.apply(event.getWorld(), event.getPos(), state)) continue;
                    event.getWorld().func_175656_a(event.getPos(), conversion.getReplacement().func_176223_P());
                }
            }
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    public class SaplingConversion {
        private final BlockIngredient ingredient;
        private final Block replacement;

        public SaplingConversion(BlockIngredient ingredient, Block replacement) {
            this.ingredient = ingredient;
            this.replacement = replacement;
        }

        public BlockIngredient getIngredient() {
            return this.ingredient;
        }

        public Block getReplacement() {
            return this.replacement;
        }
    }
}

