/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.compat.multipart;

import betterwithmods.module.compat.multipart.MultipartTileProxy;
import java.util.function.Function;
import mcmultipart.api.multipart.IMultipart;
import mcmultipart.api.multipart.IMultipartTile;
import mcmultipart.api.slot.IPartSlot;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class MultipartProxy
implements IMultipart {
    private final Block block;
    private final Function<IBlockState, IPartSlot> placementWrapper;
    private final Function<IBlockState, IPartSlot> worldWrapper;

    public MultipartProxy(Block block, Function<IBlockState, IPartSlot> placementWrapper, Function<IBlockState, IPartSlot> worldWrapper) {
        this.block = block;
        this.placementWrapper = placementWrapper;
        this.worldWrapper = worldWrapper;
    }

    public MultipartProxy(Block block, Function<IBlockState, IPartSlot> wrapper) {
        this(block, wrapper, wrapper);
    }

    public IMultipartTile convertToMultipartTile(TileEntity tileEntity) {
        return MultipartTileProxy.proxy(tileEntity);
    }

    public Block getBlock() {
        return this.block;
    }

    public IPartSlot getSlotForPlacement(World world, BlockPos pos, IBlockState state, EnumFacing facing, float hitX, float hitY, float hitZ, EntityLivingBase placer) {
        return this.placementWrapper.apply(state);
    }

    public IPartSlot getSlotFromWorld(IBlockAccess world, BlockPos pos, IBlockState state) {
        return this.worldWrapper.apply(state);
    }
}

