/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.module.compat.jei.category;

import betterwithmods.module.compat.jei.category.BWMRecipeCategory;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.wrapper.IShapedCraftingRecipeWrapper;
import mezz.jei.util.Translator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class SteelAnvilRecipeCategory
extends BWMRecipeCategory<IRecipeWrapper> {
    public static final int WIDTH = 134;
    public static final int HEIGHT = 72;
    private static final int craftOutputSlot = 16;
    private static final int craftInputSlot1 = 0;
    public static final String UID = "bwm.steel_anvil";
    private static final ResourceLocation location = new ResourceLocation("betterwithmods", "textures/gui/jei/steel_anvil.png");

    public SteelAnvilRecipeCategory(IGuiHelper guiHelper) {
        super((IDrawable)guiHelper.createDrawable(location, 0, 0, 134, 72), UID, Translator.translateToLocal((String)"inv.steel_anvil.name"));
    }

    public void setRecipe(IRecipeLayout recipeLayout, IRecipeWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup stacks = recipeLayout.getItemStacks();
        stacks.init(16, false, 112, 27);
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 4; ++x) {
                int index = 0 + x + y * 4;
                stacks.init(index, true, x * 18, y * 18);
            }
        }
        List inputs = ingredients.getInputs(ItemStack.class);
        List outputs = ingredients.getOutputs(ItemStack.class);
        if (recipeWrapper instanceof IShapedCraftingRecipeWrapper) {
            IShapedCraftingRecipeWrapper wrapper = (IShapedCraftingRecipeWrapper)recipeWrapper;
            this.setInputStacks(stacks, inputs, wrapper.getWidth(), wrapper.getHeight());
        } else {
            this.setInputStacks(stacks, inputs);
        }
        stacks.set(16, (List)outputs.get(0));
    }

    private void setInputStacks(IGuiItemStackGroup guiItemStacks, List<List<ItemStack>> input) {
        int width;
        int height;
        if (input.size() > 9) {
            height = 4;
            width = 4;
        } else if (input.size() > 4) {
            height = 3;
            width = 3;
        } else if (input.size() > 1) {
            height = 2;
            width = 2;
        } else {
            height = 1;
            width = 1;
        }
        this.setInputStacks(guiItemStacks, input, width, height);
    }

    private void setInputStacks(IGuiItemStackGroup guiItemStacks, List<List<ItemStack>> input, int width, int height) {
        for (int i = 0; i < input.size(); ++i) {
            List<ItemStack> recipeItem = input.get(i);
            int index = this.getCraftingIndex(i, width, height);
            this.setInput(guiItemStacks, index, recipeItem);
        }
    }

    private int getCraftingIndex(int i, int width, int height) {
        int x = i % width;
        int y = i / width;
        return x + y * 4;
    }

    private void setInput(IGuiItemStackGroup guiItemStacks, int inputIndex, List<ItemStack> input) {
        if (!input.isEmpty()) {
            guiItemStacks.set(0 + inputIndex, input.get(0));
        }
    }

    private void setOutput(IGuiItemStackGroup guiItemStacks, List<ItemStack> output) {
        guiItemStacks.set(16, output);
    }
}

