/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.registry.heat;

import betterwithmods.api.tile.IHeatSource;
import betterwithmods.common.registry.block.recipe.BlockIngredient;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BWMHeatRegistry {
    public static final int UNSTOKED_HEAT = 1;
    public static final int STOKED_HEAT = 2;
    private static final List<HeatSource> HEAT_SOURCES = Lists.newArrayList();

    public static void addHeatSource(BlockIngredient ingredient, int heat) {
        HEAT_SOURCES.add(new HeatSource(ingredient, heat));
    }

    public static int getHeat(World world, BlockPos pos) {
        HeatSource source = BWMHeatRegistry.get(world, pos);
        if (source != null) {
            return source.getHeat();
        }
        return 0;
    }

    public static HeatSource get(World world, BlockPos pos) {
        for (HeatSource bm : HEAT_SOURCES) {
            if (!bm.matches(world, pos)) continue;
            return bm;
        }
        return null;
    }

    public static int[] allHeatLevels() {
        return HEAT_SOURCES.stream().mapToInt(h -> ((HeatSource)h).heat).distinct().toArray();
    }

    public static List<ItemStack> getStacks(int heat) {
        return HEAT_SOURCES.stream().filter(s -> ((HeatSource)s).heat == heat).map(s -> ((HeatSource)s).ingredient.func_193365_a()).flatMap(Arrays::stream).filter(s -> !s.func_190926_b()).collect(Collectors.toList());
    }

    public static class HeatSource
    implements IHeatSource {
        private BlockIngredient ingredient;
        private int heat;

        public HeatSource(BlockIngredient ingredient, int heat) {
            this.ingredient = ingredient;
            this.heat = heat;
        }

        @Override
        public int getHeat() {
            return this.heat;
        }

        @Override
        public boolean matches(World world, BlockPos pos) {
            return this.ingredient.apply(world, pos, world.func_180495_p(pos));
        }
    }
}

