/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.registry.crafting;

import betterwithmods.common.registry.crafting.IngredientTool;
import java.util.function.Predicate;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;

public abstract class ToolBaseRecipe
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    private ResourceLocation group;
    protected Predicate<ItemStack> isTool;
    protected ItemStack result;
    protected Ingredient input;

    public ToolBaseRecipe(ResourceLocation group, ItemStack result, Ingredient input, Predicate<ItemStack> isTool) {
        this.group = group;
        this.isTool = isTool;
        this.result = result;
        this.input = input;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isMatch(IInventory inv, World world) {
        boolean hasTool = false;
        boolean hasInput = false;
        for (int x = 0; x < inv.func_70302_i_(); ++x) {
            boolean inRecipe = false;
            ItemStack slot = inv.func_70301_a(x);
            if (slot.func_190926_b()) continue;
            if (this.isTool.test(slot)) {
                if (hasTool) return false;
                hasTool = true;
                inRecipe = true;
            } else if (this.input.apply(slot)) {
                if (hasInput) return false;
                hasInput = true;
                inRecipe = true;
            }
            if (inRecipe) continue;
            return false;
        }
        if (!hasTool) return false;
        if (!hasInput) return false;
        return true;
    }

    public ItemStack getExampleStack() {
        return ItemStack.field_190927_a;
    }

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        return this.isMatch((IInventory)inv, worldIn);
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        return this.result.func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public ItemStack func_77571_b() {
        return this.result.func_77946_l();
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        this.playSound(inv);
        return NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
    }

    public String func_193358_e() {
        if (this.group != null) {
            return this.group.toString();
        }
        return "";
    }

    public abstract void playSound(InventoryCrafting var1);

    public abstract SoundEvent getSound();

    public abstract Pair<Float, Float> getSoundValues();

    public NonNullList<Ingredient> func_192400_c() {
        NonNullList ingredients = NonNullList.func_191196_a();
        ingredients.add((Object)this.input);
        ingredients.add((Object)new IngredientTool(this.isTool, this.getExampleStack()));
        return ingredients;
    }
}

