/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.registry.block.recipe;

import betterwithmods.api.tile.IHeatRecipe;
import betterwithmods.common.registry.KilnStructureManager;
import betterwithmods.common.registry.block.recipe.BlockIngredient;
import betterwithmods.common.registry.block.recipe.BlockRecipe;
import betterwithmods.event.FakePlayerHandler;
import betterwithmods.util.InvUtils;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class KilnRecipe
extends BlockRecipe
implements IHeatRecipe {
    private int heat;
    private boolean ignoreHeat;

    public KilnRecipe(BlockIngredient input, List<ItemStack> outputs, int heat) {
        super(input, outputs);
        this.heat = heat;
    }

    @Override
    public int getHeat() {
        return this.heat;
    }

    @Override
    public boolean ignore() {
        return this.ignoreHeat;
    }

    public KilnRecipe setIgnoreHeat(boolean ignoreHeat) {
        this.ignoreHeat = ignoreHeat;
        return this;
    }

    @Override
    public boolean craftRecipe(World world, BlockPos pos, Random rand, IBlockState state) {
        InvUtils.ejectStackWithOffset(world, pos, this.onCraft(world, pos));
        state.func_177230_c().func_176208_a(world, pos, state, (EntityPlayer)FakePlayerHandler.getPlayer());
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), world.field_72995_K ? 11 : 3);
        return true;
    }

    @Override
    public boolean matches(World world, BlockPos pos, IBlockState state) {
        if (super.matches(world, pos, state)) {
            if (!this.ignore()) {
                int heat = KilnStructureManager.getHeat(world, pos.func_177977_b());
                return heat == this.getHeat();
            }
            return true;
        }
        return false;
    }
}

