/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.items;

import betterwithmods.client.BWCreativeTabs;
import betterwithmods.common.entity.EntityDynamite;
import betterwithmods.network.BWNetwork;
import betterwithmods.network.messages.MessageFXDynamite;
import betterwithmods.util.ExplosionHelper;
import betterwithmods.util.InvUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;

public class ItemDynamite
extends Item {
    private static final Ingredient FLINT_AND_STEEL = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Items.field_151033_d, 1, Short.MAX_VALUE)});
    public static boolean needsOffhand;
    public static boolean newtonianThrow;
    public static boolean bloodThrow;
    public static boolean dispenseLit;
    public static ThreadLocal<Float> fuseOverride;

    public ItemDynamite() {
        this.func_77637_a(BWCreativeTabs.BWTAB);
        this.func_185043_a(new ResourceLocation("betterwithmods", "fuse"), (stack, worldIn, entityIn) -> {
            if (fuseOverride.get() != null) {
                return fuseOverride.get().floatValue();
            }
            if (entityIn == null) {
                return 0.0f;
            }
            if (!entityIn.func_184587_cr() || entityIn.func_184607_cu() != stack) {
                return 0.0f;
            }
            float value = (float)(stack.func_77988_m() - entityIn.func_184605_cv()) / (float)stack.func_77988_m();
            return value;
        });
    }

    public static void setFuseOverride(float fuseSlide) {
        fuseOverride.set(Float.valueOf(fuseSlide));
    }

    public static void resetFuseOverride() {
        fuseOverride.set(null);
    }

    public int getFuseTime() {
        return 100;
    }

    public int func_77626_a(ItemStack stack) {
        return bloodThrow ? this.getFuseTime() : super.func_77626_a(stack);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return bloodThrow ? EnumAction.BOW : super.func_77661_b(stack);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack held = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            boolean lit;
            ItemStack activator = this.getActivator(player, hand);
            if (!activator.func_190926_b()) {
                activator.func_77972_a(1, (EntityLivingBase)player);
            }
            boolean bl = lit = !activator.func_190926_b();
            if (bloodThrow && lit) {
                world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187904_gd, SoundCategory.AMBIENT, 1.0f, 1.0f);
                player.func_184598_c(hand);
            } else {
                if (lit) {
                    world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187904_gd, SoundCategory.AMBIENT, 1.0f, 1.0f);
                }
                this.throwDynamite(world, (EntityLivingBase)player, held, lit ? this.getFuseTime() : 0);
                held.func_190918_g(1);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)held);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)held);
    }

    public void func_77615_a(ItemStack held, World world, EntityLivingBase entity, int timeLeft) {
        if (!world.field_72995_K) {
            this.throwDynamite(world, entity, held, Math.max(timeLeft, 1));
        }
        held.func_190918_g(1);
    }

    public ItemStack func_77654_b(ItemStack held, World world, EntityLivingBase entity) {
        if (!world.field_72995_K) {
            this.throwDynamite(world, entity, held, 1);
        }
        held.func_190918_g(1);
        return held;
    }

    private void throwDynamite(World world, EntityLivingBase entity, ItemStack held, int fuse) {
        EntityDynamite dynamite = new EntityDynamite(world, entity, fuse);
        dynamite.setDynamiteStack(held);
        if (newtonianThrow) {
            dynamite.func_70024_g(entity.field_70159_w, entity.field_70181_x, entity.field_70179_y);
        }
        world.func_72838_d((Entity)dynamite);
        world.func_184133_a(null, new BlockPos(dynamite.field_70165_t, dynamite.field_70163_u, dynamite.field_70161_v), SoundEvents.field_187737_v, SoundCategory.AMBIENT, 0.5f, 0.4f / (Item.field_77697_d.nextFloat() * 0.4f + 0.8f));
    }

    public void explode(EntityDynamite entity) {
        float intensity = 1.5f;
        Explosion explosion = new Explosion(entity.field_70170_p, (Entity)entity, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, intensity, false, true);
        ExplosionHelper helper = new ExplosionHelper(explosion);
        helper.calculateBlocks(3.0f, true);
        helper.createExplosion();
        entity.redneckFishing(entity.func_180425_c(), helper.getAffectedBlocks(), 0.05f);
        BWNetwork.sendToAllAround(new MessageFXDynamite(explosion.getPosition(), explosion.field_77280_f, helper.getAffectedBlocks(), explosion.func_180343_e()), entity.field_70170_p, entity.func_180425_c());
    }

    private ItemStack getActivator(EntityPlayer player, EnumHand hand) {
        if (needsOffhand) {
            ItemStack otherHand = player.func_184586_b(InvUtils.otherHand(hand));
            if (FLINT_AND_STEEL.apply(otherHand)) {
                return otherHand;
            }
        } else {
            return InvUtils.findItemInInventory(FLINT_AND_STEEL, (IItemHandler)InvUtils.getPlayerInventory(player, null));
        }
        return ItemStack.field_190927_a;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(I18n.func_135052_a((String)("lore.bwm:" + this.getRegistryName().func_110623_a()), (Object[])new Object[0]));
        if (bloodThrow) {
            tooltip.add(I18n.func_135052_a((String)"lore.bwm:dynamite_blood", (Object[])new Object[0]));
        }
    }

    static {
        fuseOverride = new ThreadLocal();
    }
}

