/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.entity.ai.eat;

import java.util.List;
import java.util.Optional;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public abstract class EntityAIEatFood<T extends EntityLivingBase>
extends EntityAIBase {
    protected T entity;
    private Ingredient validItem;
    private EntityItem targetItem;
    private double distance;

    public EntityAIEatFood(T entity, Ingredient validItem, double distance) {
        this.entity = entity;
        this.validItem = validItem;
        this.distance = distance;
    }

    private Optional<EntityItem> getTargetItem(List<EntityItem> items) {
        if (items.isEmpty()) {
            return Optional.empty();
        }
        EntityItem target = null;
        for (EntityItem item : items) {
            if (!this.validItem.apply(item.func_92059_d())) continue;
            target = item;
            break;
        }
        return Optional.ofNullable(target);
    }

    public void func_75251_c() {
        this.targetItem = null;
    }

    public boolean func_75250_a() {
        if (!this.isReady()) {
            return false;
        }
        BlockPos entityPos = this.entity.func_180425_c();
        if (this.targetItem == null) {
            List entityItems = this.entity.func_130014_f_().func_175647_a(EntityItem.class, new AxisAlignedBB(entityPos, entityPos.func_177982_a(1, 1, 1)).func_186662_g(this.distance), entity -> entity != null && entity.field_70122_E);
            this.targetItem = this.getTargetItem(entityItems).orElse(null);
        }
        if (this.targetItem != null) {
            BlockPos targetPos = this.targetItem.func_180425_c();
            if (entityPos.func_185332_f(targetPos.func_177958_n(), targetPos.func_177956_o(), targetPos.func_177952_p()) <= this.distance) {
                this.processItemEating();
                return false;
            }
            return true;
        }
        return false;
    }

    public abstract boolean isReady();

    public abstract void onEaten(ItemStack var1);

    public boolean func_75253_b() {
        return this.func_75250_a();
    }

    private void processItemEating() {
        ItemStack foodStack;
        if (this.targetItem != null && !(foodStack = this.targetItem.func_92059_d()).func_190926_b()) {
            this.onEaten(foodStack);
        }
    }
}

